/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Point3d;
import net.geocentral.geometria.util.GBase64Utils;
import org.apache.log4j.Logger;

public class GStringUtils {
    public static final Pattern COORDS_PATTERN = Pattern.compile("\\s*([0-9\\+\\-\\.E]+)\\s+([0-9\\+\\-\\.E]+)\\s+([0-9\\+\\-\\.E]+)\\s*");
    private static final Random random = new Random();
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public static Point3d coordsFromString(String stringCoords) {
        Matcher matcher = COORDS_PATTERN.matcher(stringCoords);
        if (!matcher.matches()) {
            return null;
        }
        try {
            double x = Double.valueOf(matcher.group(1));
            double y = Double.valueOf(matcher.group(2));
            double z = Double.valueOf(matcher.group(3));
            return new Point3d(x, y, z);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String coordsToString(Point3d coords) {
        return GStringUtils.coordsToString(coords, false);
    }

    public static String coordsToString(Point3d coords, boolean bracket) {
        StringBuffer buf = new StringBuffer();
        if (bracket) {
            buf.append('[');
        }
        buf.append(coords.x).append(' ').append(coords.y).append(' ').append(coords.z);
        if (bracket) {
            buf.append(']');
        }
        return String.valueOf(buf);
    }

    public static String stackTraceToString(Exception exception) {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        exception.printStackTrace(out);
        return ((Object)writer).toString();
    }

    public static String fromXml(String str) {
        str = str.replace("&lt;", "<");
        str = str.replace("&gt;", ">");
        str = str.replace("&quot;", "\"");
        str = str.replace("&#39;", "'");
        str = str.replace("&amp;", "&");
        return str;
    }

    public static String toXml(String str) {
        str = str.replace("&", "&amp;");
        str = str.replace("<", "&lt;");
        str = str.replace(">", "&gt;");
        str = str.replace("\"", "&quot;");
        str = str.replace("'", "&#39;");
        return str;
    }

    public static String encode(String value) {
        logger.info((Object)value);
        StringBuffer buf = new StringBuffer();
        int salt = random.nextInt(900000) + 100000;
        for (char c : String.valueOf(salt).toCharArray()) {
            buf.append((char)(75 + Integer.valueOf(String.valueOf(c))));
        }
        byte[] bytes = value.getBytes();
        int byteIndex = 0;
        while (byteIndex < bytes.length) {
            int n = byteIndex++;
            bytes[n] = (byte)(bytes[n] + salt);
        }
        String encoded = GBase64Utils.encode(bytes);
        buf.append(encoded);
        return buf.toString();
    }

    public static String decode(String value) {
        logger.info((Object)value);
        StringBuffer saltBuf = new StringBuffer();
        String encodedSalt = value.substring(0, 6);
        for (char c : encodedSalt.toCharArray()) {
            saltBuf.append(String.valueOf(c - 75));
        }
        int salt = Integer.valueOf(saltBuf.toString());
        String encodedValue = value.substring(6);
        byte[] bytes = GBase64Utils.decode(encodedValue);
        int byteIndex = 0;
        while (byteIndex < bytes.length) {
            int n = byteIndex++;
            bytes[n] = (byte)(bytes[n] - salt);
        }
        String decoded = new String(bytes);
        return decoded;
    }
}

