/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.util;

import java.util.LinkedHashSet;
import javax.vecmath.Point3d;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;

public class GPointSetUtils {
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    private GPointSetUtils() {
    }

    public static Point3d[] fromString(String s, String figureName, GDocument document) throws Exception {
        GFigure figure = document.getFigure(figureName);
        return GPointSetUtils.fromString(s, figure);
    }

    public static Point3d[] fromString(String s, GFigure figure) throws Exception {
        int i;
        String[] tokens = s.split(",");
        Point3d[] coords = new Point3d[tokens.length];
        for (i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
            tokens[i] = tokens[i].replace("[", "").replace("]", "");
        }
        if (tokens.length == 1 && tokens[0].length() == 0) {
            return new Point3d[0];
        }
        for (i = 0; i < tokens.length; ++i) {
            if (tokens[i].matches("[A-Z][0-9]*")) {
                if (figure == null) {
                    logger.info((Object)("No point: " + tokens[i]));
                    throw new Exception(GDictionary.get("NoSuchPoint", tokens[i]));
                }
                GPoint3d p = figure.getSolid().getPoint(tokens[i]);
                if (p == null) {
                    logger.info((Object)("No point in figure: " + tokens[i] + ", " + figure));
                    throw new Exception(GDictionary.get("NoSuchPointInFigure", tokens[i], figure.getName()));
                }
                coords[i] = new Point3d(p.coords);
                continue;
            }
            coords[i] = GStringUtils.coordsFromString(tokens[i]);
            if (coords[i] != null) continue;
            logger.info((Object)("Bad coordinates: " + tokens[i]));
            throw new Exception(GDictionary.get("BadCoordinates", tokens[i]));
        }
        return coords;
    }

    public static String[] fromSelection(GDocument document) {
        GFigure figure = document.getSelectedFigure();
        if (figure == null) {
            return new String[0];
        }
        LinkedHashSet<String> labels = new LinkedHashSet<String>();
        for (GSelectable element : figure.getSolid().getSelection()) {
            if (element instanceof GFace) {
                for (int i = 0; i < 3; ++i) {
                    String label = ((GFace)element).labelAt(i);
                    labels.add(label);
                }
                continue;
            }
            if (element instanceof GStick) {
                labels.add(((GStick)element).label1);
                labels.add(((GStick)element).label2);
                continue;
            }
            if (!(element instanceof GPoint3d)) continue;
            labels.add(((GPoint3d)element).getLabel());
        }
        return labels.toArray(new String[labels.size()]);
    }
}

