/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.util;

import java.util.Collection;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class GBoundingSphere
implements Cloneable {
    private Point3d center;
    private double radius;

    public GBoundingSphere() {
    }

    public GBoundingSphere(List<Point3d> points, double epsilon) {
        int numIterations = (int)(1.0 / epsilon);
        Point3d c = new Point3d(0.0, 0.0, 0.0);
        for (int i = 0; i < numIterations; ++i) {
            Point3d x = this.furthestPoint(points, c);
            x.sub((Tuple3d)c);
            x.scale(1.0 / (double)(1 + i));
            x.add((Tuple3d)c);
            c = new Point3d(x);
        }
        this.center = c;
        this.radius = this.furthestPoint(points, c).distance(c);
    }

    public GBoundingSphere clone() {
        GBoundingSphere bs = new GBoundingSphere();
        bs.radius = this.radius;
        bs.center = new Point3d(this.center);
        return bs;
    }

    private Point3d furthestPoint(Collection<Point3d> points, Point3d c) {
        double maxDistance = 0.0;
        Point3d fp = null;
        for (Point3d p : points) {
            double distance = c.distance(p);
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
            fp = p;
        }
        return new Point3d(fp);
    }

    public Point3d getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }
}

