/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model.answer.condition;

import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import net.geocentral.geometria.action.GRenameFigureAction;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.answer.condition.GFigureCondition;
import net.geocentral.geometria.model.answer.condition.GPlaneCondition;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GMath;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GVolumeCutInRatioCondition
implements GPlaneCondition,
GFigureCondition {
    private String figureName;
    public double ratio;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public void make(Element node, GProblem document) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() < 1) {
            logger.error((Object)("Figure name: " + ns.getLength()));
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        if (document.getFigure(this.figureName) == null) {
            logger.error((Object)this.figureName);
            throw new Exception();
        }
        NodeList nns = node.getElementsByTagName("value");
        if (nns.getLength() < 1) {
            logger.error((Object)("Value: " + nns.getLength()));
            throw new Exception();
        }
        String valueString = nns.item(0).getTextContent();
        Double r = GMath.evaluate(valueString);
        if (r == null) {
            logger.error((Object)valueString);
            throw new Exception();
        }
        this.ratio = r;
    }

    @Override
    public void validate(String valueString, GDocument document) throws Exception {
        logger.info((Object)valueString);
        GFigure figure = document.getSelectedFigure();
        if (figure == null) {
            logger.info((Object)"No figure selected");
            throw new Exception(GDictionary.get("NoFigureSelected", new String[0]));
        }
        if (valueString.length() == 0) {
            throw new Exception(GDictionary.get("EnterValidExpressionForRatio", new String[0]));
        }
        this.figureName = figure.getName();
        GNotepadVariable variable = document.getVariable(valueString);
        if (variable != null) {
            this.ratio = variable.getValue();
        } else {
            List<GNotepadVariable> variables = document.getNotepad().getVariables();
            Double r = GMath.evaluate(valueString, variables);
            if (r == null) {
                logger.info((Object)("Bad expression: " + valueString));
                throw new Exception(GDictionary.get("EnterValidExpressionForRatio", new String[0]));
            }
            this.ratio = r;
        }
        if (this.ratio <= 0.0) {
            logger.info((Object)("Ratio must be positive: " + this.ratio));
            throw new Exception(GDictionary.get("RatioMustBePositive", new String[0]));
        }
    }

    @Override
    public boolean verify(Point3d[] cs, GDocument document) {
        logger.info(Arrays.asList(cs));
        GFigure figure = document.getFigure(this.figureName);
        if (figure == null) {
            return false;
        }
        GSolid solid = figure.getSolid();
        Vector3d n = GMath.cross(cs[0], cs[1], cs[2]);
        n.normalize();
        GSolid fragment1 = solid.clone();
        GSolid fragment2 = solid.clone();
        try {
            fragment1.cutOff(cs[0], n);
            n.scale(-1.0);
            fragment2.cutOff(cs[0], n);
        }
        catch (Exception exception) {
            return false;
        }
        double r = fragment1.computeVolume() / fragment2.computeVolume();
        return Math.abs(r - this.ratio) < 1.0E-7 || Math.abs(1.0 / r - this.ratio) < 1.0E-7;
    }

    @Override
    public void figureRenamed(GRenameFigureAction action) {
        logger.info((Object)"");
        if (action.getOldFigureName().equals(this.figureName)) {
            this.figureName = action.getNewFigureName();
        }
    }

    @Override
    public void renameFigureUndone(GRenameFigureAction action) {
        logger.info((Object)"");
        if (action.getNewFigureName().equals(this.figureName)) {
            this.figureName = action.getOldFigureName();
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<condition>");
        buf.append("\n<type>volumeCutInRatio</type>");
        buf.append("\n<figureName>");
        buf.append(this.figureName);
        buf.append("</figureName>");
        buf.append("\n<value>");
        buf.append(String.valueOf(this.ratio));
        buf.append("</value>");
        buf.append("\n</condition>");
    }

    @Override
    public String getStringValue() {
        return String.valueOf(this.ratio);
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }

    @Override
    public String getDescription() {
        return GDictionary.get("VolumeCutInRatio", new String[0]);
    }
}

