/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model.answer;

import java.util.LinkedHashMap;
import java.util.Map;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GProblem;
import net.geocentral.geometria.model.answer.GAnswer;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GMultipleChoiceAnswer
implements GAnswer {
    private LinkedHashMap<String, Boolean> options;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GMultipleChoiceAnswer() {
    }

    public GMultipleChoiceAnswer(LinkedHashMap<String, Boolean> options) {
        logger.info(options);
        this.options = options;
    }

    @Override
    public void make(Element node, GProblem document) throws Exception {
        logger.info((Object)"");
        this.options = new LinkedHashMap();
        NodeList ns = node.getElementsByTagName("option");
        if (ns.getLength() < 1) {
            logger.error((Object)"No options");
            throw new Exception();
        }
        for (int i = 0; i < ns.getLength(); ++i) {
            boolean selected;
            Element n = (Element)ns.item(i);
            String option = n.getTextContent().trim();
            if (option.isEmpty()) {
                logger.error((Object)String.format("Empty option at index %s", i));
                throw new Exception();
            }
            if (document.isLocked()) {
                String decodedOption = GStringUtils.decode(option);
                if (decodedOption == null) {
                    logger.error((Object)String.format("Unencoded multiple choice answer option %s in locked problem", option));
                    throw new Exception();
                }
                selected = decodedOption.charAt(decodedOption.length() - 1) == '1';
                this.options.put(decodedOption.substring(0, decodedOption.length() - 1), selected);
                continue;
            }
            String attributeValue = n.getAttribute("selected");
            selected = false;
            if (!attributeValue.isEmpty()) {
                try {
                    selected = Boolean.valueOf(attributeValue);
                }
                catch (Exception exception) {
                    logger.error((Object)String.format("Invalid option attribute: %s", attributeValue));
                    throw new Exception();
                }
            }
            this.options.put(option, selected);
        }
    }

    @Override
    public boolean validate(String valueString, String figureName, GDocument document) {
        return this.options.containsValue(true);
    }

    public boolean verify(int selectedOptionIndex) {
        int optionIndex = 0;
        for (Map.Entry<String, Boolean> entry : this.options.entrySet()) {
            boolean selected = entry.getValue();
            if (selected) {
                return optionIndex == selectedOptionIndex;
            }
            ++optionIndex;
        }
        return false;
    }

    @Override
    public void serialize(StringBuffer buf, boolean lock) {
        logger.info((Object)"");
        buf.append("\n<answer>");
        buf.append("\n<type>multipleChoice</type>");
        for (Map.Entry<String, Boolean> entry : this.options.entrySet()) {
            String option = entry.getKey();
            buf.append("\n<option");
            boolean selected = entry.getValue();
            if (selected && !lock) {
                buf.append(" selected=\"true\"");
            }
            buf.append(String.format(">", option));
            if (lock) {
                String encodedOption = GStringUtils.encode(option + (selected ? 1 : 0));
                buf.append(encodedOption);
            } else {
                buf.append(option);
            }
            buf.append(String.format("</option>", option));
        }
        buf.append("\n</answer>");
    }

    public Map<String, Boolean> getOptions() {
        return this.options;
    }

    public static Map<String, Boolean> getDefaultOptions() {
        LinkedHashMap<String, Boolean> defaultOptions = new LinkedHashMap<String, Boolean>();
        defaultOptions.put("", true);
        return defaultOptions;
    }

    public String toString() {
        for (Map.Entry<String, Boolean> entry : this.options.entrySet()) {
            boolean selected = entry.getValue();
            if (!selected) continue;
            return entry.getKey();
        }
        return null;
    }
}

