/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import net.geocentral.geometria.model.GAuthor;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class GDocumentEnvelope
implements Cloneable {
    private GAuthor author;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GDocumentEnvelope() {
        this.author = new GAuthor();
        this.comments = "";
    }

    public GDocumentEnvelope(GAuthor author, String comments) {
        logger.info((Object)(author + ", " + comments));
        this.author = author;
        this.comments = comments;
    }

    public GDocumentEnvelope clone() {
        logger.info((Object)this);
        return new GDocumentEnvelope(this.author.clone(), this.comments);
    }

    public void make(Element node) {
        logger.info((Object)"");
        Element n = (Element)node.getElementsByTagName("author").item(0);
        this.author = new GAuthor();
        this.author.make(n);
        String s = node.getElementsByTagName("comments").item(0).getTextContent();
        this.comments = GStringUtils.fromXml(s);
    }

    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<envelope>");
        this.author.serialize(buf);
        if (this.comments.length() == 0) {
            buf.append("\n<comments/>");
        } else {
            buf.append("\n<comments>");
            String s = GStringUtils.toXml(this.comments);
            buf.append(s).append("</comments>");
        }
        buf.append("\n</envelope>");
    }

    public GAuthor getAuthor() {
        return this.author;
    }

    public String getComments() {
        return this.comments;
    }

    public String toString() {
        return String.format("Author: %s, comments: %s", this.author, this.comments);
    }
}

