/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JTextField;
import net.geocentral.geometria.evaluator.GEvaluator;
import net.geocentral.geometria.evaluator.token.GToken;
import net.geocentral.geometria.evaluator.token.GTokenBounds;
import net.geocentral.geometria.evaluator.token.GVariable;
import net.geocentral.geometria.model.GCalculation;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GNotepadRecord;
import net.geocentral.geometria.model.GNotepadVariable;
import net.geocentral.geometria.util.GDictionary;
import org.apache.log4j.Logger;

public class GCalculator
extends KeyAdapter {
    private JTextField textField;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GNotepadRecord evaluate(GDocument document) throws Exception {
        double value;
        logger.info((Object)"");
        List<GNotepadVariable> variables = null;
        if (document != null) {
            variables = document.getNotepad().getVariables();
        }
        String input = this.textField.getText();
        int expressionOffset = 0;
        String variableName = null;
        String expression = null;
        String[] ts = input.split("=");
        if (ts.length > 2) {
            int pos = input.lastIndexOf(61);
            this.select(pos, pos + 1);
            logger.info((Object)(input + ", " + pos));
            throw new Exception(GDictionary.get("MisplacedEqualitySign", new String[0]));
        }
        if (ts.length == 2) {
            expression = ts[1];
            expressionOffset = expression.indexOf(61) + 1;
            variableName = ts[0].trim();
            if (!variableName.matches("[a-zA-Z\\p{InCyrillic}_][0-9a-zA-Z\\p{InCyrillic}_]*")) {
                logger.info((Object)String.format("Bad variable: %s, %s", input, variableName));
                throw new Exception(GDictionary.get("InvalidVariable", variableName));
            }
            if (variables != null) {
                for (GNotepadVariable p : variables) {
                    if (!p.getName().equals(variableName)) continue;
                    logger.info((Object)String.format("Duplicate variable: %s, %s", input, variableName));
                    throw new Exception(GDictionary.get("DuplicateVariable", variableName));
                }
            }
        } else {
            expression = input;
        }
        GEvaluator evaluator = new GEvaluator(variables);
        try {
            value = evaluator.evaluate(expression);
        }
        catch (Exception exception) {
            GTokenBounds tokenBounds = evaluator.getErrorTokenBounds();
            this.select(expressionOffset + tokenBounds.offset, expressionOffset + tokenBounds.offset + tokenBounds.size);
            throw exception;
        }
        logger.info((Object)("Value: " + value));
        if (document != null && variableName != null) {
            List<GToken> tokens = evaluator.getPostfixTokens();
            LinkedHashSet<GNotepadVariable> params = new LinkedHashSet<GNotepadVariable>();
            for (GToken token : tokens) {
                if (!(token instanceof GVariable)) continue;
                GNotepadVariable param = document.getVariable(((GVariable)token).getName());
                params.add(param);
            }
            expression = expression.replaceAll(" +", "");
            GCalculation calculation = new GCalculation(expression);
            GNotepadVariable variable = new GNotepadVariable(variableName, value);
            GNotepadRecord record = new GNotepadRecord(variable, calculation);
            logger.info((Object)("Record: " + record));
            return record;
        }
        NumberFormat formatter = NumberFormat.getNumberInstance(Locale.ENGLISH);
        formatter.setMaximumFractionDigits(15);
        String text = formatter.format(value);
        this.textField.setText(text);
        return null;
    }

    public void setTextField(JTextField textField) {
        this.textField = textField;
    }

    public void clear() {
        this.textField.setText(null);
    }

    public void select(int pos1, int pos2) {
        this.textField.select(pos1, pos2);
        this.textField.requestFocus();
    }

    public boolean isEmpty() {
        return this.textField.getText().trim().length() == 0;
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }
}

