/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.model;

import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class GAuthor
implements Cloneable {
    private String name;
    private String email;
    private String web;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    public GAuthor() {
        this.name = GDictionary.get("Anonymous", new String[0]);
        this.email = "";
        this.web = "";
    }

    public GAuthor(String name, String email, String web) {
        logger.info((Object)(name + ", " + email + ", " + web));
        this.name = name;
        this.email = email;
        this.web = web;
    }

    public GAuthor clone() {
        GAuthor author = new GAuthor();
        author.name = this.name;
        author.email = this.email;
        author.web = this.web;
        return author;
    }

    public void set(GAuthor author) {
        logger.info((Object)author);
        this.name = author.name;
        this.email = author.email;
        this.web = author.web;
    }

    public void make(Element node) {
        logger.info((Object)"");
        String s = node.getElementsByTagName("name").item(0).getTextContent();
        this.name = GStringUtils.fromXml(s);
        s = node.getElementsByTagName("email").item(0).getTextContent();
        this.email = GStringUtils.fromXml(s);
        s = node.getElementsByTagName("web").item(0).getTextContent();
        this.web = GStringUtils.fromXml(s);
    }

    public void serialize(StringBuffer buf) {
        String s;
        logger.info((Object)"");
        buf.append("\n<author>");
        if (this.name.length() == 0) {
            buf.append("\n<name/>");
        } else {
            buf.append("\n<name>");
            s = GStringUtils.toXml(this.name);
            buf.append(s);
            buf.append("</name>");
        }
        if (this.email.length() == 0) {
            buf.append("\n<email/>");
        } else {
            buf.append("\n<email>");
            s = GStringUtils.toXml(this.email);
            buf.append(s);
            buf.append("</email>");
        }
        if (this.web.length() == 0) {
            buf.append("\n<web/>");
        } else {
            buf.append("\n<web>");
            s = GStringUtils.toXml(this.web);
            buf.append(s);
            buf.append("</web>");
        }
        buf.append("\n</author>");
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getWeb() {
        return this.web;
    }

    public String toString() {
        return "Name: " + this.name + ", email: " + this.email + ", web:" + this.web;
    }
}

