/*
 * Decompiled with CFR 0.152.
 */
package net.geocentral.geometria.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.geocentral.geometria.action.GActionWithHelp;
import net.geocentral.geometria.action.GDocumentHandler;
import net.geocentral.geometria.action.GFigureAction;
import net.geocentral.geometria.action.GLoggable;
import net.geocentral.geometria.model.GDocument;
import net.geocentral.geometria.model.GFace;
import net.geocentral.geometria.model.GFigure;
import net.geocentral.geometria.model.GLine;
import net.geocentral.geometria.model.GPoint3d;
import net.geocentral.geometria.model.GSelectable;
import net.geocentral.geometria.model.GSolid;
import net.geocentral.geometria.model.GStick;
import net.geocentral.geometria.util.GDictionary;
import net.geocentral.geometria.util.GStringUtils;
import net.geocentral.geometria.view.GEraseLineDialog;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GEraseLineAction
implements GLoggable,
GFigureAction,
GActionWithHelp {
    private String figureName;
    private String p1Label;
    private String p2Label;
    private GDocument document;
    private GFigure figure;
    private GSolid solid;
    private GFace face;
    private GLine removedLine;
    private List<GPoint3d> removedPoints;
    private List<GLine> addedLines;
    private String helpId;
    private String comments;
    private static Logger logger = Logger.getLogger((String)"net.geocentral.geometria");

    @Override
    public boolean execute() {
        return this.execute(false);
    }

    @Override
    public boolean execute(boolean silent) {
        GSolid solid;
        GDocumentHandler documentHandler;
        block6: {
            logger.info((Object)silent);
            documentHandler = GDocumentHandler.getInstance();
            this.document = documentHandler.getActiveDocument();
            if (silent) {
                try {
                    this.validateApply();
                }
                catch (Exception exception) {
                    return false;
                }
            }
            GFigure figure = this.document.getSelectedFigure();
            this.figureName = figure.getName();
            solid = figure.getSolid();
            Set<GSelectable> selection = solid.getSelection();
            this.prefill(selection);
            try {
                this.validateApply();
            }
            catch (Exception exception) {
                GEraseLineDialog dialog = new GEraseLineDialog(documentHandler.getOwnerFrame(), this);
                dialog.prefill(this.p1Label, this.p2Label);
                dialog.setVisible(true);
                if (dialog.getResult()) break block6;
                return false;
            }
        }
        solid.clearSelection();
        this.document.getNotepad().lineErased(this);
        documentHandler.notepadChanged();
        this.document.setSelectedFigure(this.figureName);
        this.document.getSelectedFigure().repaint();
        if (!silent) {
            documentHandler.setDocumentModified(true);
        }
        logger.info((Object)(this.figureName + ", " + this.p1Label + ", " + this.p2Label));
        return true;
    }

    private void prefill(Set<GSelectable> selection) {
        GSelectable element;
        logger.info(selection);
        if (selection.isEmpty()) {
            return;
        }
        Iterator<GSelectable> it = selection.iterator();
        if (selection.size() == 1 && (element = it.next()) instanceof GStick) {
            this.p1Label = ((GStick)element).label1;
            this.p2Label = ((GStick)element).label2;
        }
        if (selection.size() == 2) {
            GSelectable element1 = it.next();
            GSelectable element2 = it.next();
            if (element1 instanceof GPoint3d && element2 instanceof GPoint3d) {
                this.p1Label = ((GPoint3d)element1).getLabel();
                this.p2Label = ((GPoint3d)element2).getLabel();
            }
        }
    }

    public void validateApply() throws Exception {
        logger.info((Object)"");
        if (this.p1Label.length() == 0 || this.p2Label.length() == 0) {
            logger.info((Object)("No end points: " + this.p1Label + ", " + this.p2Label));
            throw new Exception(GDictionary.get("EnterEndPoints", new String[0]));
        }
        this.figure = this.document.getFigure(this.figureName);
        this.solid = this.figure.getSolid();
        GPoint3d p1 = this.solid.getPoint(this.p1Label);
        if (p1 == null) {
            logger.info((Object)("No point: " + this.p1Label));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.p1Label));
        }
        GPoint3d p2 = this.solid.getPoint(this.p2Label);
        if (p2 == null) {
            logger.info((Object)("No point: " + this.p2Label));
            throw new Exception(GDictionary.get("FigureContainsNoPoint", this.figureName, this.p2Label));
        }
        if (p1 == p2) {
            logger.info((Object)("Equal end points: " + p1 + ", " + p2));
            throw new Exception(GDictionary.get("EndPointsCannotBeEqual", new String[0]));
        }
        Collection<GFace> faces = this.solid.facesThroughPoints(new String[]{this.p1Label, this.p2Label});
        if (faces.size() > 1) {
            logger.info((Object)("Edge: " + this.p1Label + ", " + this.p2Label));
            throw new Exception(GDictionary.get("CannotEraseEdgeInFigure", this.p1Label + this.p2Label, this.figureName));
        }
        Collection<GLine> lines = this.solid.linesThroughPoints(this.p1Label, this.p2Label);
        if (lines.isEmpty()) {
            logger.info((Object)("No line: " + this.p1Label + ", " + this.p2Label));
            throw new Exception(GDictionary.get("NoLinePassesThroughPoints", this.p1Label, this.p2Label, this.figureName));
        }
        this.face = faces.iterator().next();
        this.addedLines = new ArrayList<GLine>();
        this.removedPoints = new ArrayList<GPoint3d>();
        ArrayList<String> labels = new ArrayList<String>();
        this.removedLine = this.face.removeLine(p1, p2, this.addedLines, labels);
        for (String label : labels) {
            GPoint3d p = this.solid.getPoint(label);
            this.removedPoints.add(p);
            this.solid.removePoint(label);
        }
        this.solid.makeConfig();
    }

    @Override
    public void undo(GDocumentHandler documentHandler) {
        logger.info((Object)"");
        this.solid.clearSelection();
        this.face.undoRemoveLine(this.removedLine, this.addedLines);
        for (GPoint3d p : this.removedPoints) {
            this.solid.undoRemovePoint(p);
        }
        this.document.getNotepad().eraseLineUndone(this);
        documentHandler.notepadChanged();
        this.solid.makeConfig();
        this.figure.repaint();
        this.document.setSelectedFigure(this.figureName);
        logger.info((Object)(this.figureName + ", " + this.p1Label + ", " + this.p2Label));
    }

    @Override
    public GLoggable clone() {
        GEraseLineAction action = new GEraseLineAction();
        action.figureName = this.figureName;
        action.p1Label = this.p1Label;
        action.p2Label = this.p2Label;
        return action;
    }

    @Override
    public String toLogString() {
        return GDictionary.get("EraseLineInFigure", this.p1Label + this.p2Label, this.figureName);
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public void setComments(String comments) {
        this.comments = comments;
    }

    @Override
    public void make(Element node) throws Exception {
        logger.info((Object)"");
        NodeList ns = node.getElementsByTagName("figureName");
        if (ns.getLength() == 0) {
            logger.error((Object)"No figure name");
            throw new Exception();
        }
        this.figureName = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p1Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p1Label");
            throw new Exception();
        }
        this.p1Label = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("p2Label");
        if (ns.getLength() == 0) {
            logger.error((Object)"No p2Label");
            throw new Exception();
        }
        this.p2Label = ns.item(0).getTextContent();
        ns = node.getElementsByTagName("comments");
        if (ns.getLength() > 0) {
            String s = ns.item(0).getTextContent();
            this.comments = GStringUtils.fromXml(s);
        }
    }

    @Override
    public void serialize(StringBuffer buf) {
        logger.info((Object)"");
        buf.append("\n<action>").append("\n<className>").append(this.getClass().getSimpleName()).append("</className>").append("\n<figureName>").append(this.figureName).append("</figureName>").append("\n<p1Label>").append(this.p1Label).append("</p1Label>").append("\n<p2Label>").append(this.p2Label).append("</p2Label>");
        if (this.comments != null) {
            String s = GStringUtils.toXml(this.comments);
            buf.append("\n<comments>").append(s).append("</comments>");
        }
        buf.append("\n</action>");
    }

    public void setInput(String p1String, String p2String) {
        logger.info((Object)(p1String + ", " + p2String));
        this.p1Label = p1String.toUpperCase();
        this.p2Label = p2String.toUpperCase();
    }

    @Override
    public String getShortDescription() {
        return GDictionary.get("eraseLine", this.p1Label + this.p2Label);
    }

    public List<GPoint3d> getRemovedPoints() {
        return this.removedPoints;
    }

    @Override
    public String getFigureName() {
        return this.figureName;
    }

    @Override
    public String getHelpId() {
        return this.helpId;
    }

    @Override
    public void setHelpId(String helpId) {
        this.helpId = helpId;
    }
}

