/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fatcalc.core;

import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FatCategory {
    OBESE("OBESE"),
    ACCEPTABLE("ACCEPTABLE"),
    FITNESS("FITNESS"),
    ATHLETES("ATHLETES"),
    ESSENTIAL_FAT("ESSENTIAL"),
    CRITICAL("CRITICAL");

    private String description;
    private final ResourceBundle bundle = ResourceBundle.getBundle("net/sourceforge/fatcalc/core/resources/FatCategory");

    private FatCategory(String description) {
        this.description = this.bundle.getString(description);
    }

    public String getDescription() {
        return this.description;
    }

    public static FatCategory getCategory(boolean female, double percentage) {
        if (female) {
            return FatCategory.getFemaleCategory(percentage);
        }
        return FatCategory.getMaleCategory(percentage);
    }

    private static FatCategory getFemaleCategory(double percentage) {
        if (percentage > 32.0) {
            return OBESE;
        }
        if (percentage > 25.0) {
            return ACCEPTABLE;
        }
        if (percentage > 21.0) {
            return FITNESS;
        }
        if (percentage > 14.0) {
            return ATHLETES;
        }
        if (percentage > 10.0) {
            return ESSENTIAL_FAT;
        }
        return CRITICAL;
    }

    private static FatCategory getMaleCategory(double percentage) {
        if (percentage > 25.0) {
            return OBESE;
        }
        if (percentage > 18.0) {
            return ACCEPTABLE;
        }
        if (percentage > 14.0) {
            return FITNESS;
        }
        if (percentage > 6.0) {
            return ATHLETES;
        }
        if (percentage > 2.0) {
            return ESSENTIAL_FAT;
        }
        return CRITICAL;
    }
}

