/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fatcalc.core;

import java.util.EnumMap;
import net.sourceforge.fatcalc.core.FatCategory;
import net.sourceforge.fatcalc.core.FatMethod;
import net.sourceforge.fatcalc.core.SkinFold;

public final class FatCalculator {
    private FatMethod method;
    private int age;
    private double weight;
    private boolean female;
    private EnumMap<SkinFold, Double> folds = new EnumMap(SkinFold.class);
    private double fatPercentage;
    private double fatWeight;
    private double leanWeight;

    public FatCalculator() {
        this.reset();
    }

    public FatCalculator(int age, double weight, boolean female) {
        this();
        this.age = age;
        this.weight = weight;
        this.female = female;
    }

    public void reset() {
        this.method = FatMethod.JACKSON_POLLOCK_3;
        this.age = 0;
        this.weight = Double.NaN;
        this.female = false;
        this.fatPercentage = Double.NaN;
        this.fatWeight = Double.NaN;
        this.leanWeight = Double.NaN;
        for (SkinFold sf : SkinFold.values()) {
            this.folds.put(sf, Double.NaN);
        }
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int value) {
        this.age = value;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double value) {
        this.weight = value;
    }

    public boolean isFemale() {
        return this.female;
    }

    public void setFemale(boolean value) {
        this.female = value;
    }

    public FatMethod getMethod() {
        return this.method;
    }

    public void setMethod(FatMethod value) {
        this.method = value;
    }

    public double getFatPercentage() {
        return this.fatPercentage;
    }

    public double getFatWeight() {
        return this.fatWeight;
    }

    public double getLeanWeight() {
        return this.leanWeight;
    }

    public double getFold(SkinFold fold) {
        return this.folds.get((Object)fold);
    }

    public void setFold(SkinFold fold, double value) {
        this.folds.put(fold, value);
    }

    private double siriEquation(double bodyDensity) {
        return 495.0 / bodyDensity - 450.0;
    }

    private double jacksonPollock3(double s3) {
        if (this.female) {
            return this.siriEquation(1.099421 - 9.929E-4 * s3 + 2.3E-6 * s3 * s3 - 1.392E-4 * (double)this.age);
        }
        return this.siriEquation(1.10938 - 8.267E-4 * s3 + 1.6E-6 * s3 * s3 - 2.574E-4 * (double)this.age);
    }

    private double jacksonPollock7(double s7) {
        if (this.female) {
            return this.siriEquation(1.097 - 4.6971E-4 * s7 + 5.6E-7 * s7 * s7 - 1.2828E-4 * (double)this.age);
        }
        return this.siriEquation(1.112 - 4.3499E-4 * s7 + 5.5E-7 * s7 * s7 - 2.8826E-4 * (double)this.age);
    }

    private double parillo(double s9) {
        return 27.0 * s9 / (this.weight * 2.20462);
    }

    private double sloan(double thigh, double subscapular) {
        return this.siriEquation(1.1043 - 0.001327 * thigh - 0.00131 * subscapular);
    }

    private double lohmann(double s3) {
        return this.siriEquation(1.0982 - 8.15E-4 * s3 + 8.4E-6 * s3 * s3);
    }

    private double durningWomersley(double s4) {
        return this.siriEquation(1.1714 - 0.063 * Math.log10(s4) - 4.06E-4 * (double)this.age);
    }

    private double nhca(double s4) {
        return 0.27784 * s4 - 5.3E-4 * s4 * s4 + 0.12437 * (double)this.age - 3.28791;
    }

    private double forsythSinning(double abdominal, double tricep, double subscapular, double midaxillary) {
        return this.siriEquation(1.10647 - 0.00144 * abdominal - 7.7E-4 * tricep - 0.00162 * subscapular + 7.1E-4 * midaxillary);
    }

    private double calculateSum(SkinFold[] sumFolds) {
        double sum = 0.0;
        for (SkinFold fold : sumFolds) {
            double value = this.getFold(fold);
            if (Double.isNaN(value)) {
                sum = value;
                break;
            }
            sum += value;
        }
        return sum;
    }

    public double calculate() {
        double sum = 0.0;
        this.fatPercentage = Double.NaN;
        this.fatWeight = Double.NaN;
        this.leanWeight = Double.NaN;
        if (this.method.isAgeNeeded() && this.age == 0) {
            return Double.NaN;
        }
        if (Double.isNaN(this.weight)) {
            return Double.NaN;
        }
        if (this.female && !this.method.isFemale()) {
            return Double.NaN;
        }
        if (this.method.isUsingSum()) {
            sum = this.female ? this.calculateSum(this.method.getFoldsFemale()) : this.calculateSum(this.method.getFoldsMale());
        }
        switch (this.method) {
            case JACKSON_POLLOCK_3: {
                this.fatPercentage = this.jacksonPollock3(sum);
                break;
            }
            case JACKSON_POLLOCK_7: {
                this.fatPercentage = this.jacksonPollock7(sum);
                break;
            }
            case PARILLO: {
                this.fatPercentage = this.parillo(sum);
                break;
            }
            case SLOAN: {
                this.fatPercentage = this.sloan(this.getFold(SkinFold.THIGH), this.getFold(SkinFold.SUBSCAPULAR));
                break;
            }
            case LOHMANN: {
                this.fatPercentage = this.lohmann(sum);
                break;
            }
            case NHCA: {
                this.fatPercentage = this.nhca(sum);
                break;
            }
            case FORSYTH_SINNING: {
                this.fatPercentage = this.forsythSinning(this.getFold(SkinFold.ABDOMINAL), this.getFold(SkinFold.TRICEP), this.getFold(SkinFold.SUBSCAPULAR), this.getFold(SkinFold.MIDAXILLARY));
                break;
            }
            case DURNING_WOMERSLEY: {
                this.fatPercentage = this.durningWomersley(sum);
            }
        }
        this.fatWeight = this.weight * (this.fatPercentage / 100.0);
        this.leanWeight = this.weight - this.fatWeight;
        return this.fatPercentage;
    }

    public String toString() {
        return "%=" + Double.toString(this.fatPercentage);
    }

    public String getResultDescription() {
        if (Double.isNaN(this.fatPercentage)) {
            return null;
        }
        return FatCategory.getCategory(this.female, this.fatPercentage).getDescription();
    }
}

