/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Label;
import java.awt.Scrollbar;
import java.util.StringTokenizer;

class VarRailElm
extends RailElm {
    Scrollbar slider;
    Label label;
    String sliderText;

    public VarRailElm(int n, int n2) {
        super(n, n2, 6);
        this.sliderText = "Voltage";
        this.frequency = this.maxVoltage;
        this.createSlider();
    }

    public VarRailElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
        this.sliderText = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            this.sliderText = this.sliderText + ' ' + stringTokenizer.nextToken();
        }
        this.createSlider();
    }

    String dump() {
        return super.dump() + " " + this.sliderText;
    }

    int getDumpType() {
        return 172;
    }

    void createSlider() {
        this.waveform = 6;
        this.label = new Label(this.sliderText, 1);
        CirSim.main.add(this.label);
        int n = (int)((this.frequency - this.bias) * 100.0 / (this.maxVoltage - this.bias));
        this.slider = new Scrollbar(0, n, 1, 0, 101);
        CirSim.main.add(this.slider);
        CirSim.main.validate();
    }

    double getVoltage() {
        this.frequency = (double)this.slider.getValue() * (this.maxVoltage - this.bias) / 100.0 + this.bias;
        return this.frequency;
    }

    void delete() {
        CirSim.main.remove(this.label);
        CirSim.main.remove(this.slider);
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Min Voltage", this.bias, -20.0, 20.0);
        }
        if (n == 1) {
            return new EditInfo("Max Voltage", this.maxVoltage, -20.0, 20.0);
        }
        if (n == 2) {
            EditInfo editInfo = new EditInfo("Slider Text", 0.0, -1.0, -1.0);
            editInfo.text = this.sliderText;
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.bias = editInfo.value;
        }
        if (n == 1) {
            this.maxVoltage = editInfo.value;
        }
        if (n == 2) {
            this.sliderText = editInfo.textf.getText();
            this.label.setText(this.sliderText);
        }
    }

    int getShortcut() {
        return 0;
    }
}

