/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Graphics;
import java.util.StringTokenizer;

class SweepElm
extends CircuitElm {
    double maxV;
    double maxF;
    double minF;
    double sweepTime;
    double frequency;
    final int FLAG_LOG = 1;
    final int FLAG_BIDIR = 2;
    final int circleSize = 17;
    double fadd;
    double fmul;
    double freqTime;
    double savedTimeStep;
    int dir = 1;
    double v;

    public SweepElm(int n, int n2) {
        super(n, n2);
        this.minF = 20.0;
        this.maxF = 4000.0;
        this.maxV = 5.0;
        this.sweepTime = 0.1;
        this.flags = 2;
        this.reset();
    }

    public SweepElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        this.minF = new Double(stringTokenizer.nextToken());
        this.maxF = new Double(stringTokenizer.nextToken());
        this.maxV = new Double(stringTokenizer.nextToken());
        this.sweepTime = new Double(stringTokenizer.nextToken());
        this.reset();
    }

    int getDumpType() {
        return 170;
    }

    int getPostCount() {
        return 1;
    }

    String dump() {
        return super.dump() + " " + this.minF + " " + this.maxF + " " + this.maxV + " " + this.sweepTime;
    }

    void setPoints() {
        super.setPoints();
        this.lead1 = this.interpPoint(this.point1, this.point2, 1.0 - 17.0 / this.dn);
    }

    void draw(Graphics graphics) {
        this.setBbox(this.point1, this.point2, 17.0);
        this.setVoltageColor(graphics, this.volts[0]);
        SweepElm.drawThickLine(graphics, this.point1, this.lead1);
        graphics.setColor(this.needsHighlight() ? selectColor : Color.gray);
        this.setPowerColor(graphics, false);
        int n = this.point2.x;
        int n2 = this.point2.y;
        SweepElm.drawThickCircle(graphics, n, n2, 17);
        int n3 = 8;
        this.adjustBbox(n - 17, n2 - 17, n + 17, n2 + 17);
        int n4 = 10;
        int n5 = -1;
        int n6 = -1;
        long l = System.currentTimeMillis();
        if ((l %= 2000L) > 1000L) {
            l = 2000L - l;
        }
        double d = 1.0 + (double)l * 0.002;
        if (!SweepElm.sim.stoppedCheck.getState()) {
            d = 1.0 + 2.0 * (this.frequency - this.minF) / (this.maxF - this.minF);
        }
        for (int i = -n4; i <= n4; ++i) {
            int n7 = n2 + (int)(0.95 * Math.sin((double)i * Math.PI * d / (double)n4) * (double)n3);
            if (n5 != -1) {
                SweepElm.drawThickLine(graphics, n5, n6, n + i, n7);
            }
            n5 = n + i;
            n6 = n7;
        }
        if (SweepElm.sim.showValuesCheckItem.getState()) {
            String string = SweepElm.getShortUnitText(this.frequency, "Hz");
            if (this.dx == 0 || this.dy == 0) {
                this.drawValues(graphics, string, 17.0);
            }
        }
        this.drawPosts(graphics);
        this.curcount = this.updateDotCount(-this.current, this.curcount);
        if (SweepElm.sim.dragElm != this) {
            this.drawDots(graphics, this.point1, this.lead1, this.curcount);
        }
    }

    void stamp() {
        sim.stampVoltageSource(0, this.nodes[0], this.voltSource);
    }

    void setParams() {
        if (this.frequency < this.minF || this.frequency > this.maxF) {
            this.frequency = this.minF;
            this.freqTime = 0.0;
            this.dir = 1;
        }
        if ((this.flags & 1) == 0) {
            this.fadd = (double)this.dir * SweepElm.sim.timeStep * (this.maxF - this.minF) / this.sweepTime;
            this.fmul = 1.0;
        } else {
            this.fadd = 0.0;
            this.fmul = Math.pow(this.maxF / this.minF, (double)this.dir * SweepElm.sim.timeStep / this.sweepTime);
        }
        this.savedTimeStep = SweepElm.sim.timeStep;
    }

    void reset() {
        this.frequency = this.minF;
        this.freqTime = 0.0;
        this.dir = 1;
        this.setParams();
    }

    void startIteration() {
        if (SweepElm.sim.timeStep != this.savedTimeStep) {
            this.setParams();
        }
        this.v = Math.sin(this.freqTime) * this.maxV;
        this.freqTime += this.frequency * 2.0 * Math.PI * SweepElm.sim.timeStep;
        this.frequency = this.frequency * this.fmul + this.fadd;
        if (this.frequency >= this.maxF && this.dir == 1) {
            if ((this.flags & 2) != 0) {
                this.fadd = -this.fadd;
                this.fmul = 1.0 / this.fmul;
                this.dir = -1;
            } else {
                this.frequency = this.minF;
            }
        }
        if (this.frequency <= this.minF && this.dir == -1) {
            this.fadd = -this.fadd;
            this.fmul = 1.0 / this.fmul;
            this.dir = 1;
        }
    }

    void doStep() {
        sim.updateVoltageSource(0, this.nodes[0], this.voltSource, this.v);
    }

    double getVoltageDiff() {
        return this.volts[0];
    }

    int getVoltageSourceCount() {
        return 1;
    }

    boolean hasGroundConnection(int n) {
        return true;
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "sweep " + ((this.flags & 1) == 0 ? "(linear)" : "(log)");
        stringArray[1] = "I = " + SweepElm.getCurrentDText(this.getCurrent());
        stringArray[2] = "V = " + SweepElm.getVoltageText(this.volts[0]);
        stringArray[3] = "f = " + SweepElm.getUnitText(this.frequency, "Hz");
        stringArray[4] = "range = " + SweepElm.getUnitText(this.minF, "Hz") + " .. " + SweepElm.getUnitText(this.maxF, "Hz");
        stringArray[5] = "time = " + SweepElm.getUnitText(this.sweepTime, "s");
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            return new EditInfo("Min Frequency (Hz)", this.minF, 0.0, 0.0);
        }
        if (n == 1) {
            return new EditInfo("Max Frequency (Hz)", this.maxF, 0.0, 0.0);
        }
        if (n == 2) {
            return new EditInfo("Sweep Time (s)", this.sweepTime, 0.0, 0.0);
        }
        if (n == 3) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Logarithmic", (this.flags & 1) != 0);
            return editInfo;
        }
        if (n == 4) {
            return new EditInfo("Max Voltage", this.maxV, 0.0, 0.0);
        }
        if (n == 5) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Bidirectional", (this.flags & 2) != 0);
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        double d = 1.0 / (8.0 * SweepElm.sim.timeStep);
        if (n == 0) {
            this.minF = editInfo.value;
            if (this.minF > d) {
                this.minF = d;
            }
        }
        if (n == 1) {
            this.maxF = editInfo.value;
            if (this.maxF > d) {
                this.maxF = d;
            }
        }
        if (n == 2) {
            this.sweepTime = editInfo.value;
        }
        if (n == 3) {
            this.flags &= 0xFFFFFFFE;
            if (editInfo.checkbox.getState()) {
                this.flags |= 1;
            }
        }
        if (n == 4) {
            this.maxV = editInfo.value;
        }
        if (n == 5) {
            this.flags &= 0xFFFFFFFD;
            if (editInfo.checkbox.getState()) {
                this.flags |= 2;
            }
        }
        this.setParams();
    }
}

