/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

class ProbeElm
extends CircuitElm {
    static final int FLAG_SHOWVOLTAGE = 1;
    Point center;

    public ProbeElm(int n, int n2) {
        super(n, n2);
    }

    public ProbeElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
    }

    int getDumpType() {
        return 112;
    }

    void setPoints() {
        super.setPoints();
        if (this.point2.y < this.point1.y) {
            Point point = this.point1;
            this.point1 = this.point2;
            this.point2 = point;
        }
        this.center = this.interpPoint(this.point1, this.point2, 0.5);
    }

    void draw(Graphics graphics) {
        int n = 8;
        this.setBbox(this.point1, this.point2, n);
        boolean bl = this.needsHighlight() || ProbeElm.sim.plotYElm == this;
        double d = bl || ProbeElm.sim.dragElm == this ? 16.0 : this.dn - 32.0;
        this.calcLeads((int)d);
        this.setVoltageColor(graphics, this.volts[0]);
        if (bl) {
            graphics.setColor(selectColor);
        }
        ProbeElm.drawThickLine(graphics, this.point1, this.lead1);
        this.setVoltageColor(graphics, this.volts[1]);
        if (bl) {
            graphics.setColor(selectColor);
        }
        ProbeElm.drawThickLine(graphics, this.lead2, this.point2);
        Font font = new Font("SansSerif", 1, 14);
        graphics.setFont(font);
        if (this == ProbeElm.sim.plotXElm) {
            this.drawCenteredText(graphics, "X", this.center.x, this.center.y, true);
        }
        if (this == ProbeElm.sim.plotYElm) {
            this.drawCenteredText(graphics, "Y", this.center.x, this.center.y, true);
        }
        if (this.mustShowVoltage()) {
            String string = ProbeElm.getShortUnitText(this.volts[0], "V");
            this.drawValues(graphics, string, 4.0);
        }
        this.drawPosts(graphics);
    }

    boolean mustShowVoltage() {
        return (this.flags & 1) != 0;
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = "scope probe";
        stringArray[1] = "Vd = " + ProbeElm.getVoltageText(this.getVoltageDiff());
    }

    boolean getConnection(int n, int n2) {
        return false;
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Show Voltage", this.mustShowVoltage());
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.flags = editInfo.checkbox.getState() ? 1 : (this.flags &= 0xFFFFFFFE);
        }
    }
}

