/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;

class DACElm
extends ChipElm {
    public DACElm(int n, int n2) {
        super(n, n2);
    }

    public DACElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
    }

    String getChipName() {
        return "DAC";
    }

    boolean needsBits() {
        return true;
    }

    void setupPins() {
        this.sizeX = 2;
        this.sizeY = this.bits > 2 ? this.bits : 2;
        this.pins = new ChipElm.Pin[this.getPostCount()];
        for (int i = 0; i != this.bits; ++i) {
            this.pins[i] = new ChipElm.Pin(this.bits - 1 - i, 2, "D" + i);
        }
        this.pins[this.bits] = new ChipElm.Pin(0, 3, "O");
        this.pins[this.bits].output = true;
        this.pins[this.bits + 1] = new ChipElm.Pin(this.sizeY - 1, 3, "V+");
        this.allocNodes();
    }

    void doStep() {
        int n = 0;
        for (int i = 0; i != this.bits; ++i) {
            if (!(this.volts[i] > 2.5)) continue;
            n |= 1 << i;
        }
        int n2 = (1 << this.bits) - 1;
        double d = (double)n * this.volts[this.bits + 1] / (double)n2;
        sim.updateVoltageSource(0, this.nodes[this.bits], this.pins[this.bits].voltSource, d);
    }

    int getVoltageSourceCount() {
        return 1;
    }

    int getPostCount() {
        return this.bits + 2;
    }

    int getDumpType() {
        return 166;
    }
}

