/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.util.StringTokenizer;

class CounterElm
extends ChipElm {
    final int FLAG_ENABLE = 2;
    boolean invertreset = false;

    public CounterElm(int n, int n2) {
        super(n, n2);
    }

    public CounterElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
        this.invertreset = stringTokenizer.hasMoreTokens() ? new Boolean(stringTokenizer.nextToken()) : true;
        this.pins[1].bubble = this.invertreset;
    }

    String dump() {
        return super.dump() + " " + this.invertreset;
    }

    boolean needsBits() {
        return true;
    }

    String getChipName() {
        return "Counter";
    }

    void setupPins() {
        this.sizeX = 2;
        this.sizeY = this.bits > 2 ? this.bits : 2;
        this.pins = new ChipElm.Pin[this.getPostCount()];
        this.pins[0] = new ChipElm.Pin(0, 2, "");
        this.pins[0].clock = true;
        this.pins[1] = new ChipElm.Pin(this.sizeY - 1, 2, "R");
        this.pins[1].bubble = this.invertreset;
        for (int i = 0; i != this.bits; ++i) {
            int n = i + 2;
            this.pins[n] = new ChipElm.Pin(i, 3, "Q" + (this.bits - i - 1));
            this.pins[n].state = true;
            this.pins[n].output = true;
        }
        if (this.hasEnable()) {
            this.pins[this.bits + 2] = new ChipElm.Pin(this.sizeY - 2, 2, "En");
        }
        this.allocNodes();
    }

    int getPostCount() {
        if (this.hasEnable()) {
            return this.bits + 3;
        }
        return this.bits + 2;
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Flip X", (this.flags & 0x400) != 0);
            return editInfo;
        }
        if (n == 1) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Flip Y", (this.flags & 0x800) != 0);
            return editInfo;
        }
        if (n == 2) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Invert reset pin", this.invertreset);
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.flags = editInfo.checkbox.getState() ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
            this.setPoints();
        }
        if (n == 1) {
            this.flags = editInfo.checkbox.getState() ? (this.flags |= 0x800) : (this.flags &= 0xFFFFF7FF);
            this.setPoints();
        }
        if (n == 2) {
            if (editInfo.checkbox.getState()) {
                this.invertreset = true;
                this.pins[1].bubble = true;
            } else {
                this.invertreset = false;
                this.pins[1].bubble = false;
            }
            this.setPoints();
        }
    }

    boolean hasEnable() {
        return (this.flags & 2) != 0;
    }

    int getVoltageSourceCount() {
        return this.bits;
    }

    void execute() {
        int n;
        boolean bl = true;
        if (this.hasEnable()) {
            bl = this.pins[this.bits + 2].value;
        }
        if (this.pins[0].value && !this.lastClock && bl) {
            for (n = this.bits - 1; n >= 0; --n) {
                int n2 = n + 2;
                if (!this.pins[n2].value) {
                    this.pins[n2].value = true;
                    break;
                }
                this.pins[n2].value = false;
            }
        }
        if (!this.pins[1].value == this.invertreset) {
            for (n = 0; n != this.bits; ++n) {
                this.pins[n + 2].value = false;
            }
        }
        this.lastClock = this.pins[0].value;
    }

    int getDumpType() {
        return 164;
    }
}

