/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

abstract class ChipElm
extends CircuitElm {
    int csize;
    int cspc;
    int cspc2;
    int bits;
    final int FLAG_SMALL = 1;
    final int FLAG_FLIP_X = 1024;
    final int FLAG_FLIP_Y = 2048;
    int[] rectPointsX;
    int[] rectPointsY;
    int[] clockPointsX;
    int[] clockPointsY;
    Pin[] pins;
    int sizeX;
    int sizeY;
    boolean lastClock;
    final int SIDE_N = 0;
    final int SIDE_S = 1;
    final int SIDE_W = 2;
    final int SIDE_E = 3;

    public ChipElm(int n, int n2) {
        super(n, n2);
        if (this.needsBits()) {
            this.bits = this instanceof DecadeElm ? 10 : 4;
        }
        this.noDiagonal = true;
        this.setupPins();
        this.setSize(ChipElm.sim.smallGridCheckItem.getState() ? 1 : 2);
    }

    public ChipElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5);
        if (this.needsBits()) {
            this.bits = new Integer(stringTokenizer.nextToken());
        }
        this.noDiagonal = true;
        this.setupPins();
        this.setSize((n5 & 1) != 0 ? 1 : 2);
        for (int i = 0; i != this.getPostCount(); ++i) {
            if (!this.pins[i].state) continue;
            this.volts[i] = new Double(stringTokenizer.nextToken());
            this.pins[i].value = this.volts[i] > 2.5;
        }
    }

    boolean needsBits() {
        return false;
    }

    void setSize(int n) {
        this.csize = n;
        this.cspc = 8 * n;
        this.cspc2 = this.cspc * 2;
        this.flags &= 0xFFFFFFFE;
        this.flags |= n == 1 ? 1 : 0;
    }

    abstract void setupPins();

    void draw(Graphics graphics) {
        this.drawChip(graphics);
    }

    void drawChip(Graphics graphics) {
        int n;
        Font font = new Font("SansSerif", 0, 10 * this.csize);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        for (n = 0; n != this.getPostCount(); ++n) {
            Pin pin = this.pins[n];
            this.setVoltageColor(graphics, this.volts[n]);
            Point point = pin.post;
            Point point2 = pin.stub;
            ChipElm.drawThickLine(graphics, point, point2);
            pin.curcount = this.updateDotCount(pin.current, pin.curcount);
            this.drawDots(graphics, point2, point, pin.curcount);
            if (pin.bubble) {
                graphics.setColor(ChipElm.sim.printableCheckItem.getState() ? Color.white : Color.black);
                ChipElm.drawThickCircle(graphics, pin.bubbleX, pin.bubbleY, 1);
                graphics.setColor(lightGrayColor);
                ChipElm.drawThickCircle(graphics, pin.bubbleX, pin.bubbleY, 3);
            }
            graphics.setColor(whiteColor);
            int n2 = fontMetrics.stringWidth(pin.text);
            graphics.drawString(pin.text, pin.textloc.x - n2 / 2, pin.textloc.y + fontMetrics.getAscent() / 2);
            if (!pin.lineOver) continue;
            int n3 = pin.textloc.y - fontMetrics.getAscent() / 2;
            graphics.drawLine(pin.textloc.x - n2 / 2, n3, pin.textloc.x + n2 / 2, n3);
        }
        graphics.setColor(this.needsHighlight() ? selectColor : lightGrayColor);
        ChipElm.drawThickPolygon(graphics, this.rectPointsX, this.rectPointsY, 4);
        if (this.clockPointsX != null) {
            graphics.drawPolyline(this.clockPointsX, this.clockPointsY, 3);
        }
        for (n = 0; n != this.getPostCount(); ++n) {
            this.drawPost(graphics, this.pins[n].post.x, this.pins[n].post.y, this.nodes[n]);
        }
    }

    void drag(int n, int n2) {
        n2 = sim.snapGrid(n2);
        if (n < this.x) {
            n = this.x;
            n2 = this.y;
        } else {
            this.y = this.y2 = n2;
            this.x2 = sim.snapGrid(n);
        }
        this.setPoints();
    }

    void setPoints() {
        if (this.x2 - this.x > this.sizeX * this.cspc2 && this == ChipElm.sim.dragElm) {
            this.setSize(2);
        }
        int n = this.cspc;
        int n2 = this.x + this.cspc2;
        int n3 = this.y;
        int n4 = n2 - this.cspc;
        int n5 = n3 - this.cspc;
        int n6 = this.sizeX * this.cspc2;
        int n7 = this.sizeY * this.cspc2;
        this.rectPointsX = new int[]{n4, n4 + n6, n4 + n6, n4};
        this.rectPointsY = new int[]{n5, n5, n5 + n7, n5 + n7};
        this.setBbox(n4, n5, this.rectPointsX[2], this.rectPointsY[2]);
        block6: for (int i = 0; i != this.getPostCount(); ++i) {
            Pin pin = this.pins[i];
            switch (pin.side) {
                case 0: {
                    pin.setPoint(n2, n3, 1, 0, 0, -1, 0, 0);
                    continue block6;
                }
                case 1: {
                    pin.setPoint(n2, n3, 1, 0, 0, 1, 0, n7 - this.cspc2);
                    continue block6;
                }
                case 2: {
                    pin.setPoint(n2, n3, 0, 1, -1, 0, 0, 0);
                    continue block6;
                }
                case 3: {
                    pin.setPoint(n2, n3, 0, 1, 1, 0, n6 - this.cspc2, 0);
                }
            }
        }
    }

    Point getPost(int n) {
        return this.pins[n].post;
    }

    abstract int getVoltageSourceCount();

    void setVoltageSource(int n, int n2) {
        for (int i = 0; i != this.getPostCount(); ++i) {
            Pin pin = this.pins[i];
            if (!pin.output || n-- != 0) continue;
            pin.voltSource = n2;
            return;
        }
        System.out.println("setVoltageSource failed for " + this);
    }

    void stamp() {
        for (int i = 0; i != this.getPostCount(); ++i) {
            Pin pin = this.pins[i];
            if (!pin.output) continue;
            sim.stampVoltageSource(0, this.nodes[i], pin.voltSource);
        }
    }

    void execute() {
    }

    void doStep() {
        Pin pin;
        int n;
        for (n = 0; n != this.getPostCount(); ++n) {
            pin = this.pins[n];
            if (pin.output) continue;
            pin.value = this.volts[n] > 2.5;
        }
        this.execute();
        for (n = 0; n != this.getPostCount(); ++n) {
            pin = this.pins[n];
            if (!pin.output) continue;
            sim.updateVoltageSource(0, this.nodes[n], pin.voltSource, pin.value ? 5.0 : 0.0);
        }
    }

    void reset() {
        for (int i = 0; i != this.getPostCount(); ++i) {
            this.pins[i].value = false;
            this.pins[i].curcount = 0.0;
            this.volts[i] = 0.0;
        }
        this.lastClock = false;
    }

    String dump() {
        int n = this.getDumpType();
        String string = super.dump();
        if (this.needsBits()) {
            string = string + " " + this.bits;
        }
        for (int i = 0; i != this.getPostCount(); ++i) {
            if (!this.pins[i].state) continue;
            string = string + " " + this.volts[i];
        }
        return string;
    }

    void getInfo(String[] stringArray) {
        stringArray[0] = this.getChipName();
        int n = 1;
        for (int i = 0; i != this.getPostCount(); ++i) {
            Pin pin = this.pins[i];
            if (stringArray[n] != null) {
                int n2 = n;
                stringArray[n2] = stringArray[n2] + "; ";
            } else {
                stringArray[n] = "";
            }
            String string = pin.text;
            if (pin.lineOver) {
                string = string + '\'';
            }
            if (pin.clock) {
                string = "Clk";
            }
            int n3 = n++;
            stringArray[n3] = stringArray[n3] + string + " = " + ChipElm.getVoltageText(this.volts[i]);
            if (i % 2 != 1) continue;
        }
    }

    void setCurrent(int n, double d) {
        for (int i = 0; i != this.getPostCount(); ++i) {
            if (!this.pins[i].output || this.pins[i].voltSource != n) continue;
            this.pins[i].current = d;
        }
    }

    String getChipName() {
        return "chip";
    }

    boolean getConnection(int n, int n2) {
        return false;
    }

    boolean hasGroundConnection(int n) {
        return this.pins[n].output;
    }

    public EditInfo getEditInfo(int n) {
        if (n == 0) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Flip X", (this.flags & 0x400) != 0);
            return editInfo;
        }
        if (n == 1) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Flip Y", (this.flags & 0x800) != 0);
            return editInfo;
        }
        return null;
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 0) {
            this.flags = editInfo.checkbox.getState() ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
            this.setPoints();
        }
        if (n == 1) {
            this.flags = editInfo.checkbox.getState() ? (this.flags |= 0x800) : (this.flags &= 0xFFFFF7FF);
            this.setPoints();
        }
    }

    class Pin {
        Point post;
        Point stub;
        Point textloc;
        int pos;
        int side;
        int voltSource;
        int bubbleX;
        int bubbleY;
        String text;
        boolean lineOver;
        boolean bubble;
        boolean clock;
        boolean output;
        boolean value;
        boolean state;
        double curcount;
        double current;

        Pin(int n, int n2, String string) {
            this.pos = n;
            this.side = n2;
            this.text = string;
        }

        void setPoint(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
            if ((ChipElm.this.flags & 0x400) != 0) {
                n3 = -n3;
                n5 = -n5;
                n += ChipElm.this.cspc2 * (ChipElm.this.sizeX - 1);
                n7 = -n7;
            }
            if ((ChipElm.this.flags & 0x800) != 0) {
                n4 = -n4;
                n6 = -n6;
                n2 += ChipElm.this.cspc2 * (ChipElm.this.sizeY - 1);
                n8 = -n8;
            }
            int n9 = n + ChipElm.this.cspc2 * n3 * this.pos + n7;
            int n10 = n2 + ChipElm.this.cspc2 * n4 * this.pos + n8;
            this.post = new Point(n9 + n5 * ChipElm.this.cspc2, n10 + n6 * ChipElm.this.cspc2);
            this.stub = new Point(n9 + n5 * ChipElm.this.cspc, n10 + n6 * ChipElm.this.cspc);
            this.textloc = new Point(n9, n10);
            if (this.bubble) {
                this.bubbleX = n9 + n5 * 10 * ChipElm.this.csize;
                this.bubbleY = n10 + n6 * 10 * ChipElm.this.csize;
            }
            if (this.clock) {
                ChipElm.this.clockPointsX = new int[3];
                ChipElm.this.clockPointsY = new int[3];
                ChipElm.this.clockPointsX[0] = n9 + n5 * ChipElm.this.cspc - n3 * ChipElm.this.cspc / 2;
                ChipElm.this.clockPointsY[0] = n10 + n6 * ChipElm.this.cspc - n4 * ChipElm.this.cspc / 2;
                ChipElm.this.clockPointsX[1] = n9;
                ChipElm.this.clockPointsY[1] = n10;
                ChipElm.this.clockPointsX[2] = n9 + n5 * ChipElm.this.cspc + n3 * ChipElm.this.cspc / 2;
                ChipElm.this.clockPointsY[2] = n10 + n6 * ChipElm.this.cspc + n4 * ChipElm.this.cspc / 2;
            }
        }
    }
}

