/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.GraphInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

class GraphPanel
extends JPanel {
    private static final long serialVersionUID = 700L;
    private List<GraphInfo> graphList = new ArrayList<GraphInfo>();
    private int width;
    private int height;
    private JPanel centralPanel;

    public void addGraph(List<Double> info, double max, double min, Color color, String name) {
        this.graphList.add(new GraphInfo(info, max, min, this.width, this.height, color, name));
    }

    public void clear() {
        this.graphList.clear();
    }

    public void updateLegend() {
        JPanel legendPanel = new JPanel();
        legendPanel.setBackground(Color.BLACK);
        legendPanel.setLayout(new GridLayout(this.graphList.size(), 1));
        for (GraphInfo graph : this.graphList) {
            JLabel label = new JLabel(graph.name);
            label.setForeground(graph.color);
            legendPanel.add(label);
        }
        this.add((Component)legendPanel, "East");
    }

    public GraphPanel(int w, int h) {
        this.setBackground(Color.BLACK);
        this.width = w;
        this.height = h;
        this.setLayout(new BorderLayout());
        this.centralPanel = new JPanel();
        this.centralPanel.setPreferredSize(new Dimension(this.width, this.height));
        this.centralPanel.setBackground(Color.BLACK);
        this.centralPanel.setOpaque(false);
        this.add((Component)this.centralPanel, "Center");
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new GridLayout(1, 2));
        southPanel.setPreferredSize(new Dimension(this.width, 20));
        southPanel.add(new JLabel("0", 2));
        southPanel.add(new JLabel("100", 4));
        this.add((Component)southPanel, "South");
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (GraphInfo graph : this.graphList) {
            graph.draw(g);
        }
    }
}

