/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class CheckVersionThread
extends Thread {
    private JFrame parentFrame;

    public static String translateVersion(String str) {
        int revision;
        int subversion;
        int version;
        String v;
        String zero = "000000";
        try {
            v = String.valueOf(zero.substring(0, 6 - str.length())) + str;
        }
        catch (IndexOutOfBoundsException e) {
            return str;
        }
        try {
            version = Integer.parseInt(v.substring(0, 2));
            subversion = Integer.parseInt(v.substring(2, 4));
            revision = Integer.parseInt(v.substring(4, 6));
        }
        catch (NumberFormatException e) {
            return str;
        }
        String result = revision == 0 ? String.valueOf(version) + "." + subversion : String.valueOf(version) + "." + subversion + "." + revision;
        return result;
    }

    public CheckVersionThread(JFrame frame) {
        this.parentFrame = frame;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        BufferedReader br = null;
        try {
            try {
                URL url = new URL("http://biogenesis.sourceforge.net/lastversion.txt");
                InputStreamReader inr = new InputStreamReader(url.openStream());
                br = new BufferedReader(inr);
                String s = CheckVersionThread.translateVersion(br.readLine());
                JOptionPane.showMessageDialog(this.parentFrame, String.valueOf(Messages.getString("T_YOUR_VERSION")) + CheckVersionThread.translateVersion(String.valueOf(800)) + "\n" + Messages.getString("T_LAST_VERSION") + s, Messages.getString("T_VERSION_TITLE"), 1);
                br.close();
                return;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                if (br == null) return;
                try {
                    br.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.parentFrame, String.valueOf(Messages.getString("T_CANT_CHECK_CURRENT_VERSION")) + e.getLocalizedMessage(), Messages.getString("T_VERSION_TITLE"), 0);
                if (br == null) return;
                try {
                    br.close();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

