/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.report;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.ponec.jworksheet.bo.Event;
import net.ponec.jworksheet.bo.Parameters;
import net.ponec.jworksheet.bo.WorkDay;
import net.ponec.jworksheet.bo.item.YearMonthDay;
import net.ponec.jworksheet.core.ApplContext;
import net.ponec.jworksheet.report.GroupSet;
import net.ponec.jworksheet.report.ReportA;
import net.ponec.jworksheet.report.SuperReport;
import net.ponec.jworksheet.report.TaskGroup;
import org.ujoframework.core.UjoComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportTab
extends SuperReport {
    protected List<GroupSet> data = new ArrayList<GroupSet>();
    protected WorkDay lastWorkDay;
    protected UjoComparator comparator;
    protected ReportA report = null;

    @Override
    public void init(ApplContext applContext, YearMonthDay yearMonthDay, YearMonthDay yearMonthDay2, String string) {
        super.init(applContext, yearMonthDay, yearMonthDay2, string);
        this.comparator = this.createUjoComparator();
    }

    @Override
    public void calculate(WorkDay workDay, Event event) {
        if (this.lastWorkDay != workDay) {
            this.lastWorkDay = workDay;
            this.saveDay();
        }
    }

    protected UjoComparator createUjoComparator() {
        UjoComparator ujoComparator = UjoComparator.newInstance(TaskGroup.P_PROJ, TaskGroup.P_TASK);
        return ujoComparator;
    }

    private void saveDay() {
        YearMonthDay yearMonthDay = WorkDay.P_DATE.of(this.lastWorkDay);
        this.report = new ReportA();
        GroupSet groupSet = new GroupSet(this.createUjoComparator(), Event.P_PERIOD);
        groupSet.setShowEmptyProject(true);
        this.report.setGroupSet(groupSet);
        this.report.init(this.applContext, yearMonthDay, yearMonthDay, this.reportTitle);
        for (TaskGroup taskGroup : groupSet.getGroups()) {
            TaskGroup.P_DAY.setValue(taskGroup, yearMonthDay);
        }
        this.data.add(this.report.getGroupSet());
    }

    @Override
    public String print() throws IOException {
        String string = this.getReport(this.printBody(), this.reportTitle);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public String printBody() throws IOException {
        void var8_14;
        void var8_12;
        int n;
        StringBuilder stringBuilder = new StringBuilder(256);
        this.printFilter(stringBuilder);
        this.printTableBeg(stringBuilder);
        List<TaskGroup> list = this.getProjects();
        List<YearMonthDay> list2 = this.getDays();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Parameters.P_DATE_REPORT_FORMAT2.of(this.applContext.getParameters()), this.applContext.getLanguage());
        String string = this.applContext.getParameters().getDateFormat(Parameters.P_DATE_REPORT_FORMAT, this.applContext);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string, this.applContext.getLanguage());
        stringBuilder.append("<tr>\n<th>");
        stringBuilder.append(this.getText(".TabbedPane.Projects"));
        stringBuilder.append("</th>\n");
        for (YearMonthDay ujoCloneable : list2) {
            boolean bl = this.isDayOff(ujoCloneable);
            stringBuilder.append("<th title=\"" + this.escape((bl ? this.getText("DayOff") + ": " : "") + simpleDateFormat2.format(ujoCloneable.getTime())) + "\"");
            if (bl) {
                stringBuilder.append(" class=\"dayOff\"");
            }
            stringBuilder.append(">");
            stringBuilder.append(simpleDateFormat.format(ujoCloneable.getTime()));
            stringBuilder.append("</th>\n");
        }
        stringBuilder.append("<th>&nbsp;&nbsp;");
        stringBuilder.append(this.getText("Total"));
        stringBuilder.append("</th>");
        stringBuilder.append("</tr>\n");
        for (TaskGroup taskGroup : list) {
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>");
            stringBuilder.append(this.escape(TaskGroup.P_PROJ.of(taskGroup)));
            stringBuilder.append(" / ");
            stringBuilder.append(this.escape(TaskGroup.P_TASK.of(taskGroup)));
            stringBuilder.append("</td>\n");
            int n2 = 0;
            for (YearMonthDay yearMonthDay : list2) {
                n = this.getCellTime(taskGroup, yearMonthDay);
                n2 += n;
                stringBuilder.append("<td class=\"num\">");
                stringBuilder.append(this.formatTimeZero(n));
                stringBuilder.append("</td>\n");
            }
            stringBuilder.append("<td class=\"total\">");
            stringBuilder.append(this.formatTime(n2));
            stringBuilder.append("</td>\n");
            stringBuilder.append("</tr>\n");
        }
        LinkedList linkedList = new LinkedList();
        boolean bl = false;
        stringBuilder.append("<tr class=\"total\">\n<td class=\"alignLeft\">");
        stringBuilder.append(this.getText("TotalTime"));
        stringBuilder.append("</td>\n");
        for (YearMonthDay yearMonthDay : list2) {
            int n3 = this.getDayTime(yearMonthDay);
            linkedList.add(n3);
            var8_12 += n3;
            stringBuilder.append("<td title=\"" + this.escape(simpleDateFormat2.format(yearMonthDay.getTime())) + "\">");
            stringBuilder.append(this.formatTime(n3));
            stringBuilder.append("</td>\n");
        }
        stringBuilder.append("<td>");
        stringBuilder.append(this.formatTime((int)var8_12));
        stringBuilder.append("</td>\n");
        stringBuilder.append("</tr>\n");
        boolean bl2 = false;
        int n4 = Math.round(Parameters.P_WORKING_HOURS.of(this.applContext.getParameters()).floatValue() * 60.0f);
        stringBuilder.append("<tr class=\"total\">\n<td class=\"alignLeft\">");
        stringBuilder.append(this.getText("Overtime"));
        stringBuilder.append("</td>\n");
        for (YearMonthDay yearMonthDay : list2) {
            n = (Integer)linkedList.removeFirst();
            if (!this.isDayOff(yearMonthDay)) {
                n -= n4;
            }
            var8_14 += n;
            stringBuilder.append("<td title=\"" + this.escape(simpleDateFormat2.format(yearMonthDay.getTime())) + "\">");
            stringBuilder.append(this.formatTime(n));
            stringBuilder.append("</td>\n");
        }
        stringBuilder.append("<td>");
        stringBuilder.append(this.formatTime((int)var8_14));
        stringBuilder.append("</td>\n");
        stringBuilder.append("</tr>\n");
        this.printTableEnd(stringBuilder);
        return stringBuilder.toString();
    }

    private int getCellTime(TaskGroup taskGroup, YearMonthDay yearMonthDay) {
        for (GroupSet groupSet : this.data) {
            for (TaskGroup taskGroup2 : groupSet.getGroups()) {
                YearMonthDay yearMonthDay2 = TaskGroup.P_DAY.of(taskGroup2);
                if (!yearMonthDay.equals(yearMonthDay2) || !this.comparator.equals(taskGroup, taskGroup2)) continue;
                return taskGroup2.getTime();
            }
        }
        return 0;
    }

    private int getDayTime(YearMonthDay yearMonthDay) {
        int n = 0;
        for (GroupSet groupSet : this.data) {
            for (TaskGroup taskGroup : groupSet.getGroups()) {
                YearMonthDay yearMonthDay2 = TaskGroup.P_DAY.of(taskGroup);
                if (!yearMonthDay.equals(yearMonthDay2)) continue;
                n += taskGroup.getBusinessTime();
            }
        }
        return n;
    }

    public List<YearMonthDay> getDays() {
        ArrayList<YearMonthDay> arrayList = new ArrayList<YearMonthDay>();
        for (GroupSet groupSet : this.data) {
            for (TaskGroup taskGroup : groupSet.getGroups()) {
                YearMonthDay yearMonthDay = TaskGroup.P_DAY.of(taskGroup);
                if (yearMonthDay == null || arrayList.contains(yearMonthDay)) continue;
                arrayList.add(yearMonthDay);
            }
        }
        return arrayList;
    }

    public List<TaskGroup> getProjects() {
        ArrayList<TaskGroup> arrayList = new ArrayList<TaskGroup>();
        for (GroupSet groupSet : this.data) {
            for (TaskGroup taskGroup : groupSet.getGroups()) {
                if (taskGroup.getBusinessTime() == 0) continue;
                boolean bl = false;
                for (TaskGroup taskGroup2 : arrayList) {
                    if (!this.comparator.equals(taskGroup2, taskGroup)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(taskGroup);
            }
        }
        Collections.sort(arrayList, this.comparator);
        return arrayList;
    }
}

