/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ponec.jworksheet.bo.Event;
import net.ponec.jworksheet.bo.Project;
import net.ponec.jworksheet.bo.WorkDay;
import net.ponec.jworksheet.report.ReportA;
import net.ponec.jworksheet.report.SuperReport;
import org.ujoframework.Ujo;

public class ReportAttendance
extends SuperReport {
    protected WorkDay lastWorkDay;
    protected ReportA report = null;
    protected StringBuilder repBody = new StringBuilder(256);
    private int workTime = 0;
    private int breakTime = 0;
    private int arrival = 0;
    private int departure = 0;
    private List<String> descrs = new ArrayList<String>();

    public void calculate(WorkDay workDay, Event event) {
        if (this.lastWorkDay != workDay) {
            try {
                this.lastWorkDay = workDay;
                this.printDay();
                this.workTime = 0;
                this.breakTime = 0;
                this.arrival = 0;
                this.departure = 0;
                this.descrs.clear();
            }
            catch (IOException iOException) {
                Logger.getLogger(ReportAttendance.class.getName()).log(Level.SEVERE, null, iOException);
            }
        } else {
            int n;
            if (Project.P_PRIVATE.of((Project)((Ujo)Event.P_PROJ.of(event))).booleanValue()) {
                this.breakTime += Event.P_PERIOD.of(event).shortValue();
            } else {
                this.workTime += Event.P_PERIOD.of(event).shortValue();
                String string = Event.P_DESCR.of(event);
                if (!this.descrs.contains(string)) {
                    this.descrs.add(string);
                }
            }
            int n2 = Event.P_TIME.of(event).getMinutes();
            if (this.arrival > n2) {
                this.arrival = n2;
            }
            if (this.departure < (n = n2 + Event.P_PERIOD.of(event))) {
                this.departure = n;
            }
        }
    }

    private void printDay() throws IOException {
        StringBuilder stringBuilder = this.repBody;
        stringBuilder.append((CharSequence)"<tr>");
        stringBuilder.append((CharSequence)"<th align=\"left\">").append(this.getText(WorkDay.P_DATE)).append("</th>");
        stringBuilder.append((CharSequence)"<th align=\"left\">").append(this.escape(this.arrival)).append("</th>");
        stringBuilder.append((CharSequence)"<th align=\"left\">").append(this.escape(this.departure)).append("</th>");
        stringBuilder.append((CharSequence)"<th align=\"left\">").append(this.escape(this.breakTime)).append("</th>");
        stringBuilder.append((CharSequence)"<th align=\"left\">").append(this.escape(this.workTime)).append("</th>");
        stringBuilder.append((CharSequence)"<th align=\"left\"><ul>");
        for (String string : this.descrs) {
            stringBuilder.append((CharSequence)"<li>");
            stringBuilder.append((CharSequence)this.escape(string));
            stringBuilder.append((CharSequence)"</li>");
        }
        stringBuilder.append((CharSequence)"</ul></th>");
        stringBuilder.append((CharSequence)"<tr>");
    }

    public String print() throws IOException {
        return this.getReport(this.repBody.toString(), this.reportTitle);
    }

    public void printHeader(StringBuilder stringBuilder) throws IOException {
        stringBuilder.append("<tr>");
        stringBuilder.append("<th align=\"left\">").append(this.getText(WorkDay.P_DATE)).append("</th>");
        stringBuilder.append("<th align=\"left\">").append(this.getText("Arrival")).append("</th>");
        stringBuilder.append("<th align=\"left\">").append(this.getText("Departure")).append("</th>");
        stringBuilder.append("<th align=\"left\">").append(this.getText("Break")).append("</th>");
        stringBuilder.append("<th align=\"left\">").append(this.getText("WorkTime")).append("</th>");
        stringBuilder.append("<th align=\"left\">").append(this.getText("Tasks")).append("</th>");
        stringBuilder.append("<tr>");
    }
}

