/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import net.ponec.jworksheet.bo.Event;
import net.ponec.jworksheet.bo.Parameters;
import net.ponec.jworksheet.bo.Project;
import net.ponec.jworksheet.bo.TaskType;
import net.ponec.jworksheet.bo.WorkDay;
import net.ponec.jworksheet.bo.WorkSpace;
import net.ponec.jworksheet.bo.item.Time;
import net.ponec.jworksheet.bo.item.YearMonthDay;
import net.ponec.jworksheet.core.ApplContext;
import net.ponec.jworksheet.core.ApplTools;
import net.ponec.jworksheet.gui.DateDialog;
import net.ponec.jworksheet.gui.JwsHandler;
import net.ponec.jworksheet.gui.ReportDialog;
import net.ponec.jworksheet.gui.TopFrame;
import net.ponec.jworksheet.gui.component.CheckBoxRenderer;
import net.ponec.jworksheet.gui.component.UjoTable;
import net.ponec.jworksheet.gui.models.CommonTableRenderer;
import net.ponec.jworksheet.gui.models.EventTableModel;
import net.ponec.jworksheet.gui.models.EventTableRenderer;
import net.ponec.jworksheet.gui.models.ParamTableModel;
import net.ponec.jworksheet.gui.models.ProjectTableModel;
import net.ponec.jworksheet.gui.models.TaskCellEditor;
import net.ponec.jworksheet.gui.models.TaskTableModel;
import net.ponec.jworksheet.gui.models.UjoComboBoxModel;
import net.ponec.jworksheet.report.TableReport;
import net.ponec.jworksheet.resources.ResourceProvider;
import org.ujoframework.Ujo;
import org.ujoframework.UjoProperty;
import org.ujoframework.swing.UjoPropertyRow;
import org.ujoframework.swing.UjoTableModel;

public final class JWorkSheet
extends TopFrame {
    public static final String APPL_VERSION = "0.90";
    public static final String APPL_RELEASED = "2009/09/13";
    public static final String APPL_NAME = "jWorkSheet";
    public static final String APPL_HOMEPAGE = "http://jworksheet.ponec.net/";
    private final UjoTable eventTable;
    private final UjoTable projTable;
    private final UjoTable taskTable;
    private final UjoTable paramTable;
    private final UjoTable[] tables;
    private boolean visibleLock = false;
    private final Color COLOR_OFF = new Color(0xDC5555);
    private final Color COLOR_WORK = new Color(4216961);
    private JTable $eventTable;
    private JTable $paramTable;
    private JTable $projTable;
    private JTable $taskTable;
    private JButton bAbout;
    private JButton bClone;
    private JButton bCreate;
    private JButton bDayNext;
    private JButton bDayPrev;
    private JButton bDelete;
    private JButton bGoto;
    private JButton bHomePage;
    private JButton bParamDefault;
    private JButton bParamReport;
    private JButton bProjClone;
    private JButton bProjCreate;
    private JButton bProjDelete;
    private JButton bProjReport;
    private JButton bProjSort;
    private JButton bReport;
    private JButton bSort;
    private JButton bTaskClone;
    private JButton bTaskCreate;
    private JButton bTaskDelete;
    private JButton bTaskReport;
    private JButton bTaskSort;
    private JButton bToday;
    private JCheckBox cbTimeOff;
    private JScrollPane eventSrollPane;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSplitPane jSplitPane1;
    private JLabel lCurrentDay;
    private JLabel lTasks;
    private JLabel lTimeTotal;
    private JPanel pButtons;
    private JPanel pDays;
    private JPanel pParamButtons;
    private JPanel pParamDescr;
    private JPanel pParameters;
    private JPanel pProj;
    private JPanel pProjButtons;
    private JPanel pProjects;
    private JPanel pTask;
    private JPanel pTaskButtons;
    private JPanel pTotal;
    private JPanel pWorkSheet;
    private JTextPane paramDescr;
    private JScrollPane spDescr;
    private JScrollPane spParam;
    private JScrollPane spProjects;
    private JScrollPane spTasks;
    private JSplitPane splitParam;
    private JTextField tTimeTotal;
    private JTabbedPane tabbedPane;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JWorkSheet(ApplContext applContext, Throwable throwable) {
        super(applContext);
        this.eventTable = new UjoTable();
        this.projTable = new UjoTable();
        this.taskTable = new UjoTable();
        this.paramTable = new UjoTable();
        this.tables = new UjoTable[]{this.eventTable, this.projTable, this.taskTable, this.paramTable};
        try {
            JComponent jComponent;
            if (throwable != null) {
                throw throwable;
            }
            this.applContext.setTopFrame(this, false);
            this.initComponents();
            this.projTable.enableSorting(this.applContext);
            this.taskTable.enableSorting(this.applContext);
            this.paramTable.setSelectionMode(0);
            this.projTable.setSelectionMode(0);
            this.projTable.getModel().addTableModelListener(this.applContext);
            this.paramTable.setRenderer(new CommonTableRenderer(this.applContext));
            this.paramTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    String string = "";
                    int n = JWorkSheet.this.paramTable.getSelectedRow();
                    if (JWorkSheet.this.isVisible() && n >= 0) {
                        String string2 = "param." + JWorkSheet.this.paramTable.getValueAt(n, JWorkSheet.this.paramTable.convertColumnIndexToModel(1)).toString();
                        string = JWorkSheet.this.applContext.getLanguageManager().getTextAllways(string2);
                    }
                    JWorkSheet.this.paramDescr.setText(string);
                    JWorkSheet.this.paramDescr.select(0, 0);
                }
            });
            this.taskTable.setSelectionMode(0);
            this.taskTable.getModel().addTableModelListener(this.applContext);
            this.eventTable.setSelectionMode(0);
            this.eventTable.setRenderer(new EventTableRenderer(this.applContext));
            this.eventTable.getModel().addTableModelListener(this.applContext);
            this.eventTable.getModel().addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    UjoProperty ujoProperty;
                    EventTableModel eventTableModel = (EventTableModel)JWorkSheet.this.eventTable.getModel();
                    UjoProperty ujoProperty2 = ujoProperty = tableModelEvent.getColumn() >= 0 ? eventTableModel.getColumn(tableModelEvent.getColumn()) : null;
                    if (ujoProperty == null || ujoProperty == Event.P_PERIOD || ujoProperty == Event.P_TIME) {
                        JWorkSheet.this.displayTotalTime();
                    }
                    if (tableModelEvent.getLastRow() >= eventTableModel.getRowCount() - 1) {
                        JWorkSheet.this.applContext.setSystrayTooltip();
                    }
                }
            });
            this.initHotKeys();
            this.initData();
            this.initIcons();
            this.setTableEventEditor();
            this.eventTable.getTableColumn(Event.P_TASK).setCellEditor(new TaskCellEditor());
            this.eventTable.getTableColumn(Event.P_TIME).setMaxWidth(48);
            this.eventTable.getTableColumn(Event.P_PERIOD).setMaxWidth(48);
            this.eventTable.getTableColumn(Event.P_PROJ).setPreferredWidth(10);
            this.eventTable.getTableColumn(Event.P_TASK).setPreferredWidth(10);
            this.projTable.getTableColumn(Project.P_ID).setMaxWidth(48);
            this.projTable.getTableColumn(Project.P_PRIVATE).setMaxWidth(58);
            this.projTable.getTableColumn(Project.P_DEFAULT).setMaxWidth(58);
            this.projTable.getTableColumn(Project.P_FINISHED).setMaxWidth(58);
            this.projTable.showSortedColumn(Parameters.P_SORT_PROJ_COLUMN.of(this.applContext.getParameters()));
            this.taskTable.getTableColumn(TaskType.P_ID).setMaxWidth(48);
            this.taskTable.getTableColumn(TaskType.P_DEFAULT).setMaxWidth(58);
            this.taskTable.getTableColumn(TaskType.P_FINISHED).setMaxWidth(58);
            this.paramTable.setModel(new ParamTableModel(this.applContext.getParameters(), this.applContext));
            this.paramTable.getTableColumn(UjoPropertyRow.P_DEFAULT).setMinWidth(0);
            this.paramTable.getTableColumn(UjoPropertyRow.P_DEFAULT).setMaxWidth(0);
            this.paramTable.getTableColumn(UjoPropertyRow.P_INDEX).setMaxWidth(30);
            this.paramTable.getTableColumn(UjoPropertyRow.P_NAME).setPreferredWidth(100);
            this.paramTable.getTableColumn(UjoPropertyRow.P_VALUE).setPreferredWidth(200);
            if (ApplTools.isNimbusLAF()) {
                jComponent = new CheckBoxRenderer();
                this.projTable.getTableColumn(Project.P_PRIVATE).setCellRenderer((TableCellRenderer)((Object)jComponent));
                this.projTable.getTableColumn(Project.P_DEFAULT).setCellRenderer((TableCellRenderer)((Object)jComponent));
                this.projTable.getTableColumn(Project.P_FINISHED).setCellRenderer((TableCellRenderer)((Object)jComponent));
                this.taskTable.getTableColumn(TaskType.P_DEFAULT).setCellRenderer((TableCellRenderer)((Object)jComponent));
                this.taskTable.getTableColumn(TaskType.P_FINISHED).setCellRenderer((TableCellRenderer)((Object)jComponent));
            }
            jComponent = new JTextField(5);
            ((JTextField)jComponent).setHorizontalAlignment(4);
            jComponent.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.eventTable.getTableColumn(Event.P_PERIOD).setCellEditor(new DefaultCellEditor((JTextField)jComponent));
            this.projTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    JWorkSheet.this.synchonizeTaskTable();
                }
            });
            this.displaySelectedDay();
            this.displayTotalTime();
            this.applContext.setInitialized();
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                }

                public void windowIconified(WindowEvent windowEvent) {
                    if (JWorkSheet.this.isSystrayEnabled()) {
                        JWorkSheet.this.setVisible(false);
                    }
                    JWorkSheet.this.applContext.saveData(false);
                }

                public void windowDeiconified(WindowEvent windowEvent) {
                    if (!JWorkSheet.this.applContext.isSystrayEnabled() && JWorkSheet.this.applContext.isToday()) {
                        JWorkSheet.this.bSortActionPerformed(null);
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    JWorkSheet.this.closeAppl(null);
                }
            });
            try {
                JwsHandler.init(this);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            ApplTools.windowsSizing(this, Parameters.P_WINDOW_SIZE.of(this.applContext.getParameters()));
            this.applContext.tableChanged(null);
            if (!this.isSystrayEnabled()) return;
        }
        catch (Throwable throwable3) {
            super.showMessage("Can't open jWorkSheet", throwable3);
            System.exit(-1);
        }
    }

    private void setTableEventEditor() {
        UjoComboBoxModel ujoComboBoxModel = new UjoComboBoxModel(this.applContext.getWorkSpace().getOpenProjects());
        this.eventTable.getTableColumn(Event.P_PROJ).setCellEditor(new DefaultCellEditor(new JComboBox(ujoComboBoxModel)));
    }

    private void initData() {
        ImageIcon imageIcon;
        String[] stringArray;
        String string;
        boolean bl = this.applContext.createLock(false);
        if (!bl) {
            string = "The application {0} is running probably. Do you want to continue?";
            stringArray = new String[]{"Exit", "Continue"};
            imageIcon = new ResourceProvider().getIcon(ResourceProvider.LOGO);
            int n = this.showMessage(string, 3, (Icon)imageIcon, (Throwable)null, new Object[]{APPL_NAME}, stringArray);
            if (n == 0) {
                this.setVisible(false);
                System.exit(0);
            }
            this.applContext.createLock(true);
        }
        this.applContext.loadData();
        if (this.applContext.isDataRestored()) {
            string = "There is the serious error:\na personal data of the application can not be found!\nThe jWorkSheet tried to restore data from a backup.";
            stringArray = null;
            imageIcon = new ResourceProvider().getIcon(ResourceProvider.LOGO);
            this.showMessage(string, 0, (Icon)imageIcon, (Throwable)null, new Object[]{APPL_NAME}, stringArray);
        }
        this.setTableModels();
        this.setEventTableModel(true);
        this.projTable.selectRow(0);
        this.synchonizeTaskTable();
    }

    public void closeAppl(WindowEvent windowEvent) {
        try {
            Parameters.P_SORT_PROJ_COLUMN.setValue(this.applContext.getParameters(), this.projTable.getSortedColumn().getName());
            this.applContext.closeAppl(false);
        }
        catch (Throwable throwable) {
            this.showMessage("Can't save data.", throwable);
        }
    }

    private void changeCurrentDate(int n) {
        this.eventTable.submitEditMode(true);
        YearMonthDay yearMonthDay = this.applContext.getSelectedDay().cloneDay();
        if (n != Integer.MIN_VALUE) {
            if (n == 0) {
                yearMonthDay.setToday();
            } else {
                yearMonthDay.addDay(n);
            }
        }
        this.applContext.selectWorkDay(yearMonthDay);
        this.displaySelectedDay();
        this.setEventTableModel(false);
    }

    private void displaySelectedDay() {
        this.lCurrentDay.setText(this.applContext.getSelectedDayStr());
    }

    private void setEventTableModel(boolean bl) {
        UjoTableModel ujoTableModel = this.eventTable.getModel();
        WorkDay workDay = this.applContext.getWorkDay();
        ujoTableModel.setRows(WorkDay.P_EVENTS.getList(workDay));
        this.cbTimeOff.setSelected(WorkDay.P_DAYOFF.of(workDay));
        this.cbTimeOffActionPerformed(null);
        if (bl && ujoTableModel.getRowCount() == 0) {
            ((EventTableModel)this.eventTable.getModel()).insertRowAndDefault(new Event().initTime());
            this.applContext.saveData(false);
        }
    }

    private void displayTotalTime() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EventTableModel eventTableModel = (EventTableModel)JWorkSheet.this.eventTable.getModel();
                JWorkSheet.this.tTimeTotal.setText(eventTableModel.getTotalTimeHours());
            }
        });
    }

    private void setTableModels() {
        List<Project> list = WorkSpace.P_PROJS.getList(this.applContext.getWorkSpace());
        this.projTable.getModel().setRows(list);
    }

    private void synchonizeTaskTable() {
        int n = this.projTable.getSelectedRow();
        Project project = n >= 0 ? (Project)this.projTable.getModel().getRowNullable(n) : null;
        List<Object> list = project != null ? Project.P_TASKS.getList(project) : new ArrayList();
        this.taskTable.getModel().setRows(list);
        this.taskTable.selectRow(0);
        this.taskTable.showSortedColumn(TaskType.P_ID);
    }

    private void showTableReport(UjoTable ujoTable, String string) {
        try {
            TableReport tableReport = new TableReport(this.applContext);
            String string2 = tableReport.printTable(ujoTable.getStringModelArray(true), string, true);
            this.applContext.showReport(string2);
        }
        catch (Throwable throwable) {
            super.showMessage("Can't open report", throwable);
        }
    }

    public void initIcons() {
        ResourceProvider resourceProvider = new ResourceProvider();
        this.setIconImage(resourceProvider.getImage(ResourceProvider.LOGO));
        Dimension dimension = new Dimension(80, 23);
        this.bDayPrev.setPreferredSize(dimension);
        this.bDayPrev.setMinimumSize(dimension);
        this.bDayNext.setPreferredSize(dimension);
        this.bDayNext.setMinimumSize(dimension);
        this.tabbedPane.setIconAt(0, resourceProvider.getIcon("_application_view_list.png"));
        this.tabbedPane.setIconAt(1, resourceProvider.getIcon("_application_split.png"));
        this.tabbedPane.setIconAt(2, resourceProvider.getIcon("_wrench.png"));
        boolean bl = Parameters.P_HIDE_ICONS.of(this.applContext.getParameters());
        this.bDayPrev.setIcon(resourceProvider.getIcon("_resultset_previous.png", bl));
        this.bDayNext.setIcon(resourceProvider.getIcon("_resultset_next.png", bl));
        this.bGoto.setIcon(resourceProvider.getIcon("_date.png", bl));
        this.bSort.setVisible(Parameters.P_AUTOMATIC_SORTING_BY_TIME.of(this.applContext.getParameters()) == false);
        this.setImage(this.bCreate, "_add.png", resourceProvider);
        this.setImage(this.bClone, "_application_double.png", resourceProvider);
        this.setImage(this.bDelete, "_delete2.png", resourceProvider);
        this.setImage(this.bSort, "_arrow_down.png", resourceProvider);
        this.setImage(this.bReport, "_report.png", resourceProvider);
        this.setImage(this.bAbout, "_information.png", resourceProvider);
        this.setImage(this.bProjCreate, "_add.png", resourceProvider);
        this.setImage(this.bProjClone, "_application_double.png", resourceProvider);
        this.setImage(this.bProjDelete, "_delete2.png", resourceProvider);
        this.setImage(this.bProjSort, "_arrow_down.png", resourceProvider);
        this.setImage(this.bProjReport, "_report.png", resourceProvider);
        this.setImage(this.bTaskCreate, "_add.png", resourceProvider);
        this.setImage(this.bTaskClone, "_application_double.png", resourceProvider);
        this.setImage(this.bTaskDelete, "_delete2.png", resourceProvider);
        this.setImage(this.bTaskSort, "_arrow_down.png", resourceProvider);
        this.setImage(this.bTaskReport, "_report.png", resourceProvider);
        this.setImage(this.bParamReport, "_report.png", resourceProvider);
        this.setImage(this.bParamDefault, "_arrow_undo.png", resourceProvider);
        this.setImage(this.bHomePage, "_page_world.png", resourceProvider);
    }

    private void setImage(JButton jButton, String string, ResourceProvider resourceProvider) {
        if (Parameters.P_HIDE_ICONS.of(this.applContext.getParameters()).booleanValue()) {
            jButton.setIcon(null);
            jButton.setHorizontalAlignment(0);
        } else {
            jButton.setIcon(resourceProvider.getIcon(string));
            jButton.setHorizontalAlignment(2);
        }
        jButton.setIconTextGap(8);
    }

    private boolean isSystrayEnabled() {
        return this.applContext.isSystrayEnabled();
    }

    public void setTitle(String string) {
        String string2 = APPL_NAME;
        if (string.length() > 0) {
            string2 = string2 + ": " + string;
        }
        super.setTitle(string2);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    private void initComponents() {
        this.tabbedPane = new JTabbedPane();
        this.pWorkSheet = new JPanel();
        this.pDays = new JPanel();
        this.bDayPrev = new JButton();
        this.lCurrentDay = new JLabel();
        this.bDayNext = new JButton();
        this.bToday = new JButton();
        this.bGoto = new JButton();
        this.cbTimeOff = new JCheckBox();
        this.eventSrollPane = new JScrollPane();
        this.$eventTable = this.eventTable;
        this.pButtons = new JPanel();
        this.bCreate = new JButton();
        this.bDelete = new JButton();
        this.bClone = new JButton();
        this.bSort = new JButton();
        this.bReport = new JButton();
        this.bAbout = new JButton();
        this.pTotal = new JPanel();
        this.lTimeTotal = new JLabel();
        this.tTimeTotal = new JTextField();
        this.pProjects = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.pProj = new JPanel();
        this.pProjButtons = new JPanel();
        this.bProjCreate = new JButton();
        this.bProjDelete = new JButton();
        this.bProjClone = new JButton();
        this.bProjSort = new JButton();
        this.bProjReport = new JButton();
        this.spProjects = new JScrollPane();
        this.$projTable = this.projTable;
        this.pTask = new JPanel();
        this.spTasks = new JScrollPane();
        this.$taskTable = this.taskTable;
        this.pTaskButtons = new JPanel();
        this.bTaskCreate = new JButton();
        this.bTaskDelete = new JButton();
        this.bTaskClone = new JButton();
        this.bTaskSort = new JButton();
        this.bTaskReport = new JButton();
        this.lTasks = new JLabel();
        this.pParameters = new JPanel();
        this.pParamButtons = new JPanel();
        this.bParamReport = new JButton();
        this.bParamDefault = new JButton();
        this.bHomePage = new JButton();
        this.jLabel1 = new JLabel();
        this.splitParam = new JSplitPane();
        this.spParam = new JScrollPane();
        this.$paramTable = this.paramTable;
        this.pParamDescr = new JPanel();
        this.spDescr = new JScrollPane();
        this.paramDescr = new JTextPane();
        this.jLabel2 = new JLabel();
        FormListener formListener = new FormListener();
        this.setDefaultCloseOperation(3);
        this.tabbedPane.setTabLayoutPolicy(1);
        this.tabbedPane.addChangeListener(formListener);
        this.pWorkSheet.setLayout(new GridBagLayout());
        this.pDays.setLayout(new GridBagLayout());
        this.bDayPrev.setText("Previous");
        this.bDayPrev.setIconTextGap(0);
        this.bDayPrev.setMargin(new Insets(2, 0, 2, 1));
        this.bDayPrev.setMaximumSize(new Dimension(90, 23));
        this.bDayPrev.setMinimumSize(new Dimension(82, 23));
        this.bDayPrev.setPreferredSize(new Dimension(82, 23));
        this.bDayPrev.addActionListener(formListener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.pDays.add((Component)this.bDayPrev, gridBagConstraints);
        this.lCurrentDay.setFont(new Font("Tahoma", 1, 12));
        this.lCurrentDay.setForeground(this.COLOR_WORK);
        this.lCurrentDay.setText("Thursday, 21.12.2006");
        this.lCurrentDay.setName("~");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.pDays.add((Component)this.lCurrentDay, gridBagConstraints);
        this.bDayNext.setText("Next");
        this.bDayNext.setHorizontalTextPosition(10);
        this.bDayNext.setIconTextGap(2);
        this.bDayNext.setMargin(new Insets(2, 1, 2, 0));
        this.bDayNext.setMaximumSize(new Dimension(90, 23));
        this.bDayNext.setMinimumSize(new Dimension(82, 23));
        this.bDayNext.setPreferredSize(new Dimension(82, 23));
        this.bDayNext.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.pDays.add((Component)this.bDayNext, gridBagConstraints);
        this.bToday.setText("Today");
        this.bToday.setMargin(new Insets(2, 0, 2, 0));
        this.bToday.setMaximumSize(new Dimension(90, 23));
        this.bToday.setMinimumSize(new Dimension(66, 23));
        this.bToday.setPreferredSize(new Dimension(66, 23));
        this.bToday.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.pDays.add((Component)this.bToday, gridBagConstraints);
        this.bGoto.setText("Go to");
        this.bGoto.setIconTextGap(3);
        this.bGoto.setMargin(new Insets(2, 0, 2, 0));
        this.bGoto.setMaximumSize(new Dimension(90, 23));
        this.bGoto.setMinimumSize(new Dimension(80, 23));
        this.bGoto.setPreferredSize(new Dimension(80, 23));
        this.bGoto.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.pDays.add((Component)this.bGoto, gridBagConstraints);
        this.cbTimeOff.setText("Day Off");
        this.cbTimeOff.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbTimeOff.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 1, 0, 0);
        this.pDays.add((Component)this.cbTimeOff, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        this.pWorkSheet.add((Component)this.pDays, gridBagConstraints);
        this.$eventTable.setModel(new EventTableModel(this.applContext));
        this.eventSrollPane.setViewportView(this.$eventTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.pWorkSheet.add((Component)this.eventSrollPane, gridBagConstraints);
        this.pButtons.setLayout(new GridBagLayout());
        this.bCreate.setText("New event");
        this.bCreate.setMaximumSize(new Dimension(65, 65));
        this.bCreate.setMinimumSize(new Dimension(63, 23));
        this.bCreate.setPreferredSize(new Dimension(65, 55));
        this.bCreate.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.pButtons.add((Component)this.bCreate, gridBagConstraints);
        this.bDelete.setText("Delete");
        this.bDelete.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.pButtons.add((Component)this.bDelete, gridBagConstraints);
        this.bClone.setText("Copy");
        this.bClone.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.pButtons.add((Component)this.bClone, gridBagConstraints);
        this.bSort.setText("Sort event");
        this.bSort.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.pButtons.add((Component)this.bSort, gridBagConstraints);
        this.bReport.setText("Report");
        this.bReport.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.pButtons.add((Component)this.bReport, gridBagConstraints);
        this.bAbout.setText("About");
        this.bAbout.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.pButtons.add((Component)this.bAbout, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.pWorkSheet.add((Component)this.pButtons, gridBagConstraints);
        this.pTotal.setLayout(new GridBagLayout());
        this.lTimeTotal.setFont(new Font("Tahoma", 1, 12));
        this.lTimeTotal.setForeground(this.lCurrentDay.getForeground());
        this.lTimeTotal.setText("Period Total:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.pTotal.add((Component)this.lTimeTotal, gridBagConstraints);
        this.tTimeTotal.setEditable(false);
        this.tTimeTotal.setMinimumSize(new Dimension(110, 22));
        this.tTimeTotal.setPreferredSize(new Dimension(100, 22));
        this.tTimeTotal.addMouseListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.pTotal.add((Component)this.tTimeTotal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        this.pWorkSheet.add((Component)this.pTotal, gridBagConstraints);
        this.tabbedPane.addTab("Events ", this.pWorkSheet);
        this.pProjects.setLayout(new BorderLayout());
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.pProj.setLayout(new GridBagLayout());
        this.pProjButtons.setLayout(new GridBagLayout());
        this.bProjCreate.setText("New");
        this.bProjCreate.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.pProjButtons.add((Component)this.bProjCreate, gridBagConstraints);
        this.bProjDelete.setText("Delete");
        this.bProjDelete.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.pProjButtons.add((Component)this.bProjDelete, gridBagConstraints);
        this.bProjClone.setText("Copy");
        this.bProjClone.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.pProjButtons.add((Component)this.bProjClone, gridBagConstraints);
        this.bProjSort.setText("Sort");
        this.bProjSort.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.pProjButtons.add((Component)this.bProjSort, gridBagConstraints);
        this.bProjReport.setText("Report");
        this.bProjReport.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.pProjButtons.add((Component)this.bProjReport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.pProj.add((Component)this.pProjButtons, gridBagConstraints);
        this.$projTable.setModel(new ProjectTableModel(this.applContext));
        this.spProjects.setViewportView(this.$projTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.pProj.add((Component)this.spProjects, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.pProj);
        this.pTask.setLayout(new GridBagLayout());
        this.$taskTable.setModel(new TaskTableModel(this.applContext));
        this.spTasks.setViewportView(this.$taskTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.pTask.add((Component)this.spTasks, gridBagConstraints);
        this.pTaskButtons.setLayout(new GridBagLayout());
        this.bTaskCreate.setText("New task");
        this.bTaskCreate.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.pTaskButtons.add((Component)this.bTaskCreate, gridBagConstraints);
        this.bTaskDelete.setText("Delete task");
        this.bTaskDelete.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.pTaskButtons.add((Component)this.bTaskDelete, gridBagConstraints);
        this.bTaskClone.setText("Copy task");
        this.bTaskClone.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.pTaskButtons.add((Component)this.bTaskClone, gridBagConstraints);
        this.bTaskSort.setText("Sort task");
        this.bTaskSort.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.pTaskButtons.add((Component)this.bTaskSort, gridBagConstraints);
        this.bTaskReport.setText("Report task");
        this.bTaskReport.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.pTaskButtons.add((Component)this.bTaskReport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.pTask.add((Component)this.pTaskButtons, gridBagConstraints);
        this.lTasks.setFont(new Font("Tahoma", 1, 11));
        this.lTasks.setForeground(this.lCurrentDay.getForeground());
        this.lTasks.setText("These are tasks of the selected project:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 6, 0, 0);
        this.pTask.add((Component)this.lTasks, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.pTask);
        this.pProjects.add((Component)this.jSplitPane1, "Center");
        this.tabbedPane.addTab("Projects ", this.pProjects);
        this.pParameters.setLayout(new GridBagLayout());
        this.pParamButtons.setLayout(new GridBagLayout());
        this.bParamReport.setText("Report");
        this.bParamReport.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.pParamButtons.add((Component)this.bParamReport, gridBagConstraints);
        this.bParamDefault.setText("Default");
        this.bParamDefault.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.pParamButtons.add((Component)this.bParamDefault, gridBagConstraints);
        this.bHomePage.setText("<html>Home Page</html>");
        this.bHomePage.setName(".Button.HomePage");
        this.bHomePage.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.pParamButtons.add((Component)this.bHomePage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.pParameters.add((Component)this.pParamButtons, gridBagConstraints);
        this.jLabel1.setText("These are expert options:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 7, 5, 0);
        this.pParameters.add((Component)this.jLabel1, gridBagConstraints);
        this.splitParam.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.splitParam.setOrientation(0);
        this.splitParam.setResizeWeight(1.0);
        this.splitParam.setOneTouchExpandable(true);
        this.spParam.setViewportView(this.$paramTable);
        this.splitParam.setLeftComponent(this.spParam);
        this.pParamDescr.setMinimumSize(new Dimension(100, 60));
        this.pParamDescr.setLayout(new GridBagLayout());
        this.spDescr.setBorder(null);
        this.paramDescr.setBackground(this.getBackground());
        this.paramDescr.setBorder(null);
        this.paramDescr.setEditable(false);
        this.spDescr.setViewportView(this.paramDescr);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pParamDescr.add((Component)this.spDescr, gridBagConstraints);
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setForeground(this.lCurrentDay.getForeground());
        this.jLabel2.setText("Parameter description:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 1, 0);
        this.pParamDescr.add((Component)this.jLabel2, gridBagConstraints);
        this.splitParam.setRightComponent(this.pParamDescr);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.pParameters.add((Component)this.splitParam, gridBagConstraints);
        this.tabbedPane.addTab("Parameters ", this.pParameters);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
    }

    private void cbTimeOffActionPerformed(ActionEvent actionEvent) {
        WorkDay.P_DAYOFF.setValue(this.applContext.getWorkDay(), this.cbTimeOff.isSelected());
        this.lCurrentDay.setForeground(this.cbTimeOff.isSelected() ? this.COLOR_OFF : this.COLOR_WORK);
    }

    private void bHomePageActionPerformed(ActionEvent actionEvent) {
        this.paramTable.submitEditMode(true);
        this.browse(APPL_HOMEPAGE);
    }

    private void bGotoActionPerformed(ActionEvent actionEvent) {
        Date date = new DateDialog(this.applContext).getResult();
        if (date != null) {
            YearMonthDay yearMonthDay = new YearMonthDay(date);
            this.applContext.selectWorkDay(yearMonthDay);
            this.changeCurrentDate(Integer.MIN_VALUE);
        }
    }

    private void bParamDefaultActionPerformed(ActionEvent actionEvent) {
        UjoTableModel ujoTableModel = this.paramTable.getModel();
        for (int i = ujoTableModel.getRowCount() - 1; i >= 0; --i) {
            UjoPropertyRow ujoPropertyRow = (UjoPropertyRow)ujoTableModel.getRowNullable(i);
            UjoProperty ujoProperty = ujoPropertyRow.getProperty();
            ujoPropertyRow.writeValue(UjoPropertyRow.P_VALUE, ujoProperty.getDefault());
        }
        ujoTableModel.fireTableAllRowUpdated();
    }

    private void bParamReportActionPerformed(ActionEvent actionEvent) {
        this.paramTable.submitEditMode(true);
        this.showTableReport(this.paramTable, "Parameter Report");
    }

    private void tabbedPaneStateChanged(ChangeEvent changeEvent) {
        block6: {
            if (this.tables != null) {
                try {
                    for (UjoTable ujoTable : this.tables) {
                        ujoTable.submitEditMode(true);
                    }
                }
                catch (RuntimeException runtimeException) {
                    this.showMessage(runtimeException.getMessage(), runtimeException);
                    if (!(runtimeException instanceof RuntimeException)) break block6;
                    throw runtimeException;
                }
            }
        }
        if (this.applContext.getWorkSpace() != null && this.tabbedPane.getSelectedComponent() == this.pWorkSheet) {
            this.setTableEventEditor();
            this.displaySelectedDay();
            this.bSortActionPerformed(null);
        }
        if (this.tabbedPane.getSelectedComponent() == this.pParameters && this.paramTable.getSelectedRow() < 0) {
            this.paramTable.selectRow(0);
        }
    }

    private void bAboutActionPerformed(ActionEvent actionEvent) {
        Package package_ = Ujo.class.getPackage();
        this.eventTable.submitEditMode(true);
        ApplTools.aboutApplication(this, APPL_NAME, APPL_VERSION, "GNU/GPL 2", "<a href=\"http://jworksheet.ponec.net/\">http://jworksheet.ponec.net/</a>", APPL_RELEASED, "NetBeans 6.1", "Mark James' icons<br>&nbsp;(Creative Commons Attribution License)<br>&nbsp;<a href=\"http://famfamfam.com\">http://famfamfam.com</a>", package_.getSpecificationTitle() + " " + package_.getSpecificationVersion() + "<br>&nbsp;(Apache License, Version 2.0)" + "<br>&nbsp;<a href=\"http://ujoframework.org\">http://ujoframework.org</a>", new ResourceProvider().getIcon(ResourceProvider.LOGO), ApplTools.createCloseButton(this.applContext.getLanguageManager().getText("OK")), this.applContext.getLanguageManager());
    }

    private void bTaskReportActionPerformed(ActionEvent actionEvent) {
        this.showTableReport(this.taskTable, "Task Report");
    }

    private void bProjReportActionPerformed(ActionEvent actionEvent) {
        this.showTableReport(this.projTable, "Project Report");
    }

    private void bReportActionPerformed(ActionEvent actionEvent) {
        this.eventTable.submitEditMode(true);
        this.bSortActionPerformed(actionEvent);
        this.applContext.saveData(true);
        ReportDialog reportDialog = new ReportDialog((Frame)this, this.applContext);
        reportDialog.setVisible(true);
        Boolean bl = reportDialog.getResult();
    }

    private void bTaskSortActionPerformed(ActionEvent actionEvent) {
        this.taskTable.submitEditMode(true);
        this.taskTable.getModel().sort(TaskType.P_ID, TaskType.P_DESCR);
        this.taskTable.showSortedColumn(TaskType.P_ID);
    }

    private void bTaskCloneActionPerformed(ActionEvent actionEvent) {
        this.taskTable.submitEditMode(true);
        int n = this.taskTable.getSelectedRow();
        if (n >= 0) {
            this.taskTable.getModel().cloneRow(n, 2, this);
        }
        this.taskTable.selectRow(Integer.MAX_VALUE);
    }

    private void bTaskDeleteActionPerformed(ActionEvent actionEvent) {
        int n = this.taskTable.getSelectedRow();
        if (n >= 0) {
            this.taskTable.getModel().deleteRow(n);
        }
        this.taskTable.selectRow(n);
    }

    private void bTaskCreateActionPerformed(ActionEvent actionEvent) {
        TaskType taskType = new TaskType();
        this.taskTable.getModel().addRow(taskType);
        this.taskTable.selectRow(Integer.MAX_VALUE);
    }

    private void bProjSortActionPerformed(ActionEvent actionEvent) {
        this.projTable.submitEditMode(true);
        this.projTable.getModel().sort(Project.P_ID, Project.P_DESCR);
        this.projTable.showSortedColumn(Project.P_ID);
    }

    private void bProjCloneActionPerformed(ActionEvent actionEvent) {
        this.projTable.submitEditMode(true);
        int n = this.projTable.getSelectedRow();
        if (n >= 0) {
            this.projTable.getModel().cloneRow(n, 3, this);
        }
        this.projTable.selectRow(Integer.MAX_VALUE);
    }

    private void bProjDeleteActionPerformed(ActionEvent actionEvent) {
        int n = this.projTable.getSelectedRow();
        if (n >= 0) {
            this.projTable.getModel().deleteRow(n);
        }
        this.projTable.selectRow(n);
    }

    private void bProjCreateActionPerformed(ActionEvent actionEvent) {
        this.taskTable.submitEditMode(true);
        Project project = new Project();
        this.projTable.getModel().addRow(project);
        this.projTable.selectRow(Integer.MAX_VALUE);
    }

    private void bSortActionPerformed(ActionEvent actionEvent) {
        this.eventTable.submitEditMode(true);
        int n = this.eventTable.getSelectedRow();
        EventTableModel eventTableModel = (EventTableModel)this.eventTable.getModel();
        Event event = (Event)eventTableModel.getRowNullable(n);
        boolean bl = n == eventTableModel.getRowCount() - 1;
        eventTableModel.sort(bl);
        if (event != null) {
            this.eventTable.selectRow(event);
        }
    }

    private void bTodayActionPerformed(ActionEvent actionEvent) {
        this.changeCurrentDate(0);
    }

    private void bDayNextActionPerformed(ActionEvent actionEvent) {
        int n = actionEvent.getSource() == this.bDayNext ? 1 : -1;
        this.changeCurrentDate(n);
    }

    private void bCloneActionPerformed(ActionEvent actionEvent) {
        this.eventTable.submitEditMode(true);
        int n = this.eventTable.getSelectedRow();
        if (n >= 0) {
            UjoTableModel ujoTableModel = this.eventTable.getModel();
            int n2 = ujoTableModel.getRowCount();
            Time time = (Time)ujoTableModel.getValueAt(n2 - 1, Event.P_TIME);
            Time time2 = this.applContext.isToday() ? new Time(true) : ((Event)ujoTableModel.getRowLast()).getTimeFinished();
            Short s = time2.substract(time);
            ujoTableModel.cloneRow(n, 2, this);
            ujoTableModel.setValueAt((Object)s, n2 - 1, Event.P_PERIOD);
            ujoTableModel.setValueAt((Object)time2, n2, Event.P_TIME);
            ujoTableModel.setValueAt((Object)Event.ZERO_SHORT, n2, Event.P_PERIOD);
        }
        this.eventTable.selectRow(Integer.MAX_VALUE);
    }

    private void bDeleteActionPerformed(ActionEvent actionEvent) {
        this.eventTable.submitEditMode(true);
        int n = this.eventTable.getSelectedRow();
        if (n >= 0) {
            this.eventTable.getModel().deleteRow(n);
        }
        this.eventTable.selectRow(n);
        this.bSortActionPerformed(actionEvent);
    }

    private void bCreateActionPerformed(ActionEvent actionEvent) {
        Event event = new Event().initTime();
        EventTableModel eventTableModel = (EventTableModel)this.eventTable.getModel();
        if (!this.applContext.isToday()) {
            if (this.eventTable.getRowCount() > 0) {
                Event event2 = (Event)eventTableModel.getRowLast();
                Time time = event2.getTimeFinished();
                Event.P_TIME.setValue(event, time);
            } else {
                Time time = new Time(480);
                Event.P_TIME.setValue(event, time);
            }
        }
        eventTableModel.insertRowAndDefault(event);
        this.eventTable.selectRow(Integer.MAX_VALUE);
    }

    private void tTimeTotalMouseClicked(MouseEvent mouseEvent) {
        this.bSortActionPerformed(null);
    }

    public void createWorkEvent(boolean bl) {
        if (bl) {
            this.changeCurrentDate(0);
        }
        this.tabbedPane.setSelectedIndex(0);
        this.bCreateActionPerformed(null);
    }

    private void initHotKeys() {
        ApplTools.registerAction(KeyStroke.getKeyStroke(116, 0), "NewEvent", this.getRootPane(), new AbstractAction("NewEvent"){

            public void actionPerformed(ActionEvent actionEvent) {
                JWorkSheet.this.createWorkEvent(true);
            }
        });
        ApplTools.registerAction(KeyStroke.getKeyStroke(117, 0), "SortEvent", this.getRootPane(), new AbstractAction("SortEvent"){

            public void actionPerformed(ActionEvent actionEvent) {
                JWorkSheet.this.tabbedPane.setSelectedIndex(0);
                JWorkSheet.this.bSortActionPerformed(actionEvent);
            }
        });
    }

    public void setVisibleLock(boolean bl) {
        this.visibleLock = bl;
        if (bl) {
            super.setVisible(true);
        } else if (this.applContext.isToday()) {
            this.bSortActionPerformed(null);
        }
    }

    public void setVisible(boolean bl) {
        if (!this.visibleLock) {
            super.setVisible(bl);
        }
    }

    public static void main(String[] stringArray) {
        ApplContext applContext = new ApplContext();
        Throwable throwable = null;
        try {
            applContext.setUserConfigDir(stringArray.length > 0 ? stringArray[0] : null);
            applContext.loadData();
            ApplTools.initLookAndFeel(Parameters.P_NIMBUS_LAF.of(applContext.getParameters()));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        new JWorkSheet(applContext, throwable).setVisible();
    }

    private class FormListener
    implements ActionListener,
    MouseListener,
    ChangeListener {
        FormListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == JWorkSheet.this.bDayPrev) {
                JWorkSheet.this.bDayNextActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bDayNext) {
                JWorkSheet.this.bDayNextActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bToday) {
                JWorkSheet.this.bTodayActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bGoto) {
                JWorkSheet.this.bGotoActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.cbTimeOff) {
                JWorkSheet.this.cbTimeOffActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bCreate) {
                JWorkSheet.this.bCreateActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bDelete) {
                JWorkSheet.this.bDeleteActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bClone) {
                JWorkSheet.this.bCloneActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bSort) {
                JWorkSheet.this.bSortActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bReport) {
                JWorkSheet.this.bReportActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bAbout) {
                JWorkSheet.this.bAboutActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bProjCreate) {
                JWorkSheet.this.bProjCreateActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bProjDelete) {
                JWorkSheet.this.bProjDeleteActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bProjClone) {
                JWorkSheet.this.bProjCloneActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bProjSort) {
                JWorkSheet.this.bProjSortActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bProjReport) {
                JWorkSheet.this.bProjReportActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bTaskCreate) {
                JWorkSheet.this.bTaskCreateActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bTaskDelete) {
                JWorkSheet.this.bTaskDeleteActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bTaskClone) {
                JWorkSheet.this.bTaskCloneActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bTaskSort) {
                JWorkSheet.this.bTaskSortActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bTaskReport) {
                JWorkSheet.this.bTaskReportActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bParamReport) {
                JWorkSheet.this.bParamReportActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bParamDefault) {
                JWorkSheet.this.bParamDefaultActionPerformed(actionEvent);
            } else if (actionEvent.getSource() == JWorkSheet.this.bHomePage) {
                JWorkSheet.this.bHomePageActionPerformed(actionEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() == JWorkSheet.this.tTimeTotal) {
                JWorkSheet.this.tTimeTotalMouseClicked(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == JWorkSheet.this.tabbedPane) {
                JWorkSheet.this.tabbedPaneStateChanged(changeEvent);
            }
        }
    }
}

