/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.ponec.jworksheet.core.ApplContext;
import net.ponec.jworksheet.core.LanguageManager;
import net.ponec.jworksheet.resources.ResourceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplTools {
    private static final Logger LOGGER = Logger.getLogger("ApplTools");

    public static StringBuffer getStackTraceBuf(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        if (throwable == null) {
            stringWriter.write("Undefined exception (null).");
        } else {
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println("" + throwable);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
        }
        return stringWriter.getBuffer();
    }

    public static DecimalFormat createDecimalFormat(String string) {
        return ApplTools.createDecimalFormat(string, Locale.US);
    }

    public static DecimalFormat createDecimalFormat(String string, Locale locale) {
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getNumberInstance(locale);
        decimalFormat.applyPattern(string);
        return decimalFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            ApplTools.copy(inputStream, file2);
            file2.setLastModified(file.lastModified());
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, File file) throws IOException {
        OutputStream outputStream = null;
        try {
            int n;
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            while ((n = inputStream.read()) != -1) {
                outputStream.write(n);
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public static void resetTime(Calendar calendar) {
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void setClipboard(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    public static int getCurrentYear() {
        String string = "2009/09/13";
        int n = string.indexOf(47);
        try {
            string = string.substring(0, n);
            return Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            LOGGER.severe("Bad year: " + string);
            return -1;
        }
    }

    public static void aboutApplication(Object object, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, Icon icon, JButton jButton, LanguageManager languageManager) {
        int n = ApplTools.getCurrentYear();
        int n2 = Math.max(n, Calendar.getInstance().get(1));
        if (n2 > n + 9) {
            n2 = n + 9;
        }
        String string9 = "</td></tr><tr><td valign=top>";
        String[] stringArray = new String[]{"<html>", "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"  style=\"font-weight:bold;\">", "<tr><td>", languageManager.getText("Application"), "</td><td>: ", string, string9, languageManager.getText("Version"), "</td><td>: ", string2, string9, languageManager.getText("Copyright") + "&nbsp;", "</td><td>: ", "\u00a9 " + n2 + " PPonec", string9, languageManager.getText("License"), "</td><td>: ", string3, string9, languageManager.getText("Home"), "</td><td>: ", string4, string9, languageManager.getText("Finished"), "</td><td>: ", string5, string9, languageManager.getText("Library"), "</td><td>: ", string8, "</td></tr>", string9, languageManager.getText("Icons"), "</td><td>: ", string7, string9, languageManager.getText("Java"), "</td><td>: ", System.getProperty("java.version"), " - ", System.getProperty("java.vendor"), string9, languageManager.getText("IDE"), "</td><td>: ", string6, string9, languageManager.getText("TranslatedBy"), "</td><td>: ", languageManager.getText("TranslatedBy.YOUR_NAME"), "</td></tr>", "</table></html>"};
        JOptionPane.showOptionDialog(object instanceof Component ? (Component)object : null, ApplTools.stringCat("", stringArray), languageManager.getText("About"), 0, 1, icon, new JButton[]{jButton}, jButton);
    }

    public static String stringCat(String string, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder(256);
        if (string == null) {
            string = "";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            if (i > 0) {
                stringBuilder.append(string);
            }
            if ((string2 = stringArray[i]) == null) continue;
            stringBuilder.append(string2);
        }
        stringArray = null;
        return stringBuilder.toString();
    }

    public static final boolean isValid(CharSequence charSequence) {
        boolean bl = charSequence != null && charSequence.length() > 0;
        return bl;
    }

    public static boolean isWindowsOS() {
        boolean bl = System.getProperty("os.name").startsWith("Windows");
        return bl;
    }

    public static boolean isLinuxOS() {
        boolean bl = System.getProperty("os.name").startsWith("Linux");
        return bl;
    }

    public static JSpinner createSpinnerDate(String string, Locale locale) {
        JSpinner jSpinner = new JSpinner(new SpinnerDateModel());
        jSpinner.setLocale(locale);
        jSpinner.setEditor(new JSpinner.DateEditor(jSpinner, string));
        jSpinner.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                ApplTools.valueMouseWheelMoved(mouseWheelEvent);
            }
        });
        return jSpinner;
    }

    public static void valueMouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        try {
            Object object;
            JSpinner jSpinner = (JSpinner)mouseWheelEvent.getSource();
            Object object2 = object = mouseWheelEvent.getWheelRotation() <= 0 ? jSpinner.getNextValue() : jSpinner.getPreviousValue();
            if (object != null) {
                jSpinner.setValue(object);
            }
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.WARNING, "A spinner exception.", throwable);
        }
    }

    public static void setAlign(JSpinner jSpinner, int n) {
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField();
        jFormattedTextField.setHorizontalAlignment(n);
    }

    public static void rename(File file, File file2) throws IOException {
        boolean bl;
        File file3 = null;
        if (file2.exists()) {
            file3 = new File(file2.getParent(), file2.getName() + "$");
            file3.delete();
            file2.renameTo(file3);
        }
        if (!(bl = file.renameTo(file2))) {
            throw new IOException("Can't rename temporary file " + file);
        }
        if (file3 != null) {
            file3.delete();
        }
    }

    public static File makeXslTransformation(StreamSource streamSource, StreamSource streamSource2, ArrayList<String[]> arrayList) throws TransformerConfigurationException, TransformerException, IOException {
        Object object2;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Templates templates = transformerFactory.newTemplates(streamSource2);
        Transformer transformer = templates.newTransformer();
        if (arrayList != null) {
            for (Object object2 : arrayList) {
                transformer.setParameter(object2[0], object2[1]);
            }
        }
        File file = File.createTempFile("_report.", ".html");
        file.deleteOnExit();
        object2 = new StreamResult(file);
        transformer.transform(streamSource, (Result)object2);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(File file, Charset charset, int n) throws IOException {
        if (file == null || !file.isFile()) {
            return "";
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
            int n2 = (int)Math.min((long)n, file.length());
            char[] cArray = new char[n2];
            int n3 = inputStreamReader.read(cArray);
            String string = new String(cArray, 0, n3);
            return string;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static void registerEscapeAction(JComponent jComponent, Action action) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        ApplTools.registerAction(keyStroke, "Cancely", jComponent, action);
    }

    public static void registerAction(KeyStroke keyStroke, String string, JComponent jComponent, Action action) {
        jComponent.getInputMap(1).put(keyStroke, string);
        jComponent.getActionMap().put(string, action);
    }

    public static void windowsSizing(Window window, Rectangle rectangle) {
        if (rectangle.x < 0 || rectangle.y < 0) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            rectangle = (Rectangle)rectangle.clone();
            rectangle.x = dimension.width - rectangle.width >> 1;
            rectangle.y = dimension.height - rectangle.height >> 1;
        }
        window.setBounds(rectangle);
    }

    public static void browse(URI uRI, String string) throws IOException, UnsupportedOperationException {
        String string2 = string = string != null ? string.trim() : "";
        if (ApplTools.isValid(string)) {
            String string3 = string.indexOf(32) >= 0 ? "\"" : "";
            String string4 = string3 + string + string3 + " " + uRI.toString();
            Process process = Runtime.getRuntime().exec(string4);
        } else {
            try {
                Class<?> clazz = Class.forName("java.awt.Desktop");
                Method method = clazz.getMethod("isDesktopSupported", new Class[0]);
                Method method2 = clazz.getMethod("getDesktop", new Class[0]);
                Method method3 = clazz.getMethod("browse", uRI.getClass());
                Boolean bl = (Boolean)method.invoke(null, new Object[0]);
                if (!bl.booleanValue()) {
                    throw new UnsupportedOperationException();
                }
                Object object = method2.invoke(null, new Object[0]);
                method3.invoke(object, uRI);
            }
            catch (Exception exception) {
                String string5 = ApplTools.isWindowsOS() ? "rundll32 url.dll,FileProtocolHandler " : "firefox ";
                string5 = string5 + uRI.toString();
                Process process = Runtime.getRuntime().exec(string5);
            }
        }
    }

    public static void setCursorWait(boolean bl, ApplContext applContext) {
        int n = bl ? 3 : 0;
        applContext.getTopFrame().setCursor(Cursor.getPredefinedCursor(n));
    }

    public static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            LOGGER.log(Level.WARNING, "err", interruptedException);
        }
    }

    public static JButton createCloseButton(String string) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComponent jComponent = (JComponent)actionEvent.getSource();
                JDialog jDialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, jComponent);
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        };
        JButton jButton = new JButton(string, new ResourceProvider().getIcon("_tick.png"));
        jButton.setMnemonic(string.charAt(0));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static String newString(byte[] byArray, Charset charset) {
        String string;
        try {
            string = new String(byArray, charset.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray);
        }
        return string;
    }

    public static byte[] getBytes(String string, Charset charset) {
        byte[] byArray;
        try {
            byArray = string.getBytes(charset.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        return byArray;
    }

    public static void initLookAndFeel(boolean bl) throws UnsupportedLookAndFeelException {
        String string = System.getProperty("swing.defaultlaf");
        if (string == null) {
            try {
                if (!bl) {
                    throw new UnsupportedLookAndFeelException("");
                }
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            }
            catch (Exception exception) {
                try {
                    UIManager.setLookAndFeel(ApplTools.isLinuxOS() ? "com.sun.java.swing.plaf.gtk.GTKLookAndFeel" : UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception exception2) {
                    LOGGER.log(Level.WARNING, "Look&Feel", exception2);
                }
            }
        }
    }

    public static boolean isNimbusLAF() {
        return "Nimbus".equals(UIManager.getLookAndFeel().getName());
    }

    public static Color modify(Color color, int n) {
        int n2 = ApplTools.colorLimit(n + color.getRed());
        int n3 = ApplTools.colorLimit(n + color.getGreen());
        int n4 = ApplTools.colorLimit(n + color.getBlue());
        return new Color(n2, n3, n4);
    }

    private static int colorLimit(int n) {
        int n2 = n > 254 ? 254 : Math.max(0, n);
        return n2;
    }

    public static final <T> Class<T> getClass(String string, File file) throws MalformedURLException, ClassNotFoundException {
        URL[] uRLArray = new URL[]{file.toURI().toURL()};
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, ApplTools.class.getClassLoader());
        Class<?> clazz = Class.forName(string, true, uRLClassLoader);
        return clazz;
    }
}

