/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.bo.item;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import net.ponec.jworksheet.bo.Parameters;
import net.ponec.jworksheet.core.ApplContext;
import net.ponec.jworksheet.core.ApplTools;
import org.ujoframework.extensions.UjoCloneable;
import org.ujoframework.extensions.ValueTextable;

public class YearMonthDay
implements Comparable,
ValueTextable,
UjoCloneable {
    public static final int TYPE_DAY = 0;
    public static final int TYPE_MONTH = 1;
    public static final int TYPE_YEAR = 2;
    public static final SimpleDateFormat exportDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.US);
    private int yearMonthDay;

    protected YearMonthDay(int n) {
        this.yearMonthDay = n;
    }

    public YearMonthDay(String string) {
        try {
            Date date = exportDateFormat.parse(string);
            this.setYearMonthDay(date);
        }
        catch (Throwable throwable) {
            new IllegalArgumentException("Bad parameter: " + string, throwable);
        }
    }

    public YearMonthDay(Date date) {
        this.setYearMonthDay(date);
    }

    public YearMonthDay() {
        this.setToday();
    }

    public void setYearMonthDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.setYearMonthDay(calendar);
    }

    public void setYearMonthDay(Calendar calendar) {
        int n = 0;
        n += calendar.get(1) * 100 * 100;
        n += calendar.get(2) * 100;
        this.yearMonthDay = n += calendar.get(5);
    }

    public int get(int n) {
        switch (n) {
            case 2: {
                return this.yearMonthDay / 100 / 100;
            }
            case 1: {
                return this.yearMonthDay / 100 % 100;
            }
            case 0: {
                return this.yearMonthDay % 100;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    public Calendar getCalendar() {
        int n = this.get(2);
        int n2 = this.get(1);
        int n3 = this.get(0);
        Calendar calendar = Calendar.getInstance();
        ApplTools.resetTime(calendar);
        calendar.set(1, n);
        calendar.set(2, n2);
        calendar.set(5, n3);
        return calendar;
    }

    public Date getTime() {
        return this.getCalendar().getTime();
    }

    public void addDay(int n) {
        Calendar calendar = this.getCalendar();
        calendar.add(5, n);
        this.setYearMonthDay(calendar);
    }

    public void setToday() {
        Calendar calendar = Calendar.getInstance();
        ApplTools.resetTime(calendar);
        this.setYearMonthDay(calendar);
    }

    public String toString() {
        Calendar calendar = this.getCalendar();
        String string = exportDateFormat.format(calendar.getTime());
        return string;
    }

    public String toString(ApplContext applContext) {
        Locale locale = Parameters.P_LANG.of(applContext.getParameters());
        String string = applContext.getParameters().getDateFormat(Parameters.P_DATE_MAIN_FORMAT, applContext);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
        String string2 = simpleDateFormat.format(this.getTime());
        return string2;
    }

    public boolean equals(Object object) {
        boolean bl = object != null && ((YearMonthDay)object).yearMonthDay == this.yearMonthDay;
        return bl;
    }

    public YearMonthDay cloneDay() {
        return new YearMonthDay(this.yearMonthDay);
    }

    public int compareTo(Object object) {
        int n = this.yearMonthDay < ((YearMonthDay)object).yearMonthDay ? -1 : (this.yearMonthDay > ((YearMonthDay)object).yearMonthDay ? 1 : 0);
        return n;
    }

    public Object clone(int n, Object object) {
        return n <= 0 ? this : new YearMonthDay(this.yearMonthDay);
    }
}

