/*
 * Decompiled with CFR 0.152.
 */
package net.ponec.jworksheet.bo;

import net.ponec.jworksheet.bo.Project;
import net.ponec.jworksheet.bo.TaskType;
import net.ponec.jworksheet.bo.item.Time;
import net.ponec.jworksheet.core.ApplTools;
import org.ujoframework.UjoProperty;
import org.ujoframework.core.UjoService;
import org.ujoframework.extensions.UjoAction;
import org.ujoframework.implementation.bean.BeanUjo;

public class Event
extends BeanUjo {
    public static final byte[] ZERO_BYTES = new byte[0];
    public static final Short ZERO_SHORT = 0;
    public static final UjoProperty<Event, Time> P_TIME = Event.newProperty("Time", Time.class);
    public static final UjoProperty<Event, Short> P_PERIOD = Event.newProperty("Period", ZERO_SHORT);
    public static final UjoProperty<Event, Project> P_PROJ = Event.newProperty("Project", Project.class);
    public static final UjoProperty<Event, Integer> P_PROJID = Event.newProperty("ProjectID", Integer.class);
    public static final UjoProperty<Event, TaskType> P_TASK = Event.newProperty("Task", TaskType.class);
    public static final UjoProperty<Event, Integer> P_TASKID = Event.newProperty("TaskID", Integer.class);
    public static final UjoProperty<Event, String> P_DESCR = Event.newProperty("Description", "");
    private short time;
    private short period;
    private Project project;
    private Integer projectID;
    private TaskType task;
    private Integer taskID;
    private byte[] descr = ZERO_BYTES;

    @Deprecated
    public Time getTime() {
        return new Time(this.time);
    }

    @Deprecated
    public void setTime(Time time) {
        this.time = time.getTimeMinutes();
    }

    @Deprecated
    public short getPeriod() {
        return this.period;
    }

    @Deprecated
    public void setPeriod(short s) {
        this.period = s;
    }

    @Deprecated
    public Project getProject() {
        return this.project;
    }

    @Deprecated
    public void setProject(Project project) {
        this.project = project;
    }

    @Deprecated
    public Integer getProjectID() {
        return this.projectID;
    }

    @Deprecated
    public void setProjectID(Integer n) {
        this.projectID = n;
    }

    @Deprecated
    public TaskType getTask() {
        return this.task;
    }

    @Deprecated
    public void setTask(TaskType taskType) {
        this.task = taskType;
    }

    @Deprecated
    public Integer getTaskID() {
        return this.taskID;
    }

    @Deprecated
    public void setTaskID(Integer n) {
        this.taskID = n;
    }

    @Deprecated
    public String getDescription() {
        return ApplTools.newString(this.descr, UjoService.UTF_8);
    }

    @Deprecated
    public void setDescription(String string) {
        this.descr = string != null ? ApplTools.getBytes(string, UjoService.UTF_8) : ZERO_BYTES;
    }

    public Event initTime() {
        P_TIME.setValue(this, new Time(true));
        return this;
    }

    public void setPeriod(Time time) {
        short s = time.substract(P_TIME.of(this));
        P_PERIOD.setValue(this, s);
    }

    public boolean isPrivate() {
        Project project = P_PROJ.of(this);
        boolean bl = project != null && Project.P_PRIVATE.of(project) != false;
        return bl;
    }

    public boolean readAuthorization(UjoAction ujoAction, UjoProperty ujoProperty, Object object) {
        switch (ujoAction.getType()) {
            case 2: {
                boolean bl = ujoProperty != P_PROJ && ujoProperty != P_TASK;
                return bl;
            }
        }
        return super.readAuthorization(ujoAction, ujoProperty, object);
    }

    public Object readValue(UjoProperty ujoProperty) {
        TaskType taskType;
        Project project;
        Object object = ujoProperty == P_PROJID ? ((project = P_PROJ.of(this)) != null ? Project.P_ID.of(project) : super.readValue(ujoProperty)) : (ujoProperty == P_TASKID ? ((taskType = P_TASK.of(this)) != null ? TaskType.P_ID.of(taskType) : super.readValue(ujoProperty)) : super.readValue(ujoProperty));
        return object;
    }

    public void writeValue(UjoProperty ujoProperty, Object object) {
        if (P_PERIOD == ujoProperty && (object == null || (Short)object <= 0)) {
            object = ZERO_SHORT;
        }
        super.writeValue(ujoProperty, object);
    }

    public boolean isFinished(UjoProperty ujoProperty) {
        if (P_PROJ == ujoProperty) {
            Project project = P_PROJ.of(this);
            return project != null && Project.P_FINISHED.of(project) != false;
        }
        if (P_TASK == ujoProperty) {
            TaskType taskType = P_TASK.of(this);
            return this.isFinished(P_PROJ) || taskType != null && TaskType.P_FINISHED.of(taskType) != false;
        }
        return false;
    }

    public Time getTimeFinished() {
        Time time = P_TIME.of(this).cloneAdd(P_PERIOD.of(this).shortValue());
        return time;
    }

    static {
        Event.init(Event.class, true);
    }
}

