/*
 * Decompiled with CFR 0.152.
 */
package org.ujoframework.swing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.ujoframework.Ujo;
import org.ujoframework.UjoProperty;
import org.ujoframework.core.UjoComparator;
import org.ujoframework.core.UjoManager;
import org.ujoframework.extensions.UjoCloneable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UjoTableModel<ROW extends Ujo>
extends AbstractTableModel {
    public static final int EVENT_REPAINT_HEADER = 1000;
    protected UjoProperty[] columns;
    protected List<ROW> rows;

    public UjoTableModel(UjoProperty ... ujoPropertyArray) {
        this.columns = ujoPropertyArray;
        this.initData();
    }

    public UjoTableModel(Class clazz) {
        this(UjoManager.getInstance().readProperties(clazz).toArray());
    }

    protected void initData() {
        this.rows = new ArrayList<ROW>();
    }

    protected UjoManager getUjoManager() {
        return UjoManager.getInstance();
    }

    public void setRows(List<ROW> list) {
        if (list == null) {
            throw new IllegalArgumentException("Can't assign a null value");
        }
        this.rows = list;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    public UjoProperty getColumn(int n) {
        return this.columns[n];
    }

    public void setColumns(UjoProperty ... ujoPropertyArray) {
        this.columns = ujoPropertyArray;
        this.fireTableStructureChanged();
    }

    @Override
    public final Object getValueAt(int n, int n2) {
        return this.getValueAt(n, this.columns[n2]);
    }

    @Override
    public final void setValueAt(Object object, int n, int n2) {
        this.setValueAt(object, n, this.columns[n2]);
    }

    @Override
    public final String getColumnName(int n) {
        return this.getColumnName(this.columns[n]);
    }

    @Override
    public final boolean isCellEditable(int n, int n2) {
        return this.isCellEditable(n, this.columns[n2]);
    }

    public final Class getColumnClass(int n) {
        return this.getColumnClass(this.columns[n]);
    }

    public ROW getRow(int n) throws IndexOutOfBoundsException {
        return (ROW)((Ujo)this.rows.get(n));
    }

    public ROW getRowNullable(int n) {
        return (ROW)(n >= 0 && n < this.rows.size() ? (Ujo)this.rows.get(n) : null);
    }

    public ROW getRowLast() {
        return this.getRowNullable(this.rows.size() - 1);
    }

    public Object getValueAt(int n, UjoProperty ujoProperty) {
        return ((Ujo)this.rows.get(n)).readValue(ujoProperty);
    }

    public void setValueAt(Object object, int n, UjoProperty ujoProperty) {
        this.getRow(n).writeValue(ujoProperty, object);
        this.fireTableCellUpdated(n, this.getColumnIndex(ujoProperty));
    }

    public String getColumnName(UjoProperty ujoProperty) {
        return ujoProperty.getName();
    }

    public boolean isCellEditable(int n, UjoProperty ujoProperty) {
        return true;
    }

    public Class getColumnClass(UjoProperty ujoProperty) {
        return ujoProperty.getType();
    }

    public int getColumnIndex(UjoProperty ujoProperty) {
        for (int i = this.columns.length - 1; i >= 0; --i) {
            if (this.columns[i] != ujoProperty) continue;
            return i;
        }
        throw new IllegalArgumentException("Bad column: " + ujoProperty);
    }

    public int getRowIndex(ROW ROW) {
        int n = this.rows.size();
        for (int i = 0; i < n; ++i) {
            if (this.rows.get(i) != ROW) continue;
            return i;
        }
        return -1;
    }

    public ROW deleteRow(int n) {
        Ujo ujo = (Ujo)this.rows.remove(n);
        this.fireTableRowsDeleted(n, n);
        return (ROW)ujo;
    }

    public void addRow(ROW ROW) {
        int n = this.rows.size();
        this.rows.add(ROW);
        this.fireTableRowsInserted(n, n);
    }

    public ROW cloneRow(int n, int n2, Object object) {
        ROW ROW = this.getRow(n);
        Ujo ujo = ROW instanceof UjoCloneable ? (Ujo)((UjoCloneable)ROW).clone(n2, this) : this.getUjoManager().clone((Ujo)ROW, n2, object);
        this.addRow(ujo);
        return (ROW)ujo;
    }

    public void fireTableHeaderRepainted() {
        TableModelEvent tableModelEvent = new TableModelEvent(this, 0, 0, -1, 1000);
        this.fireTableChanged(tableModelEvent);
    }

    public void sort(UjoProperty ... ujoPropertyArray) {
        UjoComparator ujoComparator = new UjoComparator(ujoPropertyArray);
        this.sort(ujoComparator);
    }

    public void sort(Comparator<Ujo> comparator) {
        Collections.sort(this.rows, comparator);
        this.fireTableAllRowUpdated();
    }

    public void fireTableAllRowUpdated() {
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    public void fireTableColumnUpdated(UjoProperty ujoProperty) {
        int n = this.getColumnIndex(ujoProperty);
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.fireTableCellUpdated(i, n);
        }
    }
}

