/*
 * Decompiled with CFR 0.152.
 */
package org.ujoframework.extensions;

import org.ujoframework.Ujo;
import org.ujoframework.UjoProperty;
import org.ujoframework.extensions.SortingProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property<UJO extends Ujo, VALUE>
implements UjoProperty<UJO, VALUE> {
    private String name;
    private int index;
    private Class<VALUE> type;
    private VALUE defaultValue;
    private boolean lock;
    private static int _sequencer = 0;

    protected static final synchronized int _nextSequence() {
        return _sequencer++;
    }

    protected Property(String string, Class<VALUE> clazz, int n) {
        this.init(string, clazz, null, n, true);
    }

    protected Property(String string, VALUE VALUE, int n) {
        this.init(string, null, VALUE, n, true);
    }

    protected Property() {
    }

    protected final Property<UJO, VALUE> init(String string, Class<VALUE> clazz, VALUE VALUE, int n, Boolean bl) {
        if (this.lock) {
            throw new IllegalArgumentException("The property is already initialized: " + this);
        }
        if (VALUE != null) {
            this.defaultValue = VALUE;
            if (clazz == null) {
                clazz = VALUE.getClass();
            }
        }
        int n2 = this.index = n == -1 ? Property._nextSequence() : n;
        if (clazz != null) {
            this.type = clazz;
        }
        if (string != null) {
            this.name = string;
        }
        if (bl != null) {
            this.lock = bl;
        }
        if (this.lock) {
            this.checkAttribs();
        }
        return this;
    }

    final boolean isLock() {
        return this.lock;
    }

    protected void checkAttribs() {
        if (this.name == null) {
            throw new IllegalArgumentException("Name must not be null in the " + this);
        }
        if (this.type == null) {
            throw new IllegalArgumentException("Type must not be null in the " + this);
        }
        if (this.defaultValue != null && !this.type.isInstance(this.defaultValue)) {
            throw new IllegalArgumentException("Default value have not properly type in the " + this);
        }
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Class<VALUE> getType() {
        return this.type;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final void setValue(UJO UJO, VALUE VALUE) {
        UJO.writeValue(this, VALUE);
    }

    @Override
    public final VALUE getValue(UJO UJO) {
        Object object = UJO.readValue(this);
        return (VALUE)object;
    }

    @Override
    public final VALUE of(UJO UJO) {
        Object object = UJO.readValue(this);
        return (VALUE)object;
    }

    @Override
    public VALUE getDefault() {
        return this.defaultValue;
    }

    public <PROPERTY extends Property> PROPERTY setDefault(VALUE VALUE) {
        this.defaultValue = VALUE;
        if (this.lock) {
            this.checkAttribs();
        }
        return (PROPERTY)this;
    }

    public void setValueFromDefault(UJO UJO) {
        this.setValue(UJO, this.defaultValue);
    }

    @Override
    public boolean isDefault(UJO UJO) {
        VALUE VALUE = this.getValue(UJO);
        boolean bl = VALUE == this.defaultValue || this.defaultValue != null && this.defaultValue.equals(VALUE);
        return bl;
    }

    @Override
    public final boolean isDirect() {
        return true;
    }

    @Override
    public boolean isAscending() {
        return true;
    }

    @Override
    public UjoProperty<UJO, VALUE> descending() {
        return new SortingProperty(this, false);
    }

    @Override
    public boolean isTypeOf(Class clazz) {
        return clazz.isAssignableFrom(this.type);
    }

    @Override
    public boolean equals(UJO UJO, VALUE VALUE) {
        Object object = UJO.readValue(this);
        if (object == VALUE) {
            return true;
        }
        boolean bl = object != null && VALUE != null && object.equals(VALUE);
        return bl;
    }

    public int compareTo(UjoProperty ujoProperty) {
        int n = this.index < ujoProperty.getIndex() ? -1 : (this.index > ujoProperty.getIndex() ? 1 : 0);
        return n;
    }

    @Override
    public char charAt(int n) {
        return this.name.charAt(n);
    }

    @Override
    public int length() {
        return this.name.length();
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.name.subSequence(n, n2);
    }

    @Override
    public final String toString() {
        return this.name;
    }

    public static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newInstance(String string, Class<VALUE> clazz, VALUE VALUE, int n, boolean bl) {
        return new Property<UJO, VALUE>().init(string, clazz, VALUE, n, bl);
    }

    public static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newInstance(String string, Class<VALUE> clazz, int n) {
        return new Property<UJO, Object>().init(string, clazz, null, n, true);
    }

    public static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newInstance(String string, Class<VALUE> clazz) {
        return Property.newInstance(string, clazz, -1);
    }

    public static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newInstance(String string, VALUE VALUE, int n) {
        Class<?> clazz = VALUE.getClass();
        return new Property().init(string, clazz, VALUE, n, true);
    }

    public static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newInstance(String string, VALUE VALUE) {
        return Property.newInstance(string, VALUE, -1);
    }

    public static <UJO extends Ujo, VALUE> Property<UJO, VALUE> newInstance(UjoProperty ujoProperty, int n) {
        return Property.newInstance(ujoProperty.getName(), ujoProperty.getType(), ujoProperty.getDefault(), n, true);
    }

    public static <UJO extends Ujo, VALUE> UjoProperty<UJO, VALUE> newInstance(UjoProperty ujoProperty) {
        return Property.newInstance(ujoProperty.getName(), ujoProperty.getType(), ujoProperty.getDefault(), -1, false);
    }
}

