/*
 * Decompiled with CFR 0.152.
 */
package org.ujoframework.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.ujoframework.UjoProperty;
import org.ujoframework.extensions.ListUjoProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanManager<UJO, VALUE> {
    private final UjoProperty property;
    private Method setter;
    private Method getter;

    public BeanManager(UjoProperty ujoProperty) {
        this.property = ujoProperty;
    }

    public void writeValue(UJO UJO, VALUE VALUE) throws IllegalArgumentException {
        try {
            this.getMethod(UJO, true).invoke(UJO, VALUE);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("BeanProperty:" + this.property.getName() + "=" + VALUE, exception);
        }
    }

    public Object readValue(UJO UJO) throws IllegalArgumentException {
        try {
            return this.getMethod(UJO, false).invoke(UJO, new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("BeanProperty:" + this.property.getName(), exception);
        }
    }

    public Method getMethod(UJO UJO, boolean bl) throws IllegalArgumentException {
        Method method;
        Method method2 = method = bl ? this.setter : this.getter;
        if (method == null) {
            String string = this.getMethodName(bl);
            SecurityException securityException = null;
            try {
                Class<?> clazz = UJO.getClass();
                Class clazz2 = bl ? this.property.getType() : null;
                method = this.getMethodPlain(clazz, clazz2, string);
                if (method == null) {
                    if (ListUjoProperty.class.isInstance(this.property) && !string.endsWith("s")) {
                        method = this.getMethodPlain(clazz, clazz2, string + 's');
                    } else if ((clazz2 = this.getPrimitive(clazz2)) != null) {
                        method = this.getMethodPlain(clazz, clazz2, string);
                    }
                }
                if (bl) {
                    this.setter = method;
                } else {
                    this.getter = method;
                }
            }
            catch (SecurityException securityException2) {
                securityException = securityException2;
            }
            if (method == null) {
                throw new IllegalArgumentException("Can't find method: " + string + '(' + this.property.getType().getName() + ')', securityException);
            }
        }
        return method;
    }

    protected Class getPrimitive(Class clazz) {
        if (clazz != null && !clazz.isPrimitive()) {
            try {
                Field field = clazz.getField("TYPE");
                if (field.getType() == Class.class) {
                    Object object = field.get(null);
                    return (Class)object;
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private Method getMethodPlain(Class clazz, Class clazz2, String string) throws SecurityException {
        try {
            Class[] classArray;
            if (clazz2 != null) {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = clazz2;
            } else {
                classArray = null;
            }
            Class[] classArray3 = classArray;
            Method method = clazz.getMethod(string, classArray3);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected String getMethodName(boolean bl) {
        String string = (bl ? "set" : (Boolean.class.equals(this.property.getType()) ? "is" : "get")) + Character.toUpperCase(this.property.getName().charAt(0)) + this.property.getName().substring(1);
        return string;
    }

    public static <UJO, VALUE> BeanManager<UJO, VALUE> getInstance(UjoProperty ujoProperty) {
        return new BeanManager<UJO, VALUE>(ujoProperty);
    }

    public String toString() {
        return ((Object)this.property).toString();
    }
}

