import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

public class JRemind extends Frame implements ActionListener
{
    public JRemind jr;
    private Button next,prev;
    private JRemindData dataarray[];
    private int pos, numofrecords=0;
    private boolean exitonnoevents, showall;
    private int notice;
    private Label date, event, years;
    private String datafile;

    public static void main(String argv[])
    {
        JRemind jr=new JRemind(argv);
    }

    JRemind(String argv[])
    {
        dataarray=new JRemindData[20];
        datafile=new String();

        setTitle("JRemind 1.0");
        setupWindow();
	    addWindowListener(new WindowAdapter() {public void windowClosing(WindowEvent e) {System.exit(0);}});

        readCfgFile("jremind.cfg");
        pos=0;
        prev.setEnabled(false);
        if (datafile==null) {
            try {
                datafile=argv[0];
            } /* endtry */
            catch ( ArrayIndexOutOfBoundsException ex ) {
                datafile=null;
            } /* endcatch */
        } /* endif */
        if (datafile==null) {
            event.setText("No datafile specified, please read the docs.");
            next.setEnabled(false);
        } else {
            ReadData(datafile);
            if (numofrecords==0) {
                // no events
                if (exitonnoevents) 
                    System.exit(0);
                event.setText("No events Coming up");
                next.setEnabled(false);
            } else {
            setData(dataarray[pos]);
            if (numofrecords==1)
                next.setEnabled(false);
            } /* endif */
        } /* endif */
        pack();
        setVisible(true);
    }

    private void readCfgFile(String fname)
    {
        try {
            BufferedReader in=new BufferedReader(new FileReader(fname));
            String cfgline=new String();
            String key=new String();
            while (true) {
                cfgline=in.readLine();
                if (cfgline==null) { break; }
                StringTokenizer st=new StringTokenizer(cfgline, "=", false);
                key=st.nextToken();
                int b;
                switch (key.charAt(0)) {
                    case 'n':
                        notice=Integer.parseInt(st.nextToken());
                        break;
                    case 's':
                        b=Integer.parseInt(st.nextToken());
                        if (b==1)
                            showall=true;
                        break;
                    case 'e':
                        b=Integer.parseInt(st.nextToken());
                        if (b==1)
                            exitonnoevents=true;
                        break;
                    case 'l':
                        StringTokenizer stloc=new StringTokenizer(st.nextToken(), ",");
                        setLocation(Integer.parseInt(stloc.nextToken()), Integer.parseInt(stloc.nextToken()));
                        break;
                    case 'd':
                        datafile=st.nextToken();     
                        break;
                    default: 
                        System.out.println(cfgline+"\n is an invalid config line.  It will be igored.");
                        break;
                } /* endswitch */
            } /* endwhile */
        } /* endtry */
        catch ( FileNotFoundException ex ) {
            System.out.println("File Not Found, setting defaults");
            setCfgDefaults();
        } /* endcatch */
        catch ( IOException ex) {
            System.out.println("IO Exception occured, setting defaults");
            setCfgDefaults();
        } /* endcatch */
        catch ( NoSuchElementException ex) {
            System.out.println("Error in parsing cfgfile, please be sure its formated right.\nSetting Defaults");
            setCfgDefaults();
        } /* endcatch */
    }   /* end readCfgFile */

    private void setCfgDefaults()
    {
        notice=15;
        exitonnoevents=false;
        showall=false;
        datafile=null;
    }

    private void setData(JRemindData jrd)
    {
        date.setText(jrd.getMonth()+"-"+jrd.getDay()+"-"+jrd.getYear());
        event.setText(jrd.getEvent());
        if ( (jrd.getYearsOld()==0) || (jrd.getYear()==0) ) {
            years.setText(""); 
        } else {
            years.setText("is "+jrd.getYearsOld()+" years in the making");
        } /* endif */
    }    
    
    public void actionPerformed(ActionEvent e)
    {
        String s=e.getActionCommand();
        if (s=="Next") 
        {
            if (pos<21) 
            {
                if (dataarray[pos+1]==null) {
                    System.out.println("Out of data");
                } else {
                    pos++;
                    setData(dataarray[pos]);
                    if (dataarray[pos+1]==null) 
                        next.setEnabled(false);
                    if (prev.isEnabled()==false) 
                        prev.setEnabled(true);
                    repaint();
                }
            }
        } else 
        {
            if (pos>0)
            {    
                pos--;
                setData(dataarray[pos]);
                if (next.isEnabled()==false)
                    next.setEnabled(true);
                if (pos==0) 
                    prev.setEnabled(false);
                repaint();
            }
        } /* endif */
    }

    public void addNewDataRecord(int d, int m, int y, int yo, String e)
    {
        dataarray[numofrecords]=new JRemindData(d, m, y, yo, e);
        numofrecords++;
    }
        
    public void ReadData(String fname)
    {
        String dstr,e;
        BufferedReader in;
        dstr=new String();
        e=new String();
        int m,d,y;

        try {
            in=new BufferedReader(new FileReader(fname));
            GregorianCalendar currentdate=new GregorianCalendar();
            GregorianCalendar eventdate=(GregorianCalendar)currentdate.clone();
            GregorianCalendar laterdate=(GregorianCalendar)currentdate.clone();
            laterdate.add(laterdate.DATE, notice);
            while (true) {
                dstr=in.readLine();
                if (dstr==null) { break; }
                e=in.readLine();
                if (e==null) { break;}
                StringTokenizer st=new StringTokenizer(dstr, "-", false);
                m=Integer.parseInt(st.nextToken());
                d=Integer.parseInt(st.nextToken());
                y=Integer.parseInt(st.nextToken());
                eventdate.set(currentdate.get(currentdate.YEAR),m-1,d);
                if (eventdate.get(eventdate.DAY_OF_YEAR)<currentdate.get(currentdate.DAY_OF_YEAR))
                    // near end of year
                    eventdate.roll(eventdate.YEAR, true);
                if (showall==true) {
                    addNewDataRecord(d, m, y, 0, e);
                } else {
                    if ((eventdate.after(currentdate)) && (eventdate.before(laterdate)))
                        addNewDataRecord(d, m, y, eventdate.get(eventdate.YEAR)-y, e);
                } /* endif */
            } /* endwhile */
        } /* endtry */
        catch ( FileNotFoundException ex ) {
            System.out.println("File Not Found");
            System.exit(1);
        } /* endcatch */
        catch ( IOException ex) {
            System.out.println("IO Exception occured");
            System.exit(1);
        } /* endcatch */
        catch ( NoSuchElementException ex) {
            System.out.println("Error in parsing datafile, please be sure its formated right");
            System.exit(1);
        } /* endcatch */
        catch ( NumberFormatException ex ) {
            System.out.println("Error in parsing date line, please be sure its formated right");    
            System.exit(1);
        } /* endcatch */
    }

    private void setupWindow()
    {
        date=new Label();
        event=new Label();
        years=new Label();
        date.setAlignment(Label.CENTER);
        event.setAlignment(Label.CENTER);
        years.setAlignment(Label.CENTER);
        Panel p=new Panel(new BorderLayout());
        p.add(date, BorderLayout.NORTH);
        p.add(event, BorderLayout.CENTER);
        p.add(years, BorderLayout.SOUTH);
        add(p, BorderLayout.NORTH);
        Panel b=new Panel();
        next=new Button("Next");
        prev=new Button("Prev");
        next.addActionListener(this);
        prev.addActionListener(this);
        b.add(next);
        b.add(prev);
        add(b, BorderLayout.SOUTH);
    }

} /* end class JRemind */


