/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import borland.jbcl.model.SingletonModel;
import borland.jbcl.model.SingletonModelEvent;
import borland.jbcl.model.SingletonModelListener;
import borland.jbcl.model.SingletonModelMulticaster;
import borland.jbcl.model.SingletonViewManager;
import borland.jbcl.model.WritableSingletonModel;
import borland.jbcl.view.SingletonView;
import java.awt.Dimension;
import java.awt.TextArea;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;

public class TextAreaView
extends TextArea
implements SingletonView,
SingletonModelListener {
    protected transient SingletonModel model;
    protected transient WritableSingletonModel writeModel;
    protected boolean readOnly;
    protected boolean postOnFocusLost = true;
    protected int preferredHeight;
    protected int preferredWidth;
    protected transient SingletonModelMulticaster modelMulticaster = new SingletonModelMulticaster();

    public TextAreaView() {
        this.enableEvents(12L);
    }

    public SingletonModel getModel() {
        return this.model;
    }

    public void setModel(SingletonModel singletonModel) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = singletonModel;
        this.writeModel = this.model instanceof WritableSingletonModel ? (WritableSingletonModel)singletonModel : null;
        this.setEditable(!this.isReadOnly());
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
            this.updateText();
        }
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void addModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.add(singletonModelListener);
    }

    public void removeModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.remove(singletonModelListener);
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
        this.setEditable(!this.isReadOnly());
    }

    public void setViewManager(SingletonViewManager singletonViewManager) {
    }

    public SingletonViewManager getViewManager() {
        return null;
    }

    public boolean isPostOnFocusLost() {
        return this.postOnFocusLost;
    }

    public void setPostOnFocusLost(boolean bl) {
        this.postOnFocusLost = bl;
    }

    protected void updateText() {
        if (this.model != null) {
            Object object = this.model.get();
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            super.setText(object != null ? object.toString() : "");
            this.setSelectionStart(n);
            this.setSelectionEnd(n2);
        }
    }

    protected void setSuperText(String string) {
        super.setText(string);
    }

    public void setText(String string) {
        if (!this.isReadOnly() && this.writeModel.canSet(true)) {
            String string2 = this.getText();
            if (string2 == null && string == null) {
                return;
            }
            if (string2 != null && string != null && string2.equals(string)) {
                return;
            }
            this.writeModel.set(string);
        }
    }

    protected void postText() {
        if (this.writeModel != null && this.writeModel.canSet(true)) {
            String string = super.getText();
            this.writeModel.set(string);
        }
    }

    public void modelContentChanged(SingletonModelEvent singletonModelEvent) {
        this.updateText();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!this.isReadOnly()) {
            this.writeModel.canSet(true);
        }
        if (keyEvent.getID() == 401) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    if (!keyEvent.isControlDown()) break;
                    this.postText();
                    break;
                }
                case 27: {
                    this.updateText();
                }
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1005) {
            String string = super.getText();
            Object object = this.model.get();
            if (this.postOnFocusLost && !string.equals(object)) {
                this.postText();
            }
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.preferredHeight > dimension.height) {
            dimension = new Dimension(dimension.width, this.preferredHeight);
        }
        if (this.preferredWidth > dimension.width) {
            dimension = new Dimension(this.preferredWidth, dimension.height);
        }
        return dimension;
    }

    public void setPreferredHeight(int n) {
        this.preferredHeight = n;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setPreferredWidth(int n) {
        this.preferredWidth = n;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }
}

