/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.model;

import borland.jbcl.model.IntegerFormatter;
import borland.jbcl.model.Res;
import borland.jbcl.util.InvalidFormatException;
import borland.jbcl.util.Variant;

public class ShortFormatter
extends IntegerFormatter {
    public ShortFormatter(int n) {
        super(n);
    }

    public final void parse(String string, Variant variant) throws InvalidFormatException {
        if (string == null || string.length() == 0) {
            variant.setUnassignedNull();
            return;
        }
        int n = new Integer(string);
        if (n > Short.MAX_VALUE || n < Short.MIN_VALUE) {
            throw new InvalidFormatException(Res.getString(32));
        }
        variant.setAsInt(this.type, n);
    }

    public final void parse(Variant variant, char[] cArray, int n, int n2) throws InvalidFormatException {
        int n3;
        if (cArray == null || n2 == 0 || cArray.length == 0) {
            variant.setUnassignedNull();
            return;
        }
        boolean bl = cArray[n] == '-';
        int n4 = 0;
        if (bl) {
            ++n;
            --n2;
        }
        int n5 = n;
        while (n2 > 0) {
            int n6 = cArray[n5];
            if (n6 >= 48 && n6 <= 57) {
                n6 -= 48;
            } else if ((n6 = Character.digit((char)n6, 10)) < 0) {
                throw new InvalidFormatException(new String(cArray, n, n2));
            }
            n4 = n4 * 10 + n6;
            ++n5;
            --n2;
        }
        int n7 = n3 = bl ? -n4 : n4;
        if (n3 > Short.MAX_VALUE || n3 < Short.MIN_VALUE) {
            throw new InvalidFormatException(Res.getString(32));
        }
        variant.setAsInt(this.type, n3);
    }
}

