/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.model;

import COM.objectspace.jgl.Array;
import COM.objectspace.jgl.ArrayIterator;
import borland.jbcl.model.VectorModelEvent;
import borland.jbcl.model.VectorModelListener;
import borland.jbcl.model.WritableVectorModel;
import borland.jbcl.util.EventMulticaster;

public class BasicVectorContainer
implements WritableVectorModel {
    private Array array;
    private boolean variableSize = true;
    private EventMulticaster modelListeners = new EventMulticaster();
    private boolean events = true;

    public BasicVectorContainer() {
        this.array = new Array();
    }

    public BasicVectorContainer(int n) {
        this.array = new Array(n);
    }

    public BasicVectorContainer(int n, Object object) {
        this.array = new Array(n, object);
    }

    public BasicVectorContainer(Object[] objectArray) {
        this.array = new Array(objectArray);
    }

    public BasicVectorContainer(Array array) {
        this.array = new Array(array);
    }

    public Object[] getItems() {
        Object[] objectArray = new Object[this.array.size()];
        this.array.copyTo(objectArray);
        return objectArray;
    }

    public void setItems(Object[] objectArray) {
        this.array = new Array(objectArray);
        this.processModelEvent(new VectorModelEvent(this, 2));
    }

    public Object get(int n) {
        if (n >= 0 && this.array.size() > n) {
            return this.array.at(n);
        }
        return null;
    }

    public int getCount() {
        return this.array.size();
    }

    public int find(Object object) {
        return this.array.indexOf(object);
    }

    public void setCount(int n) {
        int n2 = this.array.size();
        if (!this.variableSize || n == n2) {
            return;
        }
        if (n > n2) {
            for (int i = n2; i < n; ++i) {
                this.array.add(null);
            }
        } else {
            for (int i = n2; i > n; --i) {
                this.array.remove(i - 1);
            }
        }
    }

    public void addModelListener(VectorModelListener vectorModelListener) {
        this.modelListeners.add(vectorModelListener);
    }

    public void removeModelListener(VectorModelListener vectorModelListener) {
        this.modelListeners.remove(vectorModelListener);
    }

    public boolean canSet(int n, boolean bl) {
        return n < this.array.size();
    }

    public void set(int n, Object object) {
        this.array.put(n, object);
        this.processModelEvent(new VectorModelEvent(this, 17, n));
    }

    public void touched(int n) {
        if (n < this.array.size()) {
            this.processModelEvent(new VectorModelEvent(this, 33, n));
        }
    }

    public boolean isVariableSize() {
        return this.variableSize;
    }

    public void setVariableSize(boolean bl) {
        this.variableSize = bl;
    }

    public void addItem(Object object) {
        if (!this.variableSize) {
            return;
        }
        this.array.add(object);
        this.processModelEvent(new VectorModelEvent(this, 18, this.array.size()));
    }

    public void addItem(int n, Object object) {
        if (!this.variableSize) {
            return;
        }
        this.array.insert(n, object);
        this.processModelEvent(new VectorModelEvent(this, 18, n));
    }

    public void remove(int n) {
        if (!this.variableSize) {
            return;
        }
        this.array.remove(n);
        this.processModelEvent(new VectorModelEvent(this, 34, n));
    }

    public void removeAll() {
        if (!this.variableSize) {
            return;
        }
        if (this.array.size() > 0) {
            this.array.clear();
            this.processModelEvent(new VectorModelEvent(this, 2));
        }
    }

    public void enableModelEvents(boolean bl) {
        if (this.events != bl) {
            this.events = bl;
            if (bl) {
                this.processModelEvent(new VectorModelEvent(this, 2));
            }
        }
    }

    protected void processModelEvent(VectorModelEvent vectorModelEvent) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch(vectorModelEvent);
        }
    }

    public ArrayIterator begin() {
        return this.array.begin();
    }

    public ArrayIterator end() {
        return this.array.end();
    }

    public Array getArray() {
        return this.array;
    }
}

