/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import COM.objectspace.jgl.Pair;
import borland.jbcl.control.Res;
import borland.jbcl.model.BasicSingletonContainer;
import borland.jbcl.model.BasicViewManager;
import borland.jbcl.model.ItemPainter;
import borland.jbcl.util.BlackBox;
import borland.jbcl.util.ImageLoader;
import borland.jbcl.view.ButtonView;
import borland.jbcl.view.CompositeItemPainter;
import borland.jbcl.view.FocusableItemPainter;
import borland.jbcl.view.ImageItemPainter;
import borland.jbcl.view.TextItemPainter;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URL;

public class ButtonControl
extends ButtonView
implements BlackBox {
    private int orientation;
    private boolean imageFirst = true;
    private Image image;
    private URL url;
    private String imageName;
    private String label;

    public ButtonControl() {
        this.setModel(new BasicSingletonContainer());
        this.setupPainters();
    }

    public ButtonControl(String string) {
        this();
        this.setLabel(string);
    }

    public ButtonControl(Image image) {
        this();
        this.setImage(image);
    }

    public ButtonControl(String string, Image image) {
        this();
        this.setLabel(string);
        this.setImage(image);
    }

    public void setOrientation(int n) {
        this.orientation = n;
        this.setupPainters();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setImageFirst(boolean bl) {
        this.imageFirst = bl;
        this.setupPainters();
    }

    public boolean isImageFirst() {
        return this.imageFirst;
    }

    public void setLabel(String string) {
        this.label = string;
        this.setupPainters();
        this.invalidate();
        this.repaint(50L);
    }

    public String getLabel() {
        return this.label;
    }

    public void setImage(Image image) {
        this.setImage(image, "");
    }

    public Image getImage() {
        return this.image;
    }

    public void setImageURL(URL uRL) {
        this.url = uRL;
        this.setImage(ImageLoader.load(uRL, (Component)this), uRL.toString());
    }

    public URL getImageURL() {
        return this.url;
    }

    public void setImageName(String string) {
        Image image = ImageLoader.loadFromResource(string, this);
        if (image == null) {
            try {
                image = ImageLoader.load(new URL(string), (Component)this);
            }
            catch (MalformedURLException malformedURLException) {
                image = ImageLoader.load(string, (Component)this);
            }
        }
        this.setImage(image, string);
    }

    public String getImageName() {
        return this.imageName;
    }

    protected void setImage(Image image, String string) {
        if (this.isReadOnly()) {
            throw new IllegalStateException(Res.getString(70));
        }
        if (image != null) {
            this.prepareImage(image, this);
        }
        this.image = image;
        this.imageName = string;
        this.getWriteModel().set(this.image);
        this.setupPainters();
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 3) != 0) {
            this.invalidate();
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    private void setupPainters() {
        ImageItemPainter imageItemPainter = this.image != null ? new ImageItemPainter(this, this.getAlignment()) : null;
        FocusableItemPainter focusableItemPainter = new FocusableItemPainter(new TextItemPainter(this.getAlignment(), new Insets(1, 1, 1, 1)), false);
        ItemPainter itemPainter = null;
        Object object = null;
        if (this.image == null) {
            itemPainter = focusableItemPainter;
            object = this.label;
        } else if (this.image != null && this.label == null) {
            itemPainter = new FocusableItemPainter(imageItemPainter, false);
            object = this.image;
        } else if (this.image != null && this.label != null) {
            ItemPainter itemPainter2;
            ItemPainter itemPainter3;
            if (this.imageFirst) {
                itemPainter3 = imageItemPainter;
                itemPainter2 = focusableItemPainter;
                object = new Pair(this.image, this.label);
            } else {
                itemPainter3 = focusableItemPainter;
                itemPainter2 = imageItemPainter;
                object = new Pair(this.label, this.image);
            }
            itemPainter = new CompositeItemPainter(itemPainter3, itemPainter2, this.orientation, this.getAlignment());
        }
        this.setViewManager(new BasicViewManager(itemPainter, null));
        if (!this.isReadOnly()) {
            this.getWriteModel().set(object);
        }
    }
}

