/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.trident;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.pushingpixels.trident.TimelineEngine;
import org.pushingpixels.trident.UIToolkitHandler;
import org.pushingpixels.trident.interpolator.PropertyInterpolator;
import org.pushingpixels.trident.interpolator.PropertyInterpolatorSource;

public class TridentConfig {
    private static TridentConfig config;
    private Set<UIToolkitHandler> uiToolkitHandlers;
    private Set<PropertyInterpolator> propertyInterpolators;
    private PulseSource pulseSource = new DefaultPulseSource();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TridentConfig() {
        this.uiToolkitHandlers = new HashSet<UIToolkitHandler>();
        this.propertyInterpolators = new HashSet<PropertyInterpolator>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/trident-plugin.properties");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                BufferedReader bufferedReader = null;
                try {
                    String string;
                    bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                    while ((string = bufferedReader.readLine()) != null) {
                        Object object;
                        Class<?> clazz;
                        String[] stringArray = string.split("=");
                        if (stringArray.length != 2) continue;
                        String string2 = stringArray[0];
                        String string3 = stringArray[1];
                        if ("UIToolkitHandler".compareTo(string2) == 0) {
                            try {
                                clazz = classLoader.loadClass(string3);
                                if (clazz == null) continue;
                                if (UIToolkitHandler.class.isAssignableFrom(clazz)) {
                                    object = (UIToolkitHandler)clazz.newInstance();
                                    object.isHandlerFor(new Object());
                                    this.uiToolkitHandlers.add((UIToolkitHandler)object);
                                }
                            }
                            catch (NoClassDefFoundError noClassDefFoundError) {
                                // empty catch block
                            }
                        }
                        if ("PropertyInterpolatorSource".compareTo(string2) != 0) continue;
                        try {
                            clazz = classLoader.loadClass(string3);
                            if (clazz == null || !PropertyInterpolatorSource.class.isAssignableFrom(clazz)) continue;
                            object = (PropertyInterpolatorSource)clazz.newInstance();
                            Set<PropertyInterpolator> set = object.getPropertyInterpolators();
                            for (PropertyInterpolator propertyInterpolator : set) {
                                try {
                                    Class clazz2 = propertyInterpolator.getBasePropertyClass();
                                    clazz2.getClass();
                                    this.propertyInterpolators.add(propertyInterpolator);
                                }
                                catch (NoClassDefFoundError noClassDefFoundError) {}
                            }
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                        }
                    }
                }
                finally {
                    if (bufferedReader == null) continue;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static synchronized TridentConfig getInstance() {
        if (config == null) {
            config = new TridentConfig();
        }
        return config;
    }

    public synchronized Collection<UIToolkitHandler> getUIToolkitHandlers() {
        return Collections.unmodifiableSet(this.uiToolkitHandlers);
    }

    public synchronized Collection<PropertyInterpolator> getPropertyInterpolators() {
        return Collections.unmodifiableSet(this.propertyInterpolators);
    }

    public synchronized PropertyInterpolator getPropertyInterpolator(Object ... objectArray) {
        for (PropertyInterpolator propertyInterpolator : this.propertyInterpolators) {
            try {
                Class clazz = propertyInterpolator.getBasePropertyClass();
                boolean bl = true;
                for (Object object : objectArray) {
                    if (clazz.isAssignableFrom(object.getClass())) continue;
                    bl = false;
                }
                if (!bl) continue;
                return propertyInterpolator;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
        }
        return null;
    }

    public synchronized void addPropertyInterpolator(PropertyInterpolator propertyInterpolator) {
        this.propertyInterpolators.add(propertyInterpolator);
    }

    public synchronized void addPropertyInterpolatorSource(PropertyInterpolatorSource propertyInterpolatorSource) {
        this.propertyInterpolators.addAll(propertyInterpolatorSource.getPropertyInterpolators());
    }

    public synchronized void removePropertyInterpolator(PropertyInterpolator propertyInterpolator) {
        this.propertyInterpolators.remove(propertyInterpolator);
    }

    public synchronized void addUIToolkitHandler(UIToolkitHandler uIToolkitHandler) {
        this.uiToolkitHandlers.add(uIToolkitHandler);
    }

    public synchronized void removeUIToolkitHandler(UIToolkitHandler uIToolkitHandler) {
        this.uiToolkitHandlers.remove(uIToolkitHandler);
    }

    public synchronized void setPulseSource(PulseSource pulseSource) {
        TimelineEngine.TridentAnimationThread tridentAnimationThread = TimelineEngine.getInstance().animatorThread;
        if (tridentAnimationThread != null && tridentAnimationThread.isAlive()) {
            throw new IllegalStateException("Cannot replace the pulse source thread once it's running");
        }
        this.pulseSource = pulseSource;
    }

    public synchronized PulseSource getPulseSource() {
        return this.pulseSource;
    }

    private class DefaultPulseSource
    extends FixedRatePulseSource {
        DefaultPulseSource() {
            super(40);
        }
    }

    public static class FixedRatePulseSource
    implements PulseSource {
        private int msDelay;

        public FixedRatePulseSource(int n) {
            this.msDelay = n;
        }

        @Override
        public void waitUntilNextPulse() {
            try {
                Thread.sleep(this.msDelay);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public static interface PulseSource {
        public void waitUntilNextPulse();
    }
}

