/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tree.version;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.makagiga.Vars;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.UI;
import org.makagiga.fs.MetaInfo;
import org.makagiga.search.Index;
import org.makagiga.tree.version.VersionException;
import org.makagiga.tree.version.VersionInfo;

public final class VersionControl {
    public static final int PREVIOUS = 0;

    public static synchronized void copy(MetaInfo metaInfo, String string, String string2) throws VersionException {
        List<VersionInfo> list = VersionControl.getAllVersions(metaInfo);
        for (VersionInfo versionInfo : list) {
            try {
                FS.copyFile(versionInfo.getPath(), FS.makePath(string, string2 + "." + versionInfo.getNumber() + ".version"));
            }
            catch (IOException iOException) {
                throw new VersionException(iOException);
            }
        }
    }

    public static synchronized VersionInfo create(MetaInfo metaInfo, String string) throws VersionException {
        return VersionControl.create(metaInfo, string, VersionControl.getLatestNumber(metaInfo) + 1);
    }

    public static synchronized VersionInfo create(MetaInfo metaInfo, String string, int n) throws VersionException {
        if (!VersionControl.isEnabled(metaInfo)) {
            return null;
        }
        VersionInfo versionInfo = new VersionInfo(metaInfo, string, n);
        if (n != 0 && FS.exists(versionInfo.getPath())) {
            throw new VersionException(UI._("File with this version number already exists"));
        }
        File file = metaInfo.getFile();
        if (n != 0 && file.length() == 0L) {
            throw new VersionException(UI._("File is empty"));
        }
        try {
            FS.deleteFile(versionInfo.getPath());
            FS.copyFile(file.getPath(), versionInfo.getPath());
        }
        catch (IOException iOException) {
            throw new VersionException(iOException);
        }
        Config config = metaInfo.getConfig();
        config.write("Version.date." + n, versionInfo.getDate());
        config.write("Version.name." + n, string);
        config.sync();
        return versionInfo;
    }

    public static void deleteAllVersions(MetaInfo metaInfo, boolean bl) throws VersionException {
        VersionControl.deleteAllVersions(metaInfo, bl, false);
    }

    public static synchronized void deleteAllVersions(MetaInfo metaInfo, boolean bl, boolean bl2) throws VersionException {
        List<VersionInfo> list = VersionControl.getAllVersions(metaInfo);
        for (VersionInfo versionInfo : list) {
            VersionControl.delete(versionInfo, bl, bl2);
        }
    }

    public static synchronized List<VersionInfo> getAllVersions(MetaInfo metaInfo) throws VersionException {
        String string;
        File file = new File(metaInfo.getParentFolder().getTargetPath());
        File[] fileArray = FS.listFiles(file, new FS.FileNameRegExpFilter(string = Pattern.quote(metaInfo.getFile().getName()) + "\\.\\d+\\.version"));
        if (fileArray.length == 0) {
            return Collections.emptyList();
        }
        MArrayList<VersionInfo> mArrayList = new MArrayList<VersionInfo>(fileArray.length);
        for (File file2 : fileArray) {
            mArrayList.add(new VersionInfo(metaInfo, file2.getPath()));
        }
        mArrayList.sort();
        return mArrayList;
    }

    public static synchronized boolean isEnabled(MetaInfo metaInfo) {
        if (!((Boolean)Vars.versionEnabled.get()).booleanValue()) {
            return false;
        }
        Config config = metaInfo.getConfig();
        return config.read("Version.enabled", true) && !metaInfo.isEncrypted();
    }

    public static synchronized void setEnabled(MetaInfo metaInfo, boolean bl) {
        metaInfo.getConfig().write("Version.enabled", bl);
    }

    public static synchronized void rename(MetaInfo metaInfo, String string) throws VersionException {
        List<VersionInfo> list = VersionControl.getAllVersions(metaInfo);
        for (VersionInfo versionInfo : list) {
            if (FS.rename(versionInfo.getPath(), string + "." + versionInfo.getNumber() + ".version")) continue;
            throw new VersionException();
        }
    }

    public static synchronized void revert(MetaInfo metaInfo, VersionInfo versionInfo) throws VersionException {
        try {
            FS.copyFile(versionInfo.getPath(), metaInfo.getTargetPath());
            Index.getInstance().itemChanged(metaInfo);
            metaInfo.invalidatePreview(true);
        }
        catch (IOException iOException) {
            throw new VersionException(iOException);
        }
    }

    protected static void delete(VersionInfo versionInfo, boolean bl) throws VersionException {
        VersionControl.delete(versionInfo, bl, false);
    }

    private VersionControl() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized void delete(VersionInfo versionInfo, boolean bl, boolean bl2) throws VersionException {
        if (bl) {
            Config config = ((MetaInfo)versionInfo.getValue()).getConfig();
            config.removeDate("Version.date." + versionInfo.getNumber());
            config.removeString("Version.name." + versionInfo.getNumber());
            config.sync();
        }
        if (bl2) {
            MLogger.debug("version", "Secure delete: %s", versionInfo.getPath());
            try {
                FS.secureDelete(new File(versionInfo.getPath()));
                return;
            }
            catch (IOException iOException) {
                MLogger.exception(iOException);
                if (FS.deleteFile(versionInfo.getPath())) return;
                throw new VersionException(iOException);
            }
        } else {
            MLogger.debug("version", "Normal delete: %s", versionInfo.getPath());
            if (FS.deleteFile(versionInfo.getPath())) return;
            throw new VersionException();
        }
    }

    private static int getLatestNumber(MetaInfo metaInfo) throws VersionException {
        List<VersionInfo> list = VersionControl.getAllVersions(metaInfo);
        return list.isEmpty() ? 0 : list.get(list.size() - 1).getNumber();
    }
}

