/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tree;

import java.awt.Component;
import java.io.Serializable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import org.makagiga.MainWindow;
import org.makagiga.commons.Config;
import org.makagiga.commons.ContainerIterator;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.Lockable;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MGuardedObject;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MIconChooser;
import org.makagiga.commons.MLineBorder;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMenuItem;
import org.makagiga.commons.MRating;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MSmallColorChooser;
import org.makagiga.commons.MToggleButton;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MWhatsThis;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.script.ScriptYourself;
import org.makagiga.fs.Links;
import org.makagiga.fs.MetaInfo;
import org.makagiga.plugins.PluginManager;
import org.makagiga.tags.TagsEditor;
import org.makagiga.tags.TagsUtils;
import org.makagiga.tools.Bookmarks;
import org.makagiga.tools.presentation.Presentation;
import org.makagiga.tree.PropertiesPanel;
import org.makagiga.tree.TreePanel;

public final class PropertiesBar
extends MToolBar {
    private boolean syncTagsEnabled = true;
    private final IconButton iconButton;
    private final JButton propertiesButton;
    private final LockButton lockButton;
    private final MAction propertiesAction;
    private MetaInfo metaInfo;
    private final MButton links;
    private static MGuardedObject<PropertiesBar> _guardedInstance;
    private final MRating rating;
    private final MSmallColorChooser colorChooser;
    private final MToggleButton bookmarkButton;
    private static final String CONFIG_DEFAULT_VISIBLE = "org.makagiga.tree.PropertiesBar.CONFIG_DEFAULT_VISIBLE";
    private static final String CONFIG_ID = "org.makagiga.tree.PropertiesBar.CONFIG_ID";
    private static final String GAP = "org.makagiga.tree.PropertiesBar.GAP";
    private final TagsEditor tagsEditor;
    private final ToggleStarIconButton toggleStarIconButton;
    private final ToggleTodoIconButton toggleTodoIconButton;

    @Deprecated
    public static synchronized void freeInstance() {
        if (_guardedInstance != null) {
            PropertiesBar propertiesBar = _guardedInstance.get();
            _guardedInstance.clear();
            propertiesBar.setVisible(false);
            _guardedInstance = null;
        }
    }

    public static synchronized PropertiesBar getInstance() {
        if (_guardedInstance == null) {
            _guardedInstance = new MGuardedObject<PropertiesBar>(new PropertiesBar(), "org.makagiga.tree.PropertiesBar", PermissionInfo.ThreatLevel.MEDIUM, "Properties Bar");
        }
        return _guardedInstance.get();
    }

    public MButton getLinksButton() {
        return this.links;
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaInfo(MetaInfo metaInfo) {
        this.syncTags();
        this.metaInfo = metaInfo;
        this.iconButton.setSelection(metaInfo);
        this.toggleStarIconButton.updateProperties(metaInfo);
        this.toggleTodoIconButton.updateProperties(metaInfo);
        if (metaInfo != null) {
            boolean bl = metaInfo.getFS() == null;
            boolean bl2 = metaInfo.canModify() && !bl;
            this.bookmarkButton.setEnabled(!bl && Bookmarks.canBookmark(metaInfo));
            this.bookmarkButton.setSelected(metaInfo.isBookmark());
            this.rating.setValue(metaInfo.getRating());
            this.rating.setEnabled(bl2);
            this.iconButton.setEnabled(bl2);
            this.colorChooser.setColor(metaInfo.getColor());
            this.colorChooser.setEnabled(bl2);
            this.tagsEditor.setEditable(bl2);
            try {
                this.syncTagsEnabled = false;
                this.tagsEditor.setChangeEventDelay(0);
                this.tagsEditor.setTags(TagsUtils.removeDuplicates(metaInfo.getTags()));
                this.tagsEditor.getTextField().setCaretPosition(0);
                this.tagsEditor.setModified(false);
            }
            finally {
                this.syncTagsEnabled = true;
                this.tagsEditor.setChangeEventDelay(1000);
            }
            Links.updateButton(this.links, metaInfo);
            this.lockButton.setSelection(metaInfo);
            this.propertiesAction.setEnabled(!bl);
        }
    }

    public static synchronized boolean isInstance() {
        return _guardedInstance != null;
    }

    public void showOrHide(boolean bl) {
        this.setVisible(bl && !Presentation.isActive() && this.metaInfo != null && !this.metaInfo.isDummy());
    }

    public static synchronized void sync() {
        PropertiesBar propertiesBar;
        if (_guardedInstance != null && (propertiesBar = _guardedInstance.get()) != null) {
            propertiesBar.syncTags();
        }
    }

    private PropertiesBar() {
        super(MIcon.Size.MEDIUM);
        Serializable serializable;
        MWhatsThis.set(this, UI._("Properties for the current tab")).setKeyStroke(10, 8);
        this.setTextPosition(MToolBar.TextPosition.ALONGSIDE_ICONS);
        this.showLineBorder(MLineBorder.Position.TOP);
        this.toggleStarIconButton = new ToggleStarIconButton();
        this.addButton(this.toggleStarIconButton);
        this.addGap(this.toggleStarIconButton);
        this.toggleTodoIconButton = new ToggleTodoIconButton();
        this.addButton(this.toggleTodoIconButton);
        this.addGap(this.toggleTodoIconButton);
        this.bookmarkButton = new MToggleButton((Icon)MIcon.medium("ui/bookmark")){

            @Override
            protected void onClick() {
                PropertiesBar.this.metaInfo.setBookmark(this.isSelected());
                PropertiesBar.this.metaInfo.sync();
            }
        };
        this.bookmarkButton.putClientProperty(CONFIG_DEFAULT_VISIBLE, false);
        this.bookmarkButton.putClientProperty(CONFIG_ID, "bookmark");
        this.bookmarkButton.setRequestFocusEnabled(false);
        this.bookmarkButton.setToolTipText(UI._("Toggle Bookmark"));
        this.addButton(this.bookmarkButton);
        this.addGap(this.bookmarkButton);
        this.iconButton = new IconButton(false);
        this.iconButton.putClientProperty(CONFIG_ID, "icon");
        this.addButton(this.iconButton);
        this.addGap(this.iconButton);
        this.colorChooser = new MSmallColorChooser();
        this.colorChooser.putClientProperty(CONFIG_ID, "color");
        this.colorChooser.getClearButton().setVisible(true);
        this.colorChooser.getTitleLabel().setVisible(false);
        this.colorChooser.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                MSmallColorChooser mSmallColorChooser = (MSmallColorChooser)changeEvent.getSource();
                PropertiesPanel.setProperty(1, mSmallColorChooser.getColor(), PropertiesBar.this.metaInfo);
            }
        });
        this.add(this.colorChooser);
        this.addGap(this.colorChooser);
        this.tagsEditor = new TagsEditor(){

            @Override
            public void onChange(DocumentEvent documentEvent) {
                PropertiesBar.this.syncTags();
            }
        };
        this.tagsEditor.putClientProperty(CONFIG_ID, "tags");
        this.tagsEditor.getTip().setVisible(false);
        this.tagsEditor.limitHeight();
        this.add(this.tagsEditor);
        this.addGap(this.tagsEditor);
        ScriptYourself.install(this, "properties-bar");
        this.rating = new MRating(0.0f);
        this.rating.putClientProperty(CONFIG_DEFAULT_VISIBLE, false);
        this.rating.putClientProperty(CONFIG_ID, "rating");
        this.rating.setClearButtonVisible(true);
        this.rating.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PropertiesPanel.setProperty(4, Float.valueOf(PropertiesBar.this.rating.getValue()), PropertiesBar.this.metaInfo);
            }
        });
        this.add(this.rating);
        this.addGap(this.rating);
        this.links = Links.createLinksButton();
        this.links.putClientProperty(CONFIG_ID, "links");
        this.addButton(this.links);
        this.addGap(this.links);
        this.lockButton = new LockButton(true){

            @Override
            protected void onClick() {
                super.onClick();
                this.apply(PropertiesBar.this.metaInfo);
                PropertiesBar.this.metaInfo.sync();
                MainWindow.getInstance().updateComponents(PropertiesBar.this.metaInfo);
            }
        };
        this.lockButton.putClientProperty(CONFIG_DEFAULT_VISIBLE, false);
        this.lockButton.putClientProperty(CONFIG_ID, "lock");
        this.lockButton.setRequestFocusEnabled(true);
        this.lockButton.setSelection(new MetaInfo[0]);
        this.addButton(this.lockButton);
        this.propertiesAction = new MAction(MActionInfo.PROPERTIES){

            @Override
            public void onAction() {
                MainWindow.getInstance().showProperties(PropertiesBar.this.metaInfo);
            }
        };
        this.propertiesButton = this.add(this.propertiesAction);
        this.propertiesButton.putClientProperty(CONFIG_ID, "properties");
        this.addStretch();
        if (((Boolean)Kiosk.actionSettings.get()).booleanValue()) {
            serializable = new MSmallButton(MIcon.small("ui/plus"), MActionInfo.SETTINGS.getText()){

                @Override
                protected MMenu onPopupMenu() {
                    MMenu mMenu = new MMenu();
                    mMenu.addTitle(UI._("Visible Items"));
                    mMenu.addCheckBox(new SettingsAction(MActionInfo.ADD_STAR.getText(), MActionInfo.ADD_STAR.getSmallIcon(), PropertiesBar.this.toggleStarIconButton));
                    mMenu.addCheckBox(new SettingsAction(UI._("Todo"), (Icon)MIcon.small("labels/todo"), PropertiesBar.this.toggleTodoIconButton));
                    mMenu.addCheckBox(new SettingsAction(UI._("Bookmark"), (Icon)MIcon.small("ui/bookmark"), PropertiesBar.this.bookmarkButton));
                    mMenu.addCheckBox(new SettingsAction(UI._("Icon"), null, PropertiesBar.this.iconButton));
                    mMenu.addCheckBox(new SettingsAction(UI._("Color"), null, PropertiesBar.this.colorChooser));
                    mMenu.addCheckBox(new SettingsAction(UI._("Tags"), null, PropertiesBar.this.tagsEditor));
                    mMenu.addCheckBox(new SettingsAction(UI._("Rating"), (Icon)MIcon.small("ui/star"), PropertiesBar.this.rating));
                    mMenu.addCheckBox(new SettingsAction(UI._("Links"), null, PropertiesBar.this.links));
                    mMenu.addCheckBox(new SettingsAction(UI._("Lock"), MActionInfo.LOCK.getSmallIcon(), PropertiesBar.this.lockButton));
                    mMenu.addCheckBox(new SettingsAction(MActionInfo.PROPERTIES.getText(), MActionInfo.PROPERTIES.getSmallIcon(), PropertiesBar.this.propertiesButton));
                    return mMenu;
                }
            };
            ((MButton)serializable).setPopupMenuArrowPainted(false);
            ((MButton)serializable).setPopupMenuEnabled(true);
            this.add((Component)serializable);
        }
        serializable = Config.getDefault();
        for (JComponent jComponent : ContainerIterator.create(this, JComponent.class)) {
            Object object;
            Boolean bl = (Boolean)jComponent.getClientProperty(CONFIG_DEFAULT_VISIBLE);
            if (bl == null) {
                bl = Boolean.TRUE;
            }
            if (!((object = jComponent.getClientProperty(CONFIG_ID)) instanceof String) || ((Config)serializable).read("PropertiesBar." + object + ".visible", bl)) continue;
            this.setVisible(jComponent, false);
        }
    }

    private void addGap(JComponent jComponent) {
        jComponent.putClientProperty(GAP, this.addGap());
    }

    private static MMenu createIconMenu(IconButton iconButton, MetaInfo[] metaInfoArray) {
        MMenu mMenu = new MMenu();
        PluginManager.updateMenu(mMenu, "LABEL_MENU", true);
        List<TreePanel.LabelIcon> list = TreePanel.getInstance().getStandardLabelIcons();
        for (TreePanel.LabelIcon stringArray2 : list) {
            mMenu.add(new IconAction(stringArray2.getText(), (String)stringArray2.getValue(), iconButton, metaInfoArray));
        }
        String[] stringArray3 = new String[]{"red", "green", "blue", "yellow", "black"};
        mMenu.add(PropertiesBar.createIconSubMenu(iconButton, metaInfoArray, UI._("Color"), "labels/flag-", stringArray3));
        String[] stringArray = new String[]{"favorites", "important", "remote", "downloads", "development", "image", "sound", "txt", "locked", "print", "red", "green", "cyan", "violet", "yellow", "grey"};
        mMenu.add(PropertiesBar.createIconSubMenu(iconButton, metaInfoArray, UI._("Folder"), "labels/folder-", stringArray));
        mMenu.addSeparator();
        mMenu.add(new CustomIconAction(iconButton, metaInfoArray));
        mMenu.addSeparator();
        mMenu.add(new DefaultIconAction(iconButton, metaInfoArray));
        return mMenu;
    }

    private static MMenu createIconSubMenu(IconButton iconButton, MetaInfo[] metaInfoArray, String string, String string2, String[] stringArray) {
        MMenu mMenu = new MMenu(string);
        for (String string3 : stringArray) {
            MMenuItem mMenuItem = mMenu.add(new IconAction(null, string2 + string3, iconButton, metaInfoArray));
            mMenuItem.setToolTipText(string3);
        }
        return mMenu;
    }

    private void setVisible(JComponent jComponent, boolean bl) {
        Component component = (Component)jComponent.getClientProperty(GAP);
        if (component != null) {
            component.setVisible(bl);
        }
        jComponent.setVisible(bl);
    }

    private void syncTags() {
        if (this.syncTagsEnabled && this.metaInfo != null && this.tagsEditor.isModified()) {
            this.tagsEditor.updateAutoCompletion();
            this.tagsEditor.setModified(false);
            PropertiesPanel.setProperty(8, this.tagsEditor.getTags(), this.metaInfo);
        }
    }

    private static final class ToggleTodoIconButton
    extends ToggleIconButton {
        @Override
        protected void onClick() {
            super.onClick();
            PropertiesBar.getInstance().toggleStarIconButton.updateSelected();
        }

        private ToggleTodoIconButton() {
            super(UI._("Todo"), "labels/todo", "todo");
        }
    }

    private static final class ToggleStarIconButton
    extends ToggleIconButton {
        @Override
        protected void onClick() {
            super.onClick();
            PropertiesBar.getInstance().toggleTodoIconButton.updateSelected();
        }

        private ToggleStarIconButton() {
            super(MActionInfo.ADD_STAR.getText(), MActionInfo.ADD_STAR.getIconName(), "star");
        }
    }

    private static abstract class ToggleIconButton
    extends MToggleButton {
        protected MetaInfo metaInfo;
        protected final String iconName;

        protected ToggleIconButton(String string, String string2, String string3) {
            this.iconName = string2;
            this.setIcon(MIcon.medium(string2));
            this.setRequestFocusEnabled(false);
            this.setToolTipText(UI._("Toggle Bookmark and Icon: {0}", string));
            this.putClientProperty(PropertiesBar.CONFIG_DEFAULT_VISIBLE, false);
            this.putClientProperty(PropertiesBar.CONFIG_ID, string3);
            this.updateProperties(null);
        }

        @Override
        protected void onClick() {
            PropertiesPanel.setProperty(2, this.isSelected() ? this.iconName : null, this.metaInfo);
            this.updateProperties(this.metaInfo);
        }

        protected void updateProperties(MetaInfo metaInfo) {
            this.metaInfo = metaInfo;
            this.setEnabled(metaInfo != null);
            this.updateSelected();
        }

        protected void updateSelected() {
            if (this.metaInfo != null) {
                this.setSelected(this.metaInfo.isCustomIcon() && this.iconName.equals(this.metaInfo.getIconName()));
            } else {
                this.setSelected(false);
            }
        }
    }

    private static final class SettingsAction
    extends MDataAction.Weak<JComponent> {
        private final String key;

        @Override
        public void onAction() {
            boolean bl = this.isSelected();
            PropertiesBar.getInstance().setVisible((JComponent)this.get(), bl);
            Config config = Config.getDefault();
            config.write(this.key, bl);
            config.sync();
        }

        private SettingsAction(String string, Icon icon, JComponent jComponent) {
            super(jComponent, string);
            this.key = "PropertiesBar." + jComponent.getClientProperty(PropertiesBar.CONFIG_ID) + ".visible";
            Config config = Config.getDefault();
            this.setHighlightedComponent(jComponent);
            this.setSelected(config.read(this.key, jComponent.isVisible()));
            this.setSmallIcon(icon);
        }
    }

    private static class IconAction
    extends MAction {
        protected IconButton button;
        protected MetaInfo[] selection;
        protected String path;

        @Override
        public void onAction() {
            PropertiesPanel.setProperty(2, this.path, this.selection);
            if (this.button != null) {
                this.button.updateIcon();
            }
        }

        private IconAction(String string, String string2, IconButton iconButton, MetaInfo[] metaInfoArray) {
            super(string, string2);
            this.button = iconButton;
            this.path = string2;
            this.selection = TK.copyOf(metaInfoArray);
        }
    }

    private static final class DefaultIconAction
    extends IconAction {
        private DefaultIconAction(IconButton iconButton, MetaInfo[] metaInfoArray) {
            super(UI._("Default Icon"), null, iconButton, metaInfoArray);
            this.setHTMLHelp(UI._("Sets the default icon."));
            this.setIconName("ui/clearright");
        }
    }

    private static final class CustomIconAction
    extends IconAction {
        @Override
        public void onAction() {
            MIconChooser.IconItem iconItem = MIconChooser.fromList(this.getSourceWindow(), MIconChooser.getStockIcons(), 1);
            if (iconItem != null) {
                PropertiesPanel.setProperty(2, iconItem.getValue(), this.selection);
                if (this.button != null) {
                    this.button.updateIcon();
                }
            }
        }

        private CustomIconAction(IconButton iconButton, MetaInfo[] metaInfoArray) {
            super(UI._("More..."), null, iconButton, metaInfoArray);
        }
    }

    public static class LockButton
    extends MToggleButton
    implements Lockable {
        private boolean canUnlock;
        private final boolean propertiesBarMode;
        private boolean userLocked;

        public LockButton(boolean bl) {
            this.propertiesBarMode = bl;
            UI.setHTMLHelp(this, UI._("Click to lock/unlock the item(s).<br>Locked item cannot be modified."));
            if (bl || ((Boolean)UI.buttonIcons.get()).booleanValue()) {
                this.setIcon(bl ? MActionInfo.LOCK.getMediumIcon() : MActionInfo.LOCK.getIcon());
            }
        }

        public void apply(MetaInfo ... metaInfoArray) {
            MetaInfo metaInfo = PropertiesBar.isInstance() ? PropertiesBar.getInstance().getMetaInfo() : null;
            for (MetaInfo metaInfo2 : metaInfoArray) {
                if (this.canUnlock) {
                    metaInfo2.setLocked(this.userLocked);
                }
                if (metaInfo2 != metaInfo) continue;
                PropertiesBar.getInstance().setMetaInfo(metaInfo2);
            }
        }

        @Override
        public boolean isLocked() {
            return this.userLocked || !this.canUnlock;
        }

        @Override
        public void setLocked(boolean bl) {
            String string;
            this.setSelected(bl);
            String string2 = string = bl ? MActionInfo.UNLOCK.getText() : MActionInfo.LOCK.getText();
            if (this.propertiesBarMode) {
                this.setToolTipText(string);
            } else {
                this.setText(string);
            }
        }

        public void setSelection(MetaInfo ... metaInfoArray) {
            if (metaInfoArray == null) {
                this.canUnlock = false;
                this.setLocked(false);
                this.setEnabled(false);
                return;
            }
            this.canUnlock = true;
            boolean bl = false;
            for (MetaInfo metaInfo : metaInfoArray) {
                if (!metaInfo.isWriteable()) {
                    this.canUnlock = false;
                }
                if (!metaInfo.isVirtualFile()) continue;
                bl = true;
            }
            this.setEnabled(this.canUnlock && !bl);
            if (metaInfoArray.length > 0) {
                this.userLocked = metaInfoArray[0].isLocked();
            }
            this.setLocked(this.userLocked);
        }

        @Override
        protected void onClick() {
            if (this.canUnlock) {
                this.userLocked = !this.userLocked;
            }
        }
    }

    public static final class IconButton
    extends MButton {
        private final boolean showIcon;
        private MetaInfo[] selection;

        public IconButton(boolean bl) {
            this.showIcon = bl;
            this.setPopupMenuEnabled(true);
            if (bl) {
                this.setToolTipText(UI._("Icon"));
            } else {
                this.setText(UI._("Icon"));
            }
        }

        public void setSelection(MetaInfo ... metaInfoArray) {
            this.selection = TK.copyOf(metaInfoArray);
            this.updateIcon();
        }

        public void updateIcon() {
            if (this.showIcon) {
                if (TK.isEmpty(this.selection) || this.selection.length > 1) {
                    this.setIconName("ui/misc");
                } else {
                    MIcon mIcon = this.selection[0].getIcon();
                    if (mIcon != null) {
                        this.setIcon(mIcon);
                    } else {
                        this.setIconName("ui/misc");
                    }
                }
            }
        }

        @Override
        protected MMenu onPopupMenu() {
            return PropertiesBar.createIconMenu(this, this.selection);
        }
    }
}

