/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools.presentation;

import org.makagiga.commons.Config;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MProgressIcon;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.MV;
import org.makagiga.commons.MainView;
import org.makagiga.commons.UI;
import org.makagiga.editors.NavigationUtils;
import org.makagiga.form.Default;
import org.makagiga.form.Field;
import org.makagiga.form.Form;
import org.makagiga.form.FormPanel;
import org.makagiga.form.IntegerRange;
import org.makagiga.fs.MetaInfo;
import org.makagiga.tools.presentation.ControlPanel;
import org.makagiga.tools.presentation.Presentation;
import org.makagiga.tree.Tree;

public final class Slideshow {
    private boolean active;
    private boolean loop;
    private static final int DEFAULT_TIME = 10;
    private static final int MIN_TIME = 3;
    private final MAction settingsAction;
    private final MAction startStopAction;
    private final MTimer timer;
    private final Presentation presentation;
    MProgressIcon stopIcon;

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        if (bl == this.active) {
            return;
        }
        this.active = bl;
        MLogger.info("slideshow", this.active ? "Start" : "Pause");
        this.updateActions();
        if (this.presentation != null) {
            this.presentation.updateBounds();
        }
        if (this.active) {
            this.maybeOpenFirstFile();
            this.timer.restart();
        } else {
            this.timer.stop();
        }
    }

    private boolean goToNext() {
        NavigationUtils.NextAction nextAction = NavigationUtils.getNextAction();
        if (!nextAction.isEnabled()) {
            if (this.loop) {
                this.maybeOpenFirstFile();
                return true;
            }
            this.setActive(false);
            if (this.presentation != null) {
                this.presentation.showControlPanels();
            }
            return false;
        }
        nextAction.fire();
        if (this.presentation != null) {
            this.presentation.updateProgressLabel(0);
        }
        return true;
    }

    private void maybeOpenFirstFile() {
        Tree tree;
        MetaInfo metaInfo;
        NavigationUtils.NextAction nextAction = NavigationUtils.getNextAction();
        if (!nextAction.isEnabled() && !(metaInfo = (tree = Tree.getInstance()).getCurrentFolder(true)).isEmpty(MV.VIEW)) {
            MetaInfo metaInfo2 = (MetaInfo)metaInfo.getChildAt(0, MV.VIEW);
            if (!metaInfo2.isAnyFile()) {
                metaInfo2 = NavigationUtils.getNextFile(metaInfo2);
            }
            tree.open(metaInfo2);
            if (this.presentation != null) {
                this.presentation.updateProgressLabel(0);
            }
        }
    }

    private void settings() {
        SettingsForm settingsForm = new SettingsForm(this);
        FormPanel<SettingsForm> formPanel = new FormPanel<SettingsForm>(settingsForm);
        formPanel.setLabel("delay", UI._("Delay (in seconds):"));
        formPanel.setLabel("loop", UI._("Loop"));
        MDialog mDialog = formPanel.createSettingsDialog(MainView.getWindow());
        if (mDialog.exec()) {
            this.loop = settingsForm.loop;
            this.timer.setDelay(MTimer.Format.SECONDS, settingsForm.delay);
            Config config = Config.getDefault();
            config.write("Slideshow.delay", settingsForm.delay);
            config.write("Slideshow.loop", settingsForm.loop);
            config.sync();
        }
    }

    private void updateActions() {
        this.settingsAction.setEnabled(!this.active);
        if (this.active) {
            this.startStopAction.setIconName("player/pause");
            this.startStopAction.setName(UI._("Pause Slideshow"));
            this.startStopAction.setLargeIcon(this.stopIcon);
        } else {
            this.startStopAction.setIconName("player/start");
            this.startStopAction.setName(UI._("Start Slideshow"));
        }
    }

    Slideshow(Presentation presentation) {
        this.presentation = presentation;
        this.settingsAction = new MAction(MActionInfo.SETTINGS){

            @Override
            public void onAction() {
                Slideshow.this.settings();
            }
        };
        this.startStopAction = new MAction(){

            @Override
            public void onAction() {
                Slideshow.this.setActive(!Slideshow.this.isActive());
            }
        };
        this.updateActions();
        Config config = Config.getDefault();
        int n = config.readInt("Slideshow.delay", 10, 3);
        this.loop = config.read("Slideshow.loop", false);
        this.timer = new MTimer(MTimer.Format.SECONDS, n){

            @Override
            protected boolean onTimeout() {
                boolean bl = Slideshow.this.goToNext();
                if (bl) {
                    this.restart();
                }
                return bl;
            }
        };
    }

    void install(ControlPanel controlPanel) {
        this.stopIcon = new MProgressIcon(controlPanel.addAction(this.startStopAction, 1), MIcon.stock("player/pause"));
        this.stopIcon.setAlpha(0.7f);
        this.stopIcon.setBarForeground(MApplication.getLightBrandColor());
        this.stopIcon.setStringPainted(false);
        controlPanel.addAction(this.settingsAction, 1);
        controlPanel.addSeparator();
    }

    @Form(order={"delay", "loop"})
    private static final class SettingsForm {
        @Default
        @Field
        @IntegerRange(minimum=3)
        private int delay;
        @Field
        private boolean loop;

        private SettingsForm(Slideshow slideshow) {
            this.delay = slideshow.timer.getDelay() / 1000;
            this.loop = slideshow.loop;
        }
    }
}

