/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tools;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.makagiga.MainWindow;
import org.makagiga.Tabs;
import org.makagiga.Vars;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MainView;
import org.makagiga.commons.Mnemonic;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.desktop.Desktop;
import org.makagiga.desktop.Pager;
import org.makagiga.desktop.WidgetInternalFrame;
import org.makagiga.editors.Editor;
import org.makagiga.fs.MetaInfoAction;

public final class DocumentList
extends MSmallButton {
    public DocumentList() {
        this.setFocusable(false);
        this.setPopupMenuEnabled(true);
        this.setHideActionText(true);
        this.setAction(new Action());
        MainView.bind(this.getAction());
    }

    @Override
    protected MMenu onPopupMenu() {
        MMenu mMenu = new MMenu();
        mMenu.setSplitMenu(true);
        this.buildTabsMenu(mMenu);
        this.buildWidgetsMenu(mMenu);
        return mMenu;
    }

    private void buildTabsMenu(MMenu mMenu) {
        Tabs tabs = Tabs.getInstance();
        mMenu.addTitle(UI._("Tabs"));
        int n = 0;
        int[] nArray = Mnemonic.getTabKeys();
        for (Editor editor : tabs) {
            MetaInfoAction metaInfoAction = new MetaInfoAction(editor.getMetaInfo(), false);
            if (n < nArray.length) {
                metaInfoAction.setAcceleratorKey(nArray[n], 8);
            }
            mMenu.addRadioButton(metaInfoAction, editor == tabs.getSelectedTab());
            ++n;
        }
        if (!tabs.isEmpty()) {
            mMenu.addSeparator();
        }
        if (((Boolean)Vars.tabsRecentlyClosedTabs.get()).booleanValue()) {
            mMenu.add(tabs.createRecentlyClosedTabsMenu());
        }
    }

    private void buildWidgetsMenu(MMenu mMenu) {
        List list = Desktop.getInstance().getFrames();
        if (list.isEmpty()) {
            return;
        }
        Collections.sort(list, new Comparator<WidgetInternalFrame>(){

            @Override
            public int compare(WidgetInternalFrame widgetInternalFrame, WidgetInternalFrame widgetInternalFrame2) {
                int n = TK.compare(widgetInternalFrame.getWidget().getDesktopNumber(), widgetInternalFrame2.getWidget().getDesktopNumber());
                if (n == 0) {
                    n = TK.compareIgnoreCase(widgetInternalFrame.getTitle(), widgetInternalFrame2.getTitle(), "");
                }
                return n;
            }
        });
        int n = -1;
        Pager pager = Pager.getInstance();
        for (WidgetInternalFrame widgetInternalFrame : list) {
            int n2 = widgetInternalFrame.getWidget().getDesktopNumber();
            if (n2 != n) {
                mMenu.addTitle(UI._("Widgets - {0}", pager.getDisplayName(n2)));
                n = n2;
            }
            mMenu.addRadioButton(new SelectWidgetAction(widgetInternalFrame), widgetInternalFrame.isSelected());
        }
    }

    private static final class SelectWidgetAction
    extends MDataAction.Weak<WidgetInternalFrame> {
        @Override
        public void onAction() {
            MainWindow.showWidget(((WidgetInternalFrame)this.get()).getWidget(), false);
        }

        private SelectWidgetAction(WidgetInternalFrame widgetInternalFrame) {
            super(widgetInternalFrame, TK.centerSqueeze(widgetInternalFrame.getTitle()), widgetInternalFrame.getFrameIcon());
        }
    }

    private final class Action
    extends MAction {
        @Override
        public void onAction() {
            DocumentList.this.doPopupMenu();
        }

        private Action() {
            super(UI._("Tab/Widget List"), 71, 3);
            this.setMouseGesture("U");
            this.setSmallIcon("ui/detailedview");
            this.setToolTipText(this.getName());
        }
    }
}

