/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.todo;

import java.awt.Component;
import java.awt.Window;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MEditorPane;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MTable;
import org.makagiga.commons.MText;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.UI;
import org.makagiga.todo.TaskTable;

public class SummaryEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JTextComponent text;
    private String value;

    public static String edit(Window window, String string) {
        return MMessage.text(window, string, UI._("Edit Summary"));
    }

    @Override
    public Object getCellEditorValue() {
        if (this.text != null) {
            return this.text.getText();
        }
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(final JTable jTable, Object object, boolean bl, int n, int n2) {
        JComponent jComponent;
        MPanel mPanel = new MPanel(){

            @Override
            public void requestFocus() {
                if (SummaryEditor.this.text == null) {
                    super.requestFocus();
                } else {
                    SummaryEditor.this.text.requestFocusInWindow();
                }
            }
        };
        String string = this.value = object == null ? "" : object.toString();
        if (this.value != null && this.value.contains("\n")) {
            this.text = MEditorPane.newPlainText(this.value, true);
        } else {
            jComponent = new MTextField(this.value);
            ((MTextField)jComponent).setAutoCompletion("newtask");
            ((MTextField)jComponent).getAutoCompletion().consumeEnter.no();
            this.text = jComponent;
        }
        if (jTable instanceof TaskTable) {
            ((TaskTable)TaskTable.class.cast(jTable)).setupCellEditor(this.text);
        }
        mPanel.addCenter(this.text);
        MText.makeDefault(this.text);
        jComponent = new MButton(){

            @Override
            public void onClick() {
                SummaryEditor.this.editValue(jTable);
            }
        };
        if (UI.isSubstance()) {
            jComponent.putClientProperty("substancelaf.buttonnominsize", true);
        }
        ((MButton)jComponent).setCursor(12);
        ((MButton)jComponent).setStyle("margin-top: 3; margin-bottom: 3; padding-top: 2; padding-bottom: 2");
        ((AbstractButton)jComponent).setText("\u2026");
        jComponent.setToolTipText(UI._("Edit Summary..."));
        mPanel.addEast(jComponent);
        return mPanel;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return MTable.canStartEdit(eventObject, false);
    }

    @Override
    public boolean stopCellEditing() {
        if (this.text instanceof MTextField) {
            ((MTextField)MTextField.class.cast(this.text)).saveAutoCompletion();
        }
        boolean bl = super.stopCellEditing();
        this.text = null;
        return bl;
    }

    private void editValue(JTable jTable) {
        this.value = SummaryEditor.edit(UI.windowFor(jTable), this.text.getText());
        if (this.value != null) {
            this.text = null;
            this.stopCellEditing();
        }
    }
}

