/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.test;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.UI;
import org.makagiga.test.AbstractTest;

public class UITest
extends AbstractTest {
    private static final Dimension offscreenSize = new Dimension(200, 200);
    private static final BufferedImage offscreenGraphics = UI.createCompatibleImage(UITest.offscreenSize.width, UITest.offscreenSize.height, true);

    protected void createDocScreenshot(JComponent jComponent, Dimension dimension, File file) {
        Class<?> clazz = jComponent.getClass();
        File file2 = new File(file, clazz.getPackage().getName().replace('.', File.separatorChar) + File.separatorChar + "doc-files" + File.separatorChar + clazz.getSimpleName() + ".png");
        MDialog mDialog = new MDialog(null, "Screenshot", 68);
        mDialog.addCenter(jComponent);
        MScrollPane mScrollPane = MScrollPane.getScrollPane(jComponent);
        JComponent jComponent2 = mScrollPane != null ? mScrollPane : jComponent;
        mDialog.pack();
        mDialog.exec(jComponent);
        try {
            this.printf("Creating component screenshot: %s\n", file2);
            file2.getParentFile().mkdirs();
            ImageIO.write((RenderedImage)UI.createCompatibleImage(jComponent2, Color.WHITE), "png", file2);
        }
        catch (IOException iOException) {
            this.fail(iOException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFakeLookAndFeelType(UI.LookAndFeelType lookAndFeelType) {
        Field field = null;
        try {
            field = UI.class.getDeclaredField("lookAndFeelType");
            field.setAccessible(true);
            field.set(null, (Object)lookAndFeelType);
            this.assertTrue(UI.getLookAndFeelType() == lookAndFeelType, "Unable to set fake look and feel type: " + (Object)((Object)lookAndFeelType));
        }
        catch (IllegalAccessException illegalAccessException) {
            this.fail(illegalAccessException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.fail(noSuchFieldException);
        }
        finally {
            if (field != null) {
                field.setAccessible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testPaint(Component component) {
        component.setSize(offscreenSize);
        this.assertTrue(component.getSize().equals(offscreenSize), "Failed to set new component size: " + offscreenSize);
        Graphics2D graphics2D = offscreenGraphics.createGraphics();
        try {
            this.clearOffscreenGraphics(graphics2D);
            component.paint(graphics2D);
        }
        finally {
            graphics2D.dispose();
        }
        graphics2D = offscreenGraphics.createGraphics();
        try {
            this.clearOffscreenGraphics(graphics2D);
            component.print(graphics2D);
        }
        finally {
            graphics2D.dispose();
        }
    }

    private void clearOffscreenGraphics(Graphics2D graphics2D) {
        graphics2D.setColor(Color.PINK);
        graphics2D.fillRect(0, 0, UITest.offscreenSize.width, UITest.offscreenSize.height);
    }
}

