/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.tags;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMenuAdapter;
import org.makagiga.commons.UI;
import org.makagiga.commons.util.CollectionMap;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.MetaInfoAction;
import org.makagiga.plugins.PluginManager;
import org.makagiga.search.Hit;
import org.makagiga.search.Query;
import org.makagiga.search.SortMethod;
import org.makagiga.tags.Tags;
import org.makagiga.tags.TagsUtils;
import org.makagiga.tree.Tree;

public final class TagsMenu
extends MMenu {
    public TagsMenu() {
        super(UI._("T&ags"));
        this.addMenuListener(new MMenuAdapter(true){

            @Override
            protected void onSelect(MMenu mMenu) {
                TagsMenu.this.updateMenu();
            }
        });
    }

    private void updateMenu() {
        this.removeAll();
        this.setSplitMenu(true);
        PluginManager.updateMenu(this, "TAGS_MENU ", true);
        CollectionMap<String, String> collectionMap = new CollectionMap<String, String>(CollectionMap.MapType.HASH_MAP, CollectionMap.CollectionType.HASH_SET);
        Tags tags = Tags.getAll();
        if (tags.isEmpty()) {
            this.addTitle(UI._("No Tags"));
        } else {
            MArrayList<Submenu> mArrayList = new MArrayList<Submenu>();
            Submenu submenu = null;
            for (String object : tags) {
                int n = object.lastIndexOf(58);
                if (n > 0 && n < object.length() - 1) {
                    String string;
                    String string2 = object.substring(0, n).trim();
                    Collection<String> collection = collectionMap.add(string2, string = object.substring(n + 1).trim());
                    if (collection.size() != 1) continue;
                    Submenu submenu2 = new Submenu(null, object, string2, collection);
                    mArrayList.add(submenu2);
                    if ("SYSTEM".equals(submenu2.key)) {
                        submenu = submenu2;
                        submenu.system = true;
                        submenu.setText(UI._("System Tags"));
                        continue;
                    }
                    this.add(submenu2);
                    continue;
                }
                this.add(new Submenu(object, object, null, null));
            }
            for (Submenu submenu3 : mArrayList) {
                if (submenu3.system) continue;
                submenu3.setText(submenu3.key + " (" + submenu3.values.size() + ")");
            }
            if (submenu != null) {
                this.addSeparator(false);
                this.add(submenu);
            }
        }
    }

    private static final class Submenu
    extends MMenu {
        private boolean system;
        private final Collection<String> values;
        private final String key;
        private final String tag;

        private Submenu(String string, String string2, String string3, Collection<String> collection) {
            super(string);
            this.tag = string2;
            this.key = string3;
            this.values = collection;
            this.addMenuListener(new MMenuAdapter(true){

                @Override
                protected void onSelect(MMenu mMenu) {
                    Submenu.this.updateMenu();
                }
            });
        }

        private void updateMenu() {
            this.removeAll();
            this.setSplitMenu(true);
            if (this.values != null) {
                Tags tags = new Tags();
                tags.addAll(this.values);
                Iterator iterator = tags.iterator();
                while (iterator.hasNext()) {
                    String string;
                    String string2 = string = (String)iterator.next();
                    if (this.system) {
                        for (TagsUtils.AutoTag autoTag : TagsUtils.AutoTag.values()) {
                            if (!string.equals(autoTag.getText())) continue;
                            string2 = autoTag.getLocalizedText();
                            break;
                        }
                    }
                    this.add(new Submenu(string2, this.key + ":" + string, null, null));
                }
                return;
            }
            Query query = new Query(SortMethod.PATH);
            query.add("tag", this.tag);
            Query.Hits hits = query.start();
            if ("".equals(this.tag) && hits.isEmpty()) {
                this.addTitle(UI._("No Items"));
            } else {
                int n = 0;
                for (Hit hit : hits) {
                    if (((MetaInfo)hit.get()).isFile()) {
                        ++n;
                    }
                    this.add(new MetaInfoAction((MetaInfo)hit.get(), true));
                }
                if (n > 1 && !"".equals(this.tag)) {
                    this.addSeparator();
                    this.add(new Tree.OpenAllInTabsAction(){

                        @Override
                        protected List<MetaInfo> getFileList() {
                            Query query = new Query(SortMethod.PATH);
                            query.add("tag", Submenu.this.tag);
                            Query.Hits hits = query.start();
                            MArrayList<MetaInfo> mArrayList = new MArrayList<MetaInfo>(hits.size());
                            for (Hit hit : hits) {
                                if (!((MetaInfo)hit.get()).isFile()) continue;
                                mArrayList.add((MetaInfo)hit.get());
                            }
                            return mArrayList;
                        }
                    });
                }
            }
        }
    }
}

