/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.pim;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;
import org.makagiga.pim.PIMUtils;
import org.makagiga.pim.QuotedPrintableCodec;

public class PIMProperty<T>
implements Iterable<Map.Entry<String, Object>>,
Serializable {
    private Map<String, Object> attr;
    private final String name;
    private T value;

    public PIMProperty(String string, T t) {
        this.name = TK.checkNullOrEmpty(string);
        this.value = t;
        this.setupAttributes();
    }

    public String getName() {
        return this.name;
    }

    public synchronized T getValue() {
        return this.value;
    }

    public synchronized void setValue(T t) {
        this.value = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAttribute(String string, T t) {
        Object object;
        PIMProperty pIMProperty = this;
        synchronized (pIMProperty) {
            if (this.attr == null) {
                return t;
            }
            object = this.attr.get(string);
        }
        if (object == null) {
            return t;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String string, Object object) {
        PIMProperty pIMProperty = this;
        synchronized (pIMProperty) {
            if (this.attr == null) {
                this.attr = new LinkedHashMap<String, Object>();
            }
            this.attr.put(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append(this.name);
        PIMProperty pIMProperty = this;
        synchronized (pIMProperty) {
            for (Map.Entry<String, Object> entry : this) {
                stringBuilder.append(';');
                stringBuilder.append(entry.getKey());
                stringBuilder.append('=');
                stringBuilder.append(entry.getValue());
            }
        }
        stringBuilder.append(':');
        stringBuilder.append(this.getValueAsString());
        return stringBuilder.toString();
    }

    @Override
    public synchronized Iterator<Map.Entry<String, Object>> iterator() {
        if (this.attr == null) {
            Map map = Collections.emptyMap();
            return map.entrySet().iterator();
        }
        return this.attr.entrySet().iterator();
    }

    protected synchronized String getValueAsString() {
        return this.value == null ? "" : this.value.toString();
    }

    protected void setupAttributes() {
    }

    public static final class TextUTF8
    extends Text {
        public TextUTF8(String string, String string2) {
            super(string, string2);
        }

        @Override
        protected String getValueAsString() {
            String string = (String)this.getValue();
            if (string == null) {
                return "";
            }
            return PIMUtils.escapeText(string);
        }

        @Override
        protected void setupAttributes() {
        }
    }

    public static class Text
    extends PIMProperty<String> {
        public Text(String string, String string2) {
            super(string, string2);
        }

        @Override
        protected String getValueAsString() {
            String string = (String)this.getValue();
            if (TK.isEmpty(string)) {
                return "";
            }
            String string2 = this.getAttribute("ENCODING", null);
            if ("QUOTED-PRINTABLE".equals(string2)) {
                String string3 = this.getAttribute("CHARSET", "US-ASCII");
                try {
                    return new QuotedPrintableCodec(string3).encode(string);
                }
                catch (Exception exception) {
                    MLogger.exception(exception);
                    return "";
                }
            }
            return string;
        }

        @Override
        protected void setupAttributes() {
            this.setAttribute("CHARSET", "UTF-8");
            this.setAttribute("ENCODING", "QUOTED-PRINTABLE");
        }
    }

    public static final class Date
    extends PIMProperty<MDate> {
        public Date(String string, MDate mDate) {
            super(string, mDate == null ? null : new MDate(mDate));
        }

        @Override
        protected String getValueAsString() {
            MDate mDate = (MDate)this.getValue();
            if (mDate == null || !mDate.isValid()) {
                return "";
            }
            return mDate.format("yyyyMMdd'T'HHmmss", Locale.ENGLISH);
        }
    }
}

