/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.pim;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.makagiga.commons.MDate;
import org.makagiga.commons.TK;
import org.makagiga.pim.PIMProperty;

public abstract class PIMEntry
implements Iterable<PIMProperty<?>>,
Serializable {
    private final Map<String, PIMProperty<?>> properties = new LinkedHashMap();
    private final String name;

    public String getName() {
        return this.name;
    }

    public PIMProperty<?> getProperty(String string) {
        return this.properties.get(string);
    }

    public void setProperty(PIMProperty<?> pIMProperty) {
        this.properties.put(pIMProperty.getName(), pIMProperty);
    }

    public <T> T getValue(String string, T t) {
        PIMProperty<?> pIMProperty = this.getProperty(string);
        if (pIMProperty == null) {
            return t;
        }
        return (T)pIMProperty.getValue();
    }

    public <T> PIMProperty<T> setValue(String string, T t) {
        PIMProperty<T> pIMProperty = new PIMProperty<T>(string, t);
        this.properties.put(string, pIMProperty);
        return pIMProperty;
    }

    public PIMProperty.Date setDateValue(String string, MDate mDate) {
        PIMProperty.Date date = new PIMProperty.Date(string, mDate);
        this.setProperty(date);
        return date;
    }

    public PIMProperty.Text setTextValue(String string, String string2) {
        PIMProperty.Text text = new PIMProperty.Text(string, string2);
        this.setProperty(text);
        return text;
    }

    public PIMProperty.TextUTF8 setTextUTF8Value(String string, String string2) {
        PIMProperty.TextUTF8 textUTF8 = new PIMProperty.TextUTF8(string, string2);
        this.setProperty(textUTF8);
        return textUTF8;
    }

    @Override
    public Iterator<PIMProperty<?>> iterator() {
        return this.properties.values().iterator();
    }

    protected PIMEntry(String string) {
        this.name = TK.checkNullOrEmpty(string);
    }
}

