/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.internetsearch;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;
import javax.xml.bind.JAXBException;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMainWindow;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MText;
import org.makagiga.commons.MWebBrowserPanel;
import org.makagiga.commons.SafeMode;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.XMLHelper;
import org.makagiga.internetsearch.InternetSearchPanel;
import org.makagiga.internetsearch.OpenSearchDescription;
import org.makagiga.plugins.AbstractPlugin;
import org.makagiga.plugins.PluginAction;
import org.makagiga.plugins.PluginException;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginManager;
import org.makagiga.plugins.PluginType;

public class InternetSearchPlugin
extends AbstractPlugin<Object> {
    private static boolean initDone;
    private static Config sharedConfig;
    private static File sharedDirectory;
    private static List<PluginInfo> all;
    private static LocalSearchAction localSearchAction;
    private static final Map<String, PluginInfo> lookup;

    @SafeMode
    public static synchronized List<PluginInfo> findAll() {
        if (all == null) {
            all = new MArrayList<PluginInfo>(PluginType.INTERNET_SEARCH.get());
            Config config = InternetSearchPlugin.getSharedConfig();
            for (File file : FS.listFiles(InternetSearchPlugin.getSharedDirectory(), new FS.FileExtensionFilter("xml"))) {
                try {
                    String string = config.read("OpenSearch.file." + file.getName(), null);
                    if (string != null) {
                        OpenSearchDescription openSearchDescription = XMLHelper.unmarshal(OpenSearchDescription.class, file);
                        PluginInfo pluginInfo = InternetSearchPlugin.toPluginInfo(openSearchDescription, string, file);
                        all.add(pluginInfo);
                        continue;
                    }
                    MLogger.warning("plugin", "Plugin ID not found for \"%s\"", file.getName());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    MLogger.exception(fileNotFoundException);
                }
                catch (JAXBException jAXBException) {
                    MLogger.exception(jAXBException);
                }
            }
            XMLHelper.clearContextCache(OpenSearchDescription.class);
            for (PluginInfo pluginInfo : all) {
                lookup.put(pluginInfo.getID(), pluginInfo);
            }
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginInfo findByID(String string) {
        InternetSearchPlugin.findAll();
        Class<InternetSearchPlugin> clazz = InternetSearchPlugin.class;
        synchronized (InternetSearchPlugin.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return lookup.get(string);
        }
    }

    public static synchronized Config getSharedConfig() {
        if (sharedConfig == null) {
            sharedConfig = new Config(FS.makeConfigPath("internetsearch.properties"));
        }
        return sharedConfig;
    }

    public static synchronized File getSharedDirectory() {
        if (sharedDirectory == null) {
            sharedDirectory = FS.makeConfigFile("internetsearch", 1);
        }
        return sharedDirectory;
    }

    public static synchronized void init() {
        if (initDone) {
            return;
        }
        initDone = true;
        PluginManager pluginManager = PluginManager.getInstance();
        pluginManager.registerInternal("org/makagiga/internetsearch/answers");
        pluginManager.registerInternal("org/makagiga/internetsearch/google");
        pluginManager.registerInternal("org/makagiga/internetsearch/wikipedia");
        pluginManager.registerInternal("org/makagiga/internetsearch/yahoo");
        if (((Boolean)Kiosk.actionInternetSearch.get()).booleanValue()) {
            MText.addGlobalMenu(new MText.GlobalMenu(){

                @Override
                public void onGlobalMenu(JTextComponent jTextComponent, MMenu mMenu) {
                    if (jTextComponent instanceof JPasswordField) {
                        return;
                    }
                    String string = jTextComponent.getSelectedText();
                    mMenu.add(InternetSearchPlugin.createSearchMenu(string));
                }
            });
        }
    }

    @Deprecated
    public static LocalSearchAction getLocalSearchAction() {
        return localSearchAction;
    }

    @Deprecated
    public static void setLocalSearchAction(LocalSearchAction localSearchAction) {
        InternetSearchPlugin.localSearchAction = localSearchAction;
    }

    public void search(String string) throws PluginException {
        this.search(string, MWebBrowserPanel.getUseInternalBrowser());
    }

    public void search(String string, boolean bl) throws PluginException {
        this.openURL(this.createURL(string), bl);
    }

    protected String createURL(String string) throws PluginException {
        Config config = this.getConfig();
        String string2 = config.read("x.outputEncoding", "UTF-8");
        String string3 = config.read("x.url", null);
        if (TK.isEmpty(string3)) {
            throw new PluginException("No \"String.x.url\" specified (plugin bug)");
        }
        if (string == null) {
            string = "";
        }
        try {
            MLogger.debug("plugin", "Using \"%s\" output encoding", string2);
            string = URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MLogger.exception(unsupportedEncodingException);
            string = TK.escapeURL(string);
        }
        return string3.replaceFirst("\\{@\\}", string);
    }

    protected void openURL(String string, boolean bl) {
        if (bl) {
            try {
                MWebBrowserPanel.getBrowserLauncher().openURL(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                MLogger.exception(malformedURLException);
                MMainWindow.openURI(string);
            }
        } else {
            MMainWindow.openURI(string);
        }
    }

    private static MMenu createSearchMenu(String string) {
        if (TK.isEmpty(string)) {
            MMenu mMenu = new MMenu(UI._("Internet Search"), "ui/internet");
            mMenu.setEnabled(false);
            return mMenu;
        }
        String string2 = UI._("Search \"{0}\" At", TK.rightSqueeze(string, 15));
        MMenu mMenu = new MMenu(string2, "ui/internet");
        mMenu.setSplitMenu(true);
        for (PluginInfo pluginInfo : InternetSearchPlugin.findAll()) {
            mMenu.add(new InternetSearchAction(pluginInfo, string));
        }
        if (!TK.isEmpty(string) && localSearchAction != null) {
            mMenu.addTitle("Local Search");
            localSearchAction.textToFind = string;
            mMenu.add(localSearchAction);
        }
        if (mMenu.isEmpty()) {
            mMenu.setEnabled(false);
        }
        return mMenu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(PluginInfo pluginInfo) {
        InternetSearchPlugin.findAll().add(pluginInfo);
        Class<InternetSearchPlugin> clazz = InternetSearchPlugin.class;
        synchronized (InternetSearchPlugin.class) {
            lookup.put(pluginInfo.getID(), pluginInfo);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static PluginInfo toPluginInfo(OpenSearchDescription openSearchDescription, String string, File file) {
        PluginInfo pluginInfo = new PluginInfo(string, OpenSearchPlugin.class.getName(), false);
        MIcon mIcon = openSearchDescription.getIcon();
        pluginInfo.setIcon(mIcon);
        if (mIcon != null) {
            pluginInfo.setSmallIcon(mIcon.scaleSmall());
        }
        pluginInfo.setPath(file.getPath());
        pluginInfo.setPluggable(new OpenSearchPlugin(openSearchDescription));
        pluginInfo.bugs.set(openSearchDescription.getContact());
        pluginInfo.copyright.set(openSearchDescription.getAttribution());
        pluginInfo.loaded.yes();
        pluginInfo.longDescription.set(openSearchDescription.getDescription());
        pluginInfo.name.set(openSearchDescription.toString());
        pluginInfo.shortDescription.set(openSearchDescription.getDescription());
        pluginInfo.type.set(PluginType.INTERNET_SEARCH.getType());
        return pluginInfo;
    }

    static {
        lookup = TK.newHashMap();
    }

    static final class OpenSearchPlugin
    extends InternetSearchPlugin {
        private final OpenSearchDescription openSearchDescription;

        @Override
        public void search(String string, boolean bl) throws PluginException {
            if (string == null) {
                string = "";
            }
            String string2 = this.openSearchDescription.formatTemplate(string);
            this.openURL(string2, bl);
        }

        private OpenSearchPlugin(OpenSearchDescription openSearchDescription) {
            this.openSearchDescription = openSearchDescription;
        }
    }

    private static final class InternetSearchAction
    extends PluginAction {
        private final String textToFind;

        @Override
        public void onAction() {
            try {
                PluginInfo pluginInfo = (PluginInfo)this.getData();
                InternetSearchPanel.search(pluginInfo, this.textToFind, MWebBrowserPanel.getUseInternalBrowser());
            }
            catch (PluginException pluginException) {
                MMessage.error(null, pluginException);
            }
        }

        private InternetSearchAction(PluginInfo pluginInfo, String string) {
            super(pluginInfo);
            this.textToFind = string;
        }
    }

    public static abstract class LocalSearchAction
    extends MAction {
        private String textToFind;

        public LocalSearchAction(String string, Icon icon) {
            super(string, icon);
        }

        public String getTextToFind() {
            return this.textToFind;
        }
    }
}

