/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs.feeds;

import java.awt.Color;
import org.makagiga.Tabs;
import org.makagiga.Vars;
import org.makagiga.commons.Config;
import org.makagiga.commons.EnumProperty;
import org.makagiga.commons.Lockable;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MFontButton;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MNumberSpinner;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSmallColorChooser;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.Net;
import org.makagiga.commons.Property;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.editors.Editor;
import org.makagiga.editors.NavigationUtils;
import org.makagiga.feeds.archive.Archive;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.FSException;
import org.makagiga.fs.FSPlugin;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.feeds.FeedDownloader;
import org.makagiga.fs.feeds.FeedViewer;
import org.makagiga.fs.feeds.FeedsFS;
import org.makagiga.plugins.PluginException;
import org.makagiga.plugins.PluginMenu;
import org.makagiga.plugins.PluginOptions;
import org.makagiga.tree.Tree;

public final class FeedsFSPlugin
extends FSPlugin
implements PluginMenu,
PluginOptions<FeedsConfigPanel> {
    private FeedsFS _instance;
    public static final int DEFAULT_FETCH_INTERVAL = 60;
    public static final int MIN_FETCH_INTERVAL = 10;
    public static final int MAX_FETCH_INTERVAL = Integer.MAX_VALUE;

    @Override
    public AbstractFS create() throws Exception {
        if (this._instance != null) {
            throw new IllegalStateException("\"org.makagiga.fs.feeds.FeedsFS\" instance is already created");
        }
        this._instance = new FeedsFS(this.getInfo());
        return this._instance;
    }

    @Override
    public void onDestroy() throws PluginException {
        super.onDestroy();
        FeedDownloader.abortAll();
        Archive.shutDown();
    }

    @Override
    public void onPostInit() throws PluginException {
        MIcon.Name name;
        super.onPostInit();
        if (!((Boolean)Vars.treeReadOnly.get()).booleanValue()) {
            name = new MURLButton.LinkAction(UI._("Add Feed"), "ui/feed"){

                @Override
                public void onAction(String string, String string2) {
                    FeedsFSPlugin.this.addFeed(string);
                }

                @Override
                public boolean isSupported(String string) {
                    return !Net.isLocal(string) && !Net.isMail(string);
                }
            };
            MURLButton.addLinkAction((MURLButton.LinkAction)name);
        }
        if ((name = (FeedsFS)Tree.getInstance().getFS("feeds")) != null) {
            Settings settings = ((FeedsFS)name).reloadSettings();
            ((FeedsFS)name).unreadColor = settings.unreadColor;
            if (settings.fetchOnStartup) {
                ((FeedsFS)name).fetchFeeds(((AbstractFS)name).getRoot(), 1);
            } else {
                ((FeedsFS)name).fetchFeeds(((AbstractFS)name).getRoot(), 4);
            }
        }
    }

    @Override
    public void updateMenu(String string, MMenu mMenu) {
    }

    @Override
    public void updateToolBar(String string, MToolBar mToolBar) {
        if (string.equals("TREE_TOOL_BAR")) {
            mToolBar.add(this._instance.fetchAllFeedsAction);
        }
    }

    @Override
    public FeedsConfigPanel createPluginConfigPanel() {
        return new FeedsConfigPanel();
    }

    @Override
    @Deprecated
    public boolean isVisibleInOptionsDialog() {
        return false;
    }

    @Override
    public void loadPluginConfig(FeedsConfigPanel feedsConfigPanel) {
        Settings settings = this.readGlobalSettings();
        feedsConfigPanel.fetchOnStartup.setSelected(settings.fetchOnStartup);
        feedsConfigPanel.useIntervalFetching.setSelected(settings.useIntervalFetching);
        feedsConfigPanel.minutes.setNumber(settings.minutes);
        feedsConfigPanel.minutes.setEnabled(settings.useIntervalFetching);
        feedsConfigPanel.archive.setDays(settings.removeArticlesAfter, settings.archivePolicy);
        feedsConfigPanel.font.setSelectedFont(FeedViewer.loadFont(this.getGlobalEntry("font")));
        feedsConfigPanel.unreadColor.setColor(settings.unreadColor);
    }

    @Override
    public void savePluginConfig(FeedsConfigPanel feedsConfigPanel) {
        Config config = Config.getDefault();
        config.write(this.getGlobalEntry("fetchOnStartup"), feedsConfigPanel.fetchOnStartup.isSelected());
        config.write(this.getGlobalEntry("useIntervalFetching"), feedsConfigPanel.useIntervalFetching.isSelected());
        config.write(this.getGlobalEntry("fetchInterval"), feedsConfigPanel.minutes.getValue());
        config.write(this.getGlobalEntry("archivePolicy"), feedsConfigPanel.archive.getPolicy().name());
        config.write(this.getGlobalEntry("removeArticlesAfter"), feedsConfigPanel.archive.getDays());
        FeedViewer.saveFont(this.getGlobalEntry("font"), feedsConfigPanel.font.getSelectedFont());
        FeedViewer.applyFont();
        this._instance.unreadColor = feedsConfigPanel.unreadColor.getColor();
        config.write(this.getGlobalEntry("unread"), this._instance.unreadColor);
        this._instance.reloadSettings();
        Tree.getInstance().repaint();
        for (Editor editor : Tabs.getInstance()) {
            if (!(editor instanceof FeedViewer)) continue;
            editor.repaint();
        }
    }

    protected Settings readGlobalSettings() {
        Settings settings = new Settings();
        settings.readAll(Config.getDefault(), this);
        return settings;
    }

    protected synchronized Settings readSettings(MetaInfo metaInfo, boolean bl) {
        Config config = metaInfo.getConfig();
        Settings settings = new Settings();
        settings.archivePolicy = EnumProperty.parse(config.read("x.archivePolicy", null), Archive.Policy.USE_GLOBAL_SETTINGS);
        if (bl && settings.archivePolicy == Archive.Policy.USE_GLOBAL_SETTINGS) {
            settings.readArchive(Config.getDefault(), this);
        } else {
            settings.removeArticlesAfter = config.readInt("x.removeArticlesAfter", 10, 2, 60);
        }
        return settings;
    }

    private void addFeed(String string) {
        AbstractFS abstractFS = Tree.getInstance().getFS("feeds");
        if (abstractFS instanceof FeedsFS) {
            FeedsFS feedsFS = (FeedsFS)abstractFS;
            try {
                feedsFS.newFile(feedsFS.getRoot(), string);
            }
            catch (FSException fSException) {
                MMessage.error(null, fSException, string);
            }
        }
    }

    static FeedsFSPlugin getInstance() {
        AbstractFS abstractFS = Tree.getInstance().getFS("feeds");
        return (FeedsFSPlugin)abstractFS.getInfo().getPluggable();
    }

    private static final class UnreadFilter
    extends NavigationUtils.Filter {
        private UnreadFilter() {
        }

        @Override
        public boolean matches(MetaInfo metaInfo) {
            return metaInfo instanceof FeedsFS.ArticleMetaInfo && ((FeedsFS.ArticleMetaInfo)FeedsFS.ArticleMetaInfo.class.cast(metaInfo)).isNew();
        }
    }

    private static final class NavigationAction
    extends MAction {
        private final boolean next;
        private final UnreadFilter unreadFilter = new UnreadFilter();

        @Override
        public void onAction() {
            MetaInfo metaInfo;
            MetaInfo metaInfo2;
            FeedViewer feedViewer = Tabs.getInstance().findEditor(FeedViewer.class);
            if (feedViewer != null) {
                metaInfo2 = feedViewer.getMetaInfo();
                metaInfo = this.next ? NavigationUtils.getNextFile(metaInfo2, this.unreadFilter) : NavigationUtils.getPreviousFile(metaInfo2, this.unreadFilter);
            } else {
                metaInfo2 = null;
                metaInfo = this.findArticle(null, true);
            }
            if (metaInfo == null && metaInfo2 != null) {
                MLogger.XXX("CURRENT: " + metaInfo2.getClass());
                metaInfo = this.findArticle(metaInfo2, this.next);
            }
            MLogger.XXX(metaInfo);
            if (metaInfo != null) {
                Tree.getInstance().open(metaInfo);
            } else {
                TK.beep();
            }
        }

        private NavigationAction(boolean bl) {
            super(bl ? UI._("Next Unread") : UI._("Previous Unread"), bl ? "ui/next" : "ui/previous", bl ? 93 : 91, 2);
            this.next = bl;
        }

        private FeedsFS.ArticleMetaInfo findArticle(MetaInfo metaInfo, final boolean bl) {
            final Property<MetaInfo> property = new Property<MetaInfo>(metaInfo);
            final Property property2 = new Property();
            new Tree.Scanner(Tree.getInstance().getFS("feeds")){
                private FeedsFS.ArticleMetaInfo lastArticle;

                @Override
                public void processItem(MetaInfo metaInfo) {
                    if (metaInfo instanceof FeedsFS.ArticleMetaInfo) {
                        FeedsFS.ArticleMetaInfo articleMetaInfo = (FeedsFS.ArticleMetaInfo)metaInfo;
                        if (articleMetaInfo.isNew() && (property.isNull() || bl && !property.isNull() && this.lastArticle == property.get() || !bl && !property.isNull() && metaInfo == property.get())) {
                            MLogger.XXX("ARTICLE: " + articleMetaInfo + ", UNREAD:" + articleMetaInfo.isNew());
                            if (bl) {
                                property2.set(articleMetaInfo);
                            } else {
                                property2.set(this.lastArticle);
                            }
                            MLogger.XXX("MATCH=" + metaInfo + ", " + property2);
                            this.stop();
                        }
                        this.lastArticle = articleMetaInfo;
                    }
                }
            };
            return (FeedsFS.ArticleMetaInfo)property2.get();
        }
    }

    protected static final class Settings {
        @Deprecated
        protected boolean showNotification;
        protected boolean fetchOnStartup;
        protected boolean useIntervalFetching;
        protected int minutes;
        protected Archive.Policy archivePolicy;
        protected int removeArticlesAfter;
        protected Color unreadColor;
        static final int DEFAULT_DAYS = 10;
        static final int MAX_DAYS = 60;
        static final int MIN_DAYS = 2;

        protected Settings() {
        }

        protected void readAll(Config config, Config.GlobalEntry globalEntry) {
            this.fetchOnStartup = config.read(globalEntry.getGlobalEntry("fetchOnStartup"), false);
            this.useIntervalFetching = config.read(globalEntry.getGlobalEntry("useIntervalFetching"), false);
            this.minutes = config.readInt(globalEntry.getGlobalEntry("fetchInterval"), 60, 10, Integer.MAX_VALUE);
            this.readArchive(config, globalEntry);
            this.unreadColor = config.readColor(globalEntry.getGlobalEntry("unread"), FeedsFS.DEFAULT_UNREAD_COLOR);
        }

        protected void readArchive(Config config, Config.GlobalEntry globalEntry) {
            this.archivePolicy = EnumProperty.parse(config.read(globalEntry.getGlobalEntry("archivePolicy"), null), Archive.Policy.REMOVE);
            this.removeArticlesAfter = config.readInt(globalEntry.getGlobalEntry("removeArticlesAfter"), 10, 2, 60);
        }
    }

    public static final class FeedsConfigPanel
    extends AbstractPanel {
        private final FeedsFS.ArchiveOptions archive;
        private final MCheckBox fetchOnStartup = new MCheckBox(UI._("Refresh all feeds on startup"));
        private final MCheckBox useIntervalFetching;
        private final MFontButton font;
        private final MNumberSpinner<Integer> minutes;
        private final MSmallColorChooser unreadColor;

        private FeedsConfigPanel() {
            super((String)null, false);
            this.add(this.fetchOnStartup);
            this.addContentGap();
            this.useIntervalFetching = new MCheckBox(UI._("Auto refresh")){

                @Override
                protected void onClick() {
                    FeedsConfigPanel.this.minutes.setEnabled(FeedsConfigPanel.this.useIntervalFetching.isSelected());
                    if (FeedsConfigPanel.this.useIntervalFetching.isSelected()) {
                        FeedsConfigPanel.this.minutes.makeDefault();
                    }
                }
            };
            this.add(this.useIntervalFetching);
            this.minutes = new MNumberSpinner();
            this.minutes.setMaximumWidth(150);
            this.minutes.setRange((Comparable<Integer>)10, (Comparable<Integer>)Integer.MAX_VALUE);
            this.minutes.setToolTipText(UI._("Minutes"));
            this.add(FeedsConfigPanel.createPuzzlePanel(UI._("Every {0} minute(s)"), this.minutes));
            this.addContentGap();
            this.archive = new FeedsFS.ArchiveOptions(false, false);
            this.add(this.archive);
            this.addSeparator(UI._("View"));
            this.font = new MFontButton();
            this.add(this.font);
            this.addContentGap();
            this.unreadColor = new MSmallColorChooser(UI._("Unread Article"));
            this.add(this.unreadColor);
            this.addStretch();
        }
    }

    public static abstract class AbstractPanel
    extends MPanel
    implements Lockable {
        private boolean locked;

        public AbstractPanel(String string, boolean bl) {
            super(1);
            if (bl) {
                this.setContentMargin();
            }
            if (string != null) {
                this.addSeparator(string);
            }
        }

        @Override
        public boolean isLocked() {
            return this.locked;
        }

        @Override
        public void setLocked(boolean bl) {
            this.locked = bl;
        }

        protected boolean shouldRefresh() {
            return false;
        }
    }
}

