/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs.feeds;

import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.swing.Action;
import javax.swing.Icon;
import org.makagiga.MainWindow;
import org.makagiga.Tabs;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.FileCache;
import org.makagiga.commons.Flags;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MCheckBoxTable;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MFileChooser;
import org.makagiga.commons.MHighlighter;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MNotification;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MRadioButton;
import org.makagiga.commons.MSlider;
import org.makagiga.commons.MTabbedPane;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MV;
import org.makagiga.commons.MWebBrowserPanel;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.editors.Editor;
import org.makagiga.feeds.archive.Archive;
import org.makagiga.feeds.archive.ArchiveException;
import org.makagiga.feeds.opml.OPMLReader;
import org.makagiga.feeds.opml.OPMLWriter;
import org.makagiga.fs.AbstractFS;
import org.makagiga.fs.FSDelete;
import org.makagiga.fs.FSDynamic;
import org.makagiga.fs.FSException;
import org.makagiga.fs.FSHelper;
import org.makagiga.fs.FSNewFile;
import org.makagiga.fs.FSNewFolder;
import org.makagiga.fs.FSOpen;
import org.makagiga.fs.FSProperties;
import org.makagiga.fs.FSRenderer;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.feeds.AddFeedDialog;
import org.makagiga.fs.feeds.FeedDownloader;
import org.makagiga.fs.feeds.FeedThread;
import org.makagiga.fs.feeds.FeedViewer;
import org.makagiga.fs.feeds.FeedsFSPlugin;
import org.makagiga.fs.feeds.Filters;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginManager;
import org.makagiga.plugins.PluginMenu;
import org.makagiga.plugins.PluginSettings;
import org.makagiga.tree.ItemRenderer;
import org.makagiga.tree.Tree;

public final class FeedsFS
extends AbstractFS
implements FSDelete,
FSDynamic,
FSNewFile,
FSNewFolder,
FSOpen,
FSProperties,
FSRenderer,
PluginMenu {
    public static final int USE_EXCLUDE_FROM_FETCH_ALL_FEEDS = 1;
    public static final int USE_EXCLUDE_FROM_INTERVAL_FETCH = 2;
    public static final int FETCH_OFFLINE = 4;
    @Deprecated
    protected Color adColor = MHighlighter.DEFAULT_COLOR;
    @Deprecated
    protected Color errorColor = MHighlighter.ERROR_COLOR;
    @Deprecated
    protected Color unreadColor = DEFAULT_UNREAD_COLOR;
    private AddFeedDialog.MainPanel addFeedPanel;
    private ArchiveOptions archiveOptions;
    private CustomAdvancedPanel customAdvancedPanel;
    private MAction filtersAction;
    private MetaInfo currentImportFolder;
    private final MetaInfo _newArticlesFolder;
    private final MTimer intervalFetchTimer;
    static final Color DEFAULT_UNREAD_COLOR = new Color(16773077);
    FetchAllFeedsAction fetchAllFeedsAction = new FetchAllFeedsAction();

    public void fetchFeeds(int n) {
        this.fetchFeeds(this.getRoot(), n);
    }

    public void fetchFeeds(MetaInfo metaInfo, final int n) {
        if (FeedDownloader.isActive()) {
            return;
        }
        new Tree.Scanner(metaInfo){

            @Override
            public void processItem(MetaInfo metaInfo) {
                FeedsFS.this.download(metaInfo, false, n);
            }
        };
        if (FeedDownloader.isActive()) {
            boolean bl = (n & 4) != 0;
            FeedDownloader.setFetchMode(this, false, bl);
        }
    }

    public Color getUnreadColor() {
        return this.unreadColor == null ? DEFAULT_UNREAD_COLOR : this.unreadColor;
    }

    @Override
    public void applyProperties(MetaInfo[] metaInfoArray) {
        if (metaInfoArray.length > 1) {
            return;
        }
        MetaInfo metaInfo = metaInfoArray[0];
        if (!metaInfo.isDynamicFolder() || !(metaInfo.getFS() instanceof FeedsFS)) {
            return;
        }
        if (this.addFeedPanel == null) {
            return;
        }
        Config config = metaInfo.getConfig();
        config.write("x.archivePolicy", this.archiveOptions.getPolicy().name());
        config.write("x.blockImages", this.customAdvancedPanel.blockImagesCheckBox.isSelected());
        config.write("x.excludeFromFetchAllFeeds", this.customAdvancedPanel.excludeFromFetchAllFeeds.isSelected());
        config.write("x.excludeFromIntervalFetch", this.customAdvancedPanel.excludeFromIntervalFetch.isSelected());
        if (MWebBrowserPanel.getUseInternalBrowser()) {
            config.write("x.loadCompleteStory", this.customAdvancedPanel.loadCompleteStoryCheckBox.isSelected());
        }
        config.write("x.removeArticlesAfter", this.archiveOptions.getDays());
        config.write("x.url", this.addFeedPanel.feedURLTextField.getText());
        this.addFeedPanel.feedURLTextField.saveAutoCompletion();
        metaInfo.setProperty("feed.loadCompleteStory", this.customAdvancedPanel.loadCompleteStoryCheckBox.isSelected());
        if (this.customAdvancedPanel.shouldRefresh() || this.addFeedPanel.shouldRefresh()) {
            FeedsFS.refresh(metaInfo);
        }
    }

    @Override
    public void freeProperties() {
        this.addFeedPanel = null;
        this.archiveOptions = null;
        this.customAdvancedPanel = null;
    }

    @Override
    public Flags getMetaInfoCapabilities(MetaInfo metaInfo) {
        return new Flags(63L);
    }

    @Override
    public void initProperties(MTabbedPane<MPanel> mTabbedPane, MetaInfo[] metaInfoArray) {
        if (metaInfoArray.length > 1) {
            return;
        }
        MetaInfo metaInfo = metaInfoArray[0];
        if (!metaInfo.isDynamicFolder() || !(metaInfo.getFS() instanceof FeedsFS)) {
            return;
        }
        this.addFeedPanel = new AddFeedDialog.MainPanel(true, null);
        mTabbedPane.getTabAt(0).add(this.addFeedPanel);
        final Config config = metaInfo.getConfig();
        this.addFeedPanel.originalFeedURL = config.read("x.url", null);
        this.addFeedPanel.feedURLTextField.setText(this.addFeedPanel.originalFeedURL);
        MPanel mPanel = mTabbedPane.getTabAt(2);
        mTabbedPane.setEnabledAt(2, true);
        this.archiveOptions = new ArchiveOptions(true, true);
        FeedsFSPlugin feedsFSPlugin = (FeedsFSPlugin)this.getInfo().getPluggable();
        FeedsFSPlugin.Settings settings = feedsFSPlugin.readSettings(metaInfo, false);
        this.archiveOptions.setDays(settings.removeArticlesAfter, settings.archivePolicy);
        mPanel.add(this.archiveOptions);
        this.customAdvancedPanel = new CustomAdvancedPanel();
        this.customAdvancedPanel.showExpiredArticlesAgainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = config.read("x.url", null);
                    Archive.getInstance().removeExpiredInfo(string);
                }
                catch (ArchiveException archiveException) {
                    MButton mButton = (MButton)actionEvent.getSource();
                    MMessage.error(mButton.getWindowAncestor(), archiveException);
                }
            }
        });
        this.customAdvancedPanel.blockImagesCheckBox.setAndRemember(config.read("x.blockImages", false));
        this.customAdvancedPanel.excludeFromFetchAllFeeds.setSelected(config.read("x.excludeFromFetchAllFeeds", false));
        this.customAdvancedPanel.excludeFromIntervalFetch.setSelected(config.read("x.excludeFromIntervalFetch", false));
        this.customAdvancedPanel.loadCompleteStoryCheckBox.setSelected(config.read("x.loadCompleteStory", false));
        mPanel.add(this.customAdvancedPanel);
    }

    @Override
    public void lockProperties(boolean bl) {
        if (this.addFeedPanel != null) {
            this.addFeedPanel.setLocked(bl);
        }
        if (this.archiveOptions != null) {
            this.archiveOptions.days.setEnabled(!bl);
            this.archiveOptions.doNotRemoveArticles.setEnabled(!bl);
            this.archiveOptions.removeArticles.setEnabled(!bl);
            this.archiveOptions.useGlobalSettings.setEnabled(!bl);
        }
        if (this.customAdvancedPanel != null) {
            this.customAdvancedPanel.blockImagesCheckBox.setEnabled(!bl);
            this.customAdvancedPanel.excludeFromFetchAllFeeds.setEnabled(!bl);
            this.customAdvancedPanel.excludeFromIntervalFetch.setEnabled(!bl);
            this.customAdvancedPanel.loadCompleteStoryCheckBox.setEnabled(MWebBrowserPanel.getUseInternalBrowser() && !bl);
        }
    }

    @Override
    public Icon getNewFileActionIcon(MIcon.Size size) {
        return MIcon.small("ui/feed");
    }

    @Override
    public String getNewFileActionText() {
        return UI._("Add RSS Feed");
    }

    @Override
    public String getNewFileDefaultName() {
        return UI._("New RSS Feed");
    }

    public void markAsRead(MetaInfo metaInfo) {
        if (metaInfo instanceof ArticleMetaInfo) {
            ((ArticleMetaInfo)ArticleMetaInfo.class.cast(metaInfo)).setUnread(false);
        }
    }

    public void markAsUnread(MetaInfo metaInfo) {
        if (metaInfo instanceof ArticleMetaInfo) {
            ((ArticleMetaInfo)ArticleMetaInfo.class.cast(metaInfo)).setUnread(true);
        }
    }

    @Override
    public MetaInfo newFile(MetaInfo metaInfo) throws FSException {
        return this.newFile(metaInfo, null, null);
    }

    @Override
    public Action getNewFileAction() {
        return new MAction(this.getNewFileActionText(), "ui/feed"){

            @Override
            public void onAction() {
                try {
                    FeedsFS.this.newFile(FeedsFS.this.getRoot());
                }
                catch (FSException fSException) {
                    MMessage.error(null, fSException);
                }
            }
        };
    }

    @Override
    public int getNewFileOptions() {
        return 1;
    }

    public MetaInfo newFile(MetaInfo metaInfo, String string) throws FSException {
        return this.newFile(metaInfo, string, null);
    }

    @Deprecated
    public MetaInfo newFile(MetaInfo metaInfo, String string, String string2) throws FSException {
        MainWindow mainWindow = MainWindow.getInstance();
        AddFeedDialog addFeedDialog = new AddFeedDialog((Window)(mainWindow.isActive() ? mainWindow : null), string, this);
        if (!addFeedDialog.exec()) {
            return null;
        }
        String string3 = addFeedDialog.getNewURL();
        if (this.alreadyExists(null, string3)) {
            return null;
        }
        String string4 = FSHelper.getUniqueName(metaInfo.getTargetPath(), addFeedDialog.getNewFileName(), "properties");
        MetaInfo metaInfo2 = this.addDynamicFolder(metaInfo, string4 = FSHelper.removePropertiesSuffix(string4));
        if (metaInfo2 != null) {
            Config config = metaInfo2.getConfig();
            config.write("x.url", string3);
            metaInfo2.sync();
            metaInfo.reload();
            Tree.getInstance().open(metaInfo2);
        }
        return metaInfo2;
    }

    @Override
    public void setMetaInfoProperty(MetaInfo metaInfo, int n, Object object) {
        String string;
        if (!(metaInfo instanceof ArticleMetaInfo)) {
            return;
        }
        ArticleMetaInfo articleMetaInfo = (ArticleMetaInfo)metaInfo;
        switch (n) {
            case 32: {
                string = "category";
                break;
            }
            case 1: {
                string = "color";
                articleMetaInfo.setArticleColor((Color)object);
                break;
            }
            case 16: {
                string = "comment";
                break;
            }
            case 2: {
                string = "icon";
                if (object == null) {
                    metaInfo.clearIcon();
                    break;
                }
                metaInfo.setIconName((String)object);
                break;
            }
            case 4: {
                string = "rating";
                break;
            }
            case 8: {
                string = "tags";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown \"key\" value: " + n);
            }
        }
        String string2 = metaInfo.getParentFolder().getConfig().read("x.url", null);
        String string3 = articleMetaInfo.getArticleID();
        try {
            Archive.getInstance().setItemProperty(string2, string3, new Archive.Property(string, object));
        }
        catch (ArchiveException archiveException) {
            MLogger.exception(archiveException);
        }
    }

    @Override
    public void updateInfo(MetaInfo metaInfo, HTMLBuilder hTMLBuilder) {
        if (metaInfo.isDynamicFolder()) {
            Config config = metaInfo.getConfig();
            MetaInfo.addSeparator(hTMLBuilder);
            MetaInfo.addInfo(hTMLBuilder, UI._("Feed Address:"), TK.centerSqueeze(config.read("x.url", null), 128));
        }
    }

    @Override
    public boolean dynamic(int n, MetaInfo metaInfo) throws FSException {
        return this.download(metaInfo, true, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(int n, MetaInfo metaInfo) throws FSException {
        boolean bl;
        Editor editor;
        Tabs tabs = Tabs.getInstance();
        Tree tree = Tree.getInstance();
        if (!metaInfo.isVirtualFile()) {
            return;
        }
        this.markAsRead(metaInfo);
        if (metaInfo instanceof ArticleMetaInfo) {
            ((ArticleMetaInfo)ArticleMetaInfo.class.cast(metaInfo)).setNew(false);
        }
        MetaInfo metaInfo2 = metaInfo.getParentFolder();
        this.updateInfo(metaInfo2);
        Editor editor2 = null;
        Object object = tabs.iterator();
        while (object.hasNext()) {
            editor = (Editor)object.next();
            if (!(editor instanceof FeedViewer) || editor.getMetaInfo() == null || editor.getMetaInfo().getParentFolder() != metaInfo2) continue;
            editor2 = (FeedViewer)editor;
            if (editor.getMetaInfo() != metaInfo) continue;
            break;
        }
        if (editor2 == null) {
            object = tabs.iterator();
            while (object.hasNext()) {
                editor = (Editor)object.next();
                if (!(editor instanceof FeedViewer)) continue;
                editor2 = (FeedViewer)editor;
                if (editor.getMetaInfo() != metaInfo) continue;
                break;
            }
        }
        if (editor2 != null && (object = editor2.getMetaInfo().getParentFolder()) != null && object != metaInfo2) {
            tree.setExpanded(object, false);
        }
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = bl = editor2 != null && editor2.getMetaInfo() == metaInfo;
        if (editor2 == null || bl2 && !bl) {
            editor2 = new FeedViewer();
            ((FeedViewer)editor2).fs = this;
            editor2.setMetaInfo(metaInfo);
            tabs.addEditor(editor2);
        } else {
            if (!bl) {
                MetaInfo metaInfo3 = editor2.getMetaInfo();
                tabs.addRecentlyClosedTab(metaInfo3);
                metaInfo3.setOpen(false);
                metaInfo3.refresh(true);
                editor2.setMetaInfo(metaInfo);
            }
            metaInfo.setOpen(true);
            tabs.selectEditor(editor2);
            tabs.setTabInfo(metaInfo);
            tabs.fireStateChanged();
        }
        if (!bl) {
            UI.setWaitCursor(true);
            try {
                ((FeedViewer)editor2).loadFromMetaInfo(metaInfo2, metaInfo);
            }
            finally {
                UI.setWaitCursor(false);
            }
        }
        metaInfo.refresh(true);
    }

    @Override
    public void deleteItem(MetaInfo metaInfo, boolean bl) {
        Config config;
        String string;
        if (!bl && metaInfo.isDynamicFolder() && (string = (config = metaInfo.getConfig()).read("x.url", null)) != null) {
            FeedDownloader.abort(metaInfo);
            FileCache.getInstance().removeItem(string);
            if (MNotification.getMessageCount() > 0) {
                MNotification mNotification = MNotification.getInstance();
                for (MNotification.Message message : mNotification) {
                    Action action = message.getAction();
                    if (!(action instanceof FeedThread.Action) || ((FeedThread.Action)FeedThread.Action.class.cast(action)).getParent() != metaInfo) continue;
                    mNotification.hideMessage(message);
                }
            }
        }
    }

    @Override
    public void setupItemRenderer(ItemRenderer itemRenderer, MetaInfo metaInfo, boolean bl, boolean bl2, int n, boolean bl3) {
        if (bl || !(metaInfo instanceof ArticleMetaInfo)) {
            return;
        }
        ArticleMetaInfo articleMetaInfo = (ArticleMetaInfo)metaInfo;
        Color color = articleMetaInfo.getArticleColor();
        if (color != null) {
            metaInfo.setColor(color);
        } else if (articleMetaInfo.isUnread()) {
            metaInfo.setColor(this.getUnreadColor());
        } else {
            metaInfo.setColor(null);
        }
    }

    @Override
    public void updateMenu(String string, MMenu mMenu) {
        if (string.equals("EXPORT_MENU")) {
            mMenu.addSeparator(false);
            MetaInfo metaInfo = Tree.getInstance().getCurrentFolder(true);
            String string2 = metaInfo.isFSRoot() ? UI._("Export All Feeds") : UI._("Export \"{0}\" Feeds", metaInfo);
            mMenu.add(new ExportAction(string2));
        } else if (string.equals("IMPORT_MENU")) {
            mMenu.addSeparator(false);
            mMenu.add(new ImportAction());
            mMenu.add(new ImportFromLifereaAction());
        } else if (string.equals("TREE_MENU")) {
            MetaInfo metaInfo = Tree.getInstance().getCurrentFolder(true);
            if (FeedDownloader.isActive()) {
                mMenu.add(this.fetchAllFeedsAction);
            } else {
                mMenu.add(new FetchFeedsAction(metaInfo));
            }
            if (this.filtersAction == null) {
                this.filtersAction = new Filters.FiltersAction();
            }
            if (metaInfo.getFS() instanceof FeedsFS && metaInfo.isDynamicFolder()) {
                this.filtersAction.setEnabled(metaInfo.isWriteable());
                this.filtersAction.setName(UI._("RSS Filters: {0}", TK.centerSqueeze(metaInfo.toString(), 15)));
            } else {
                this.filtersAction.setEnabled(false);
                this.filtersAction.setName(UI._("RSS Filters..."));
            }
            mMenu.add(this.filtersAction);
        }
    }

    @Override
    public void updateToolBar(String string, MToolBar mToolBar) {
    }

    protected FeedsFS(PluginInfo pluginInfo) throws FSException {
        super(pluginInfo, "feeds", UI._("Feeds"));
        this._newArticlesFolder = MetaInfo.createDummy();
        this.scan();
        Config config = Config.getDefault();
        if (this.getRoot().isEmpty(MV.MODEL) && config.read("Feeds.createSamples", true)) {
            config.write("Feeds.createSamples", false);
            this.addSample("Dilbert Daily Strip", "labels/emotion/happy", "http://feeds.dilbert.com/DilbertDailyStrip");
            this.addSample("Quotes of the Day", null, "http://www.quotationspage.com/data/qotd.rss");
            this.addSample("Slashdot", null, "http://slashdot.org/index.rss");
            config = this.getInfo().getConfig();
            this.addSample(config.read("x.diggName", "error"), null, config.read("x.diggURL", "error"));
            this.addSample(config.read("x.newsName", "error"), null, config.read("x.newsURL", "error"));
        }
        this.intervalFetchTimer = new MTimer(MTimer.Format.MINUTES, 60){

            @Override
            protected boolean onTimeout() {
                FeedsFS.this.fetchFeeds(FeedsFS.this.getRoot(), 2);
                return true;
            }
        };
    }

    @Deprecated
    protected MetaInfo getNewArticlesFolder() {
        return this._newArticlesFolder;
    }

    @Override
    protected void processFile(MetaInfo metaInfo, File file) {
        this.processDynamicFolder(metaInfo, file);
    }

    protected FeedsFSPlugin.Settings reloadSettings() {
        FeedsFSPlugin.Settings settings = ((FeedsFSPlugin)FeedsFSPlugin.class.cast(this.getInfo().getPluggable())).readGlobalSettings();
        this.intervalFetchTimer.setDelay(MTimer.Format.MINUTES, settings.minutes);
        if (settings.useIntervalFetching) {
            this.intervalFetchTimer.restart();
        } else {
            this.intervalFetchTimer.stop();
        }
        return settings;
    }

    protected void updateInfo(MetaInfo metaInfo) {
        int n = 0;
        int n2 = 0;
        for (MetaInfo metaInfo2 : metaInfo.list(MV.MODEL)) {
            if (!(metaInfo2 instanceof ArticleMetaInfo)) continue;
            ArticleMetaInfo articleMetaInfo = (ArticleMetaInfo)metaInfo2;
            if (articleMetaInfo.isNew()) {
                ++n;
            }
            if (!articleMetaInfo.isUnread()) continue;
            ++n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (n > 0) {
            stringBuilder.append(UI._("New: {0}", n));
        }
        if (n2 > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(UI._("Unread: {0}", n2));
        }
        if (stringBuilder.length() == 0) {
            metaInfo.clearProperty("metaInfo.extra.color");
            metaInfo.clearProperty("metaInfo.extra.text");
        } else {
            if (n > 0) {
                metaInfo.setProperty("metaInfo.extra.color", MColor.HOT_ORANGE);
            } else if (n2 > 0) {
                metaInfo.setProperty("metaInfo.extra.color", null);
            } else {
                metaInfo.clearProperty("metaInfo.extra.color");
            }
            metaInfo.setProperty("metaInfo.extra.text", stringBuilder.toString());
        }
        metaInfo.refresh(true);
    }

    private void addSample(String string, String string2, String string3) {
        MetaInfo metaInfo = this.addDynamicFolder(this.getRoot(), string);
        if (metaInfo != null) {
            if (string2 != null) {
                metaInfo.setIconName(string2);
            }
            Config config = metaInfo.getConfig();
            config.write("x.url", string3);
            config.sync();
        }
    }

    private boolean download(MetaInfo metaInfo, boolean bl, int n) {
        if (!metaInfo.isDynamicFolder()) {
            return false;
        }
        Object object = metaInfo.clearProperty("feed.thread");
        if (object instanceof FeedThread) {
            ((FeedThread)FeedThread.class.cast(object)).abort();
            return true;
        }
        Config config = metaInfo.getConfig();
        if ((n & 1) != 0 && config.read("x.excludeFromFetchAllFeeds", false)) {
            return true;
        }
        if ((n & 2) != 0 && config.read("x.excludeFromIntervalFetch", false)) {
            return true;
        }
        Long l = metaInfo.getProperty("feed.lastFetch", null);
        if (l != null && System.currentTimeMillis() - l < TimeUnit.MINUTES.toMillis(1L)) {
            MLogger.debug("feed", "Feed \"%s\" already downloaded", metaInfo);
            if (bl) {
                Tree.getInstance().setExpanded(metaInfo, true);
            }
            return true;
        }
        for (MetaInfo metaInfo2 : metaInfo.list(MV.MODEL)) {
            metaInfo2.setParent(null);
        }
        Tree.getInstance().removeAllChildren(metaInfo);
        boolean bl2 = (n & 4) != 0;
        FeedDownloader.download(this, metaInfo, bl, null, bl2);
        return true;
    }

    private void exportTo(String string) {
        final OPMLWriter oPMLWriter = new OPMLWriter();
        oPMLWriter.beginOPML();
        oPMLWriter.emptyHead();
        oPMLWriter.beginBody();
        new Tree.Scanner(Tree.getInstance().getCurrentFolder(true)){

            @Override
            public void processItem(MetaInfo metaInfo) {
                if (metaInfo.isDynamicFolder()) {
                    Config config = metaInfo.getConfig();
                    oPMLWriter.addOutline(metaInfo.toString(), "xmlUrl", OPMLWriter.escape(config.read("x.url", "")));
                } else if (metaInfo.isFolder()) {
                    oPMLWriter.beginOutline(metaInfo.toString(), new Object[0]);
                }
            }

            @Override
            public void processParent(MetaInfo metaInfo) {
                if (metaInfo.isFolder()) {
                    oPMLWriter.endOutline();
                }
            }
        };
        oPMLWriter.endBody();
        oPMLWriter.endOPML();
        try {
            oPMLWriter.save(string);
        }
        catch (IOException iOException) {
            MMessage.error(null, iOException, UI._("Could not export feeds"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFrom(String string, final MetaInfo metaInfo) {
        this.currentImportFolder = metaInfo;
        try {
            OPMLReader oPMLReader = new OPMLReader(){
                private boolean inEmptyFolder;
                private Map<String, MetaInfo> existingURLs;
                {
                    this.existingURLs = FeedsFS.this.findAllURLs();
                }

                @Override
                protected void onEnd(String string) {
                    super.onEnd(string);
                    if (string.equals("outline") && (this.inEmptyFolder || !this.hasAttributes())) {
                        this.inEmptyFolder = false;
                        MetaInfo metaInfo2 = FeedsFS.this.currentImportFolder.getParentFolder();
                        if (metaInfo2 == null) {
                            FeedsFS.this.currentImportFolder = metaInfo;
                        } else if (metaInfo2.getFS() instanceof FeedsFS) {
                            FeedsFS.this.currentImportFolder = metaInfo2;
                        } else {
                            FeedsFS.this.currentImportFolder = metaInfo;
                        }
                    }
                }

                @Override
                protected void onOutline() {
                    String string = this.getStringAttribute("xmlUrl");
                    if (string == null) {
                        try {
                            FeedsFS.this.currentImportFolder = FeedsFS.this.currentImportFolder.getFS().createUniqueFolder(FeedsFS.this.currentImportFolder, this.getTextAttribute(UI._("Unnamed")));
                            this.inEmptyFolder = true;
                        }
                        catch (FSException fSException) {
                            this.cancel();
                            MMessage.error(null, fSException);
                        }
                    } else if (!FeedsFS.this.alreadyExists(this.existingURLs, string)) {
                        String string2 = FSHelper.getUniqueName(FeedsFS.this.currentImportFolder.getTargetPath(), this.getTextAttribute(UI._("Unnamed")), "properties");
                        Config config = new Config(FS.makePath(FeedsFS.this.currentImportFolder.getTargetPath(), TK.escapeURL(string2)));
                        config.write("x.url", string);
                        config.sync();
                        MetaInfo metaInfo2 = MetaInfo.createDynamicFolder(FeedsFS.this, config.getPath());
                        FeedsFS.this.currentImportFolder.add(metaInfo2);
                        metaInfo2.sync();
                        this.inEmptyFolder = false;
                    }
                }
            };
            oPMLReader.read(string);
        }
        catch (Exception exception) {
            MMessage.error(null, exception, UI._("Could not import feeds"));
        }
        finally {
            this.currentImportFolder = null;
            this.getRoot().reload();
            Tree.getInstance().selectItem(metaInfo, true);
        }
    }

    boolean alreadyExists(Map<String, MetaInfo> map, String string) {
        MetaInfo metaInfo;
        if (map == null) {
            map = this.findAllURLs();
        }
        if ((metaInfo = map.get(string)) != null) {
            FeedThread.showNotification(metaInfo, new FeedThread.ErrorAction(metaInfo, UI._("RSS feed already exists: {0}", string)));
            return true;
        }
        return false;
    }

    Map<String, MetaInfo> findAllURLs() {
        final HashMap<String, MetaInfo> hashMap = new HashMap<String, MetaInfo>();
        new Tree.Scanner(this){

            @Override
            public void processItem(MetaInfo metaInfo) {
                if (metaInfo.isDynamicFolder()) {
                    String string = metaInfo.getConfig().read("x.url", null);
                    if (string == null) {
                        MLogger.debug("feed", "Missing Feed URL: %s", metaInfo.getFilePath());
                    } else {
                        hashMap.put(string, metaInfo);
                    }
                }
            }
        };
        return hashMap;
    }

    static void refresh(MetaInfo metaInfo) {
        metaInfo.clearProperty("feed.lastFetch");
        Tree tree = Tree.getInstance();
        tree.removeAllChildren(metaInfo);
        tree.open(metaInfo);
    }

    private final class ImportFromLifereaAction
    extends AbstractImportAction {
        @Override
        protected File getImportFile() {
            MArrayList<File> mArrayList = new MArrayList<File>();
            String string = FS.getUserDir();
            for (File file : FS.listFiles(string)) {
                if (!file.isDirectory() || !file.getName().startsWith(".liferea")) continue;
                mArrayList.add(file);
            }
            if (mArrayList.isEmpty()) {
                return null;
            }
            mArrayList.sort();
            return new File((File)mArrayList.getLast(), "feedlist.opml");
        }

        private ImportFromLifereaAction() {
            super(UI._("Import Feed List from {0}", "Liferea"), "Liferea");
        }
    }

    private final class ImportAction
    extends AbstractImportAction {
        private ImportAction() {
            super(UI._("Import Feed List"), null);
        }
    }

    private final class FetchFeedsAction
    extends MDataAction<MetaInfo> {
        @Override
        public void onAction() {
            FeedsFS.this.fetchFeeds((MetaInfo)this.getData(), 0);
        }

        private FetchFeedsAction(MetaInfo metaInfo) {
            super(metaInfo, UI._("Refresh Feeds: {0}", TK.centerSqueeze(metaInfo.toString(), 15)), "ui/refresh");
        }
    }

    private final class ExportAction
    extends MAction {
        public ExportAction(String string) {
            super(string, "ui/feed");
        }

        @Override
        public void onAction() {
            MFileChooser mFileChooser = MFileChooser.createFileChooser(null, UI._("Export Feeds"));
            mFileChooser.addFilter("OPML", "opml", "xml");
            mFileChooser.setApproveText(UI._("Export"));
            mFileChooser.setConfigKey("exportFeeds");
            mFileChooser.setSelectedPath("feeds.opml");
            if (mFileChooser.saveDialog()) {
                FeedsFS.this.exportTo(mFileChooser.getSelectedPath());
            }
        }
    }

    private static final class CustomAdvancedPanel
    extends FeedsFSPlugin.AbstractPanel {
        private boolean showExpiredArticlesAgainClicked;
        private final MButton showExpiredArticlesAgainButton;
        private final MCheckBox blockImagesCheckBox;
        private final MCheckBox excludeFromFetchAllFeeds;
        private final MCheckBox excludeFromIntervalFetch;
        private final MCheckBox loadCompleteStoryCheckBox;

        public CustomAdvancedPanel() {
            super(UI._("Miscellaneous"), false);
            this.setMargin(0, this.getContentMargin(), this.getContentMargin(), this.getContentMargin());
            this.blockImagesCheckBox = new MCheckBox(UI._("Block Images"));
            this.add(this.blockImagesCheckBox);
            this.loadCompleteStoryCheckBox = new MCheckBox(UI._("Load the Complete Story when reading article"));
            this.loadCompleteStoryCheckBox.setEnabled(MWebBrowserPanel.getUseInternalBrowser());
            this.loadCompleteStoryCheckBox.setToolTipText(UI._("Uncheck this option if content is displayed incorrectly."));
            this.add(this.loadCompleteStoryCheckBox);
            this.addContentGap();
            this.excludeFromFetchAllFeeds = new MCheckBox(UI._("Exclude from \"Refresh All Feeds\""));
            this.add(this.excludeFromFetchAllFeeds);
            this.excludeFromIntervalFetch = new MCheckBox(UI._("Exclude from \"interval\" fetch"));
            this.add(this.excludeFromIntervalFetch);
            this.addContentGap();
            this.showExpiredArticlesAgainButton = new MButton(UI._("Show Expired Articles Again")){

                @Override
                protected void onClick() {
                    CustomAdvancedPanel.this.showExpiredArticlesAgainClicked = true;
                }
            };
            this.add(this.showExpiredArticlesAgainButton);
            this.addContentGap();
            MButton mButton = new MButton(UI._("Global Settings...")){

                @Override
                protected void onClick() {
                    PluginInfo pluginInfo = PluginManager.getInstance().getByID("{7789ba67-6c7f-4b61-ada2-519099c55a72}");
                    PluginSettings.Panel panel = new PluginSettings.Panel(pluginInfo, null);
                    panel.exec(this.getWindowAncestor());
                }
            };
            mButton.setIconNameUI("ui/feed");
            this.add(mButton);
        }

        @Override
        protected boolean shouldRefresh() {
            return this.showExpiredArticlesAgainClicked || this.blockImagesCheckBox.isModified();
        }
    }

    private abstract class AbstractImportAction
    extends MAction {
        private String newFolderName;

        @Override
        public void onAction() {
            MFileChooser mFileChooser = this.createFileChooser();
            if (mFileChooser.openDialog()) {
                File file = mFileChooser.getSelectedFile();
                if (this.newFolderName == null) {
                    this.newFolderName = file.getName();
                }
                try {
                    FeedsFS.this.importFrom(file.getPath(), this.getTargetFolder());
                }
                catch (FSException fSException) {
                    MMessage.error(null, fSException);
                }
            }
        }

        protected File getImportFile() {
            return null;
        }

        protected MetaInfo getTargetFolder() throws FSException {
            MetaInfo metaInfo = FeedsFS.this.getCurrentFolder(false);
            return FeedsFS.this.createUniqueFolder(metaInfo, UI._("Imported from {0}", this.newFolderName));
        }

        protected MFileChooser createFileChooser() {
            MFileChooser mFileChooser = MFileChooser.createFileChooser(null, UI._("Import Feed List"));
            mFileChooser.addFilter("OPML", "opml", "xml");
            mFileChooser.setApproveText(MActionInfo.IMPORT.getText());
            mFileChooser.setConfigKey("importFeeds");
            File file = this.getImportFile();
            if (file != null) {
                mFileChooser.setSelectedFile(file);
            }
            return mFileChooser;
        }

        private AbstractImportAction(String string, String string2) {
            super(string, "ui/feed");
            this.newFolderName = string2;
        }
    }

    public final class FetchAllFeedsAction
    extends MAction {
        private boolean idle;

        public FetchAllFeedsAction() {
            this.setHTMLHelp(UI._("Download and update all RSS feeds."));
            this.setIdle(true);
        }

        @Override
        public void onAction() {
            if (this.idle) {
                MainWindow.showTree(FeedsFS.this.getRoot());
                FeedsFS.this.fetchFeeds(1);
            } else {
                FeedDownloader.abortAll();
            }
        }

        public void setIdle(boolean bl) {
            this.idle = bl;
            if (bl) {
                this.setName(UI._("Refresh All RSS Feeds"));
                this.setIconName("ui/refresh");
            } else {
                this.setName(UI._("Cancel Refresh"));
                this.setIconName("ui/stop");
            }
        }
    }

    public static final class ArchiveOptions
    extends FeedsFSPlugin.AbstractPanel {
        private final MButton cleanUpArchiveButton;
        private final MRadioButton doNotRemoveArticles;
        private final MRadioButton removeArticles;
        private MRadioButton useGlobalSettings;
        private final MSlider days;

        public ArchiveOptions(boolean bl, boolean bl2) {
            super(UI._("Archive"), bl);
            if (bl2) {
                this.useGlobalSettings = new MRadioButton(UI._("Use global settings"));
                this.add(this.useGlobalSettings);
            }
            this.removeArticles = new MRadioButton();
            this.add(this.removeArticles);
            this.days = new MSlider(){

                @Override
                protected void onChange() {
                    ArchiveOptions.this.removeArticles.setSelected(true);
                    ArchiveOptions.this.updateText();
                }
            };
            this.days.setMinimum(2);
            this.days.setMaximum(60);
            this.days.showSimpleLabels();
            this.days.setEventsEnabled(true);
            this.add(this.days);
            this.removeArticles.onClick(this.days, "requestFocusInWindow");
            this.doNotRemoveArticles = new MRadioButton(UI._("Do not remove old articles (slow)"));
            this.add(this.doNotRemoveArticles);
            UI.group(this.useGlobalSettings, this.removeArticles, this.doNotRemoveArticles);
            this.addGap();
            this.cleanUpArchiveButton = new MButton(UI._("Remove Unused RSS Archives..."), "ui/delete"){

                @Override
                protected void onClick() {
                    ArchiveOptions.this.cleanUpArchive(this);
                }
            };
            this.add(this.cleanUpArchiveButton);
        }

        public Archive.Policy getPolicy() {
            if (this.doNotRemoveArticles.isSelected()) {
                return Archive.Policy.DO_NOT_REMOVE;
            }
            if (this.removeArticles.isSelected()) {
                return Archive.Policy.REMOVE;
            }
            return this.useGlobalSettings == null ? Archive.Policy.REMOVE : Archive.Policy.USE_GLOBAL_SETTINGS;
        }

        public int getDays() {
            return this.days.getValue();
        }

        public void setDays(int n, Archive.Policy policy) {
            this.days.setValue(n);
            switch (policy) {
                case DO_NOT_REMOVE: {
                    this.doNotRemoveArticles.setSelected(true);
                    break;
                }
                case REMOVE: {
                    this.removeArticles.setSelected(true);
                    break;
                }
                case USE_GLOBAL_SETTINGS: {
                    if (this.useGlobalSettings == null) {
                        this.removeArticles.setSelected(true);
                        break;
                    }
                    this.useGlobalSettings.setSelected(true);
                }
            }
            this.updateText();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanUpArchive(MButton mButton) {
            Object object2;
            Archive archive = Archive.getInstance();
            FeedsFS feedsFS = (FeedsFS)Tree.getInstance().getFS("feeds");
            Map<String, MetaInfo> map = feedsFS.findAllURLs();
            Window window = this.getWindowAncestor();
            TreeSet treeSet = new TreeSet();
            for (Object object2 : archive) {
                if (map.containsKey(object2.getKey())) continue;
                treeSet.add(object2.getKey());
            }
            if (treeSet.isEmpty()) {
                mButton.setEnabled(false);
                mButton.setIconName("ui/ok");
                return;
            }
            MCheckBoxTable mCheckBoxTable = new MCheckBoxTable(UI._("Delete"), UI._("Address"), true, treeSet);
            object2 = mCheckBoxTable.createDialog(window, UI._("Remove Unused RSS Archives"), UI._("Items:"), MActionInfo.DELETE);
            if (((MDialog)object2).exec()) {
                if (window != null) {
                    UI.setWaitCursor(window, true);
                }
                try {
                    for (MCheckBoxTable.CheckBoxItem checkBoxItem : (MCheckBoxTable.CheckBoxModel)mCheckBoxTable.getModel()) {
                        if (!checkBoxItem.isSelected()) continue;
                        archive.removeItem(checkBoxItem.getValue());
                    }
                }
                finally {
                    if (window != null) {
                        UI.setWaitCursor(window, false);
                    }
                }
            }
        }

        private void updateText() {
            this.removeArticles.setText(UI._("Automatically remove articles older than {0} day(s)", this.days.getValue()));
        }
    }

    public static final class ArticleMetaInfo
    extends MetaInfo.VirtualFileMetaInfo {
        private int state;
        private static final int UNREAD_STATE = 1;
        private static final int NEW_STATE = 2;
        private Color articleColor;
        private final String articleID;

        public ArticleMetaInfo(AbstractFS abstractFS, String string, String string2) {
            super(abstractFS, string);
            this.articleID = string2;
        }

        public Color getArticleColor() {
            return this.articleColor;
        }

        public void setArticleColor(Color color) {
            this.articleColor = color;
        }

        public String getArticleID() {
            return this.articleID;
        }

        public boolean isNew() {
            return (this.state & 2) != 0;
        }

        public void setNew(boolean bl) {
            this.state = bl ? (this.state |= 2) : (this.state &= 0xFFFFFFFD);
        }

        public boolean isUnread() {
            return (this.state & 1) != 0;
        }

        public void setUnread(boolean bl) {
            this.state = bl ? (this.state |= 1) : (this.state &= 0xFFFFFFFE);
        }
    }
}

