/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.fs;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import org.makagiga.Vars;
import org.makagiga.commons.FS;
import org.makagiga.commons.FileScanner;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.fs.FSAction;
import org.makagiga.fs.FSException;
import org.makagiga.fs.FSHelper;
import org.makagiga.fs.FSNewFolder;
import org.makagiga.fs.MetaInfo;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.tree.AdvancedProperties;
import org.makagiga.tree.NewFolderDialog;
import org.makagiga.tree.Tree;

public abstract class AbstractFS
implements MIcon.Name {
    public static final int MAX_NAME_LENGTH = 128;
    private MetaInfo root;
    private MIcon smallIcon;
    private PluginInfo info;
    private String directory;
    private String id;
    private String name;

    public AbstractFS(PluginInfo pluginInfo) throws FSException {
        this(pluginInfo, pluginInfo.getID(), pluginInfo.toString(), pluginInfo.getIcon());
    }

    public AbstractFS(PluginInfo pluginInfo, String string, String string2) throws FSException {
        this(pluginInfo, string, string2, null);
    }

    public AbstractFS(PluginInfo pluginInfo, String string, String string2, MIcon mIcon) throws FSException {
        this.info = pluginInfo;
        this.id = TK.validateID(string, "(\\w|\\{|\\}|\\-)+");
        this.name = string2;
        this.directory = FS.makeConfigPath(FS.makePath("vfs", string), 1);
        if (!FS.exists(this.directory)) {
            throw new FSException(UI._("Could not initialize directory \"{0}\"", this.directory));
        }
        this.root = MetaInfo.createFSRoot(this, this.getDirectory());
        if (mIcon == null) {
            this.setIcon(pluginInfo.getIcon());
            this.smallIcon = pluginInfo.getSmallIcon();
        } else {
            this.setIcon(mIcon);
            this.smallIcon = this.root.getSmallIcon();
        }
    }

    public MetaInfo addDynamicFolder(MetaInfo metaInfo, String string) {
        return this.addDynamicFolder(metaInfo, string, null);
    }

    public MetaInfo addDynamicFolder(MetaInfo metaInfo, String string, String string2) {
        String string3 = FS.makePath(metaInfo.getTargetPath(), TK.escapeURL(string)) + ".properties";
        MetaInfo metaInfo2 = MetaInfo.createDynamicFolder(this, string3, string2);
        metaInfo.add(metaInfo2);
        return metaInfo2;
    }

    public boolean canImport(MetaInfo metaInfo) {
        if (metaInfo == null) {
            return false;
        }
        if (metaInfo.isVirtualFile()) {
            return false;
        }
        return metaInfo.getFS() == this;
    }

    public MetaInfo createFile(MetaInfo metaInfo, String string, String string2) throws FSException {
        return this.createFile(metaInfo, string, EditorPlugin.findPluginForExtension(string2));
    }

    public MetaInfo createFile(MetaInfo metaInfo, String string, PluginInfo pluginInfo) throws FSException {
        FSHelper.checkName(string);
        FSHelper.checkReadOnly();
        String string2 = FS.makePath(metaInfo.getTargetPath(), TK.escapeURL(string, 1));
        FSHelper.checkIfExists(string2);
        try {
            if (new File(string2).createNewFile()) {
                MetaInfo metaInfo2 = MetaInfo.createFile(this, string2, pluginInfo);
                metaInfo2.setCreatedTime(MDate.now());
                Tree.getInstance().addItem(metaInfo, metaInfo2);
                metaInfo.reload();
                AdvancedProperties.applyPermissions(metaInfo2, true);
                return metaInfo2;
            }
            return null;
        }
        catch (IOException iOException) {
            throw new FSException(UI._("Could not create file"), iOException);
        }
    }

    public MetaInfo createFolder(MetaInfo metaInfo, String string) throws FSException {
        return this.createFolder(metaInfo, string, null, true);
    }

    public MetaInfo createFolder(MetaInfo metaInfo, String string, String string2, boolean bl) throws FSException {
        FSHelper.checkName(string);
        FSHelper.checkReadOnly();
        String string3 = FS.makePath(metaInfo.getTargetPath(), TK.escapeURL(string, 1));
        if (string3.endsWith(".version")) {
            string3 = string3.replaceAll("\\.version$", "%2Eversion");
        }
        if (bl) {
            FSHelper.checkIfExists(string3);
            if (!FS.mkdir(string3)) {
                throw new FSException(UI._("Could not create folder"));
            }
        }
        MetaInfo metaInfo2 = MetaInfo.createFolder(metaInfo.getFS(), string3, string2);
        metaInfo2.setCreatedTime(MDate.now());
        metaInfo2.sync();
        Tree.getInstance().addItem(metaInfo, metaInfo2);
        return metaInfo2;
    }

    public MetaInfo createUniqueFile(MetaInfo metaInfo, String string, PluginInfo pluginInfo) throws FSException {
        return this.createUniqueFile(metaInfo, string, ((EditorPlugin)EditorPlugin.class.cast(pluginInfo.getPluggable())).getDefaultExtension().toString());
    }

    public MetaInfo createUniqueFile(MetaInfo metaInfo, String string, String string2) throws FSException {
        String string3 = FSHelper.getUniqueName(metaInfo.getTargetPath(), string, string2);
        return this.createFile(metaInfo, string3, string2);
    }

    public MetaInfo createUniqueFolder(MetaInfo metaInfo, String string) throws FSException {
        String string2 = FSHelper.getUniqueName(metaInfo.getTargetPath(), string);
        return this.createFolder(metaInfo, string2);
    }

    public void deleteNotify(MetaInfo[] metaInfoArray) {
    }

    public MetaInfo getCurrentFolder(boolean bl) {
        MetaInfo metaInfo = Tree.getInstance().getCurrentFolder(bl);
        if (metaInfo.getFS() != this) {
            metaInfo = this.getRoot();
        }
        return metaInfo;
    }

    public final String getDirectory() {
        return this.directory;
    }

    public MIcon getIcon() {
        return this.root.getIcon();
    }

    public void setIcon(MIcon mIcon) {
        this.root.setIcon(mIcon);
    }

    @Override
    public String getIconName() {
        return MIcon.getName(this.getIcon());
    }

    @Override
    public void setIconName(String string) {
        this.root.setIcon(MIcon.stock(string));
    }

    public final String getID() {
        return this.id;
    }

    public final PluginInfo getInfo() {
        return this.info;
    }

    public final String getName() {
        return this.name;
    }

    public Icon getNewFileActionIcon(MIcon.Size size) {
        return null;
    }

    public final MetaInfo getRoot() {
        return this.root;
    }

    public MIcon getSmallIcon() {
        return this.smallIcon;
    }

    public boolean importMetaInfos(MetaInfo metaInfo, boolean bl, List<MetaInfo> list) {
        try {
            MArrayList<MetaInfo> mArrayList = new MArrayList<MetaInfo>(list.size());
            for (MetaInfo object : list) {
                boolean bl2 = false;
                for (MetaInfo metaInfo2 : list) {
                    if (object == metaInfo2 || !object.isNodeAncestor(metaInfo2)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                mArrayList.add(object);
            }
            int n = 4;
            if (!bl) {
                n |= 2;
            }
            for (Object object : mArrayList) {
                if (FSHelper.copy((MetaInfo)object, metaInfo, n)) continue;
                return false;
            }
            if (bl) {
                try {
                    FSHelper.deleteItems(bl, mArrayList.toArray(MetaInfo.class));
                }
                catch (FSException fSException) {
                    MMessage.error(null, fSException);
                }
            }
            return true;
        }
        catch (FSException fSException) {
            MMessage.error(null, fSException);
            return false;
        }
    }

    public final boolean isPermission(MetaInfo metaInfo, FSAction fSAction) {
        switch (fSAction) {
            case CHANGE_PROPERTIES: {
                if (metaInfo.isMount()) {
                    return !metaInfo.isLocked() && (metaInfo.isAnyFolder() || metaInfo.isFile());
                }
                return metaInfo.canModify() && (metaInfo.isAnyFolder() || metaInfo.isFile());
            }
            case DELETE: 
            case RENAME: {
                if (((Boolean)Vars.treeReadOnly.get()).booleanValue()) {
                    return false;
                }
                if (metaInfo.isMount()) {
                    return !metaInfo.isLocked() && !metaInfo.isFSRoot() && !metaInfo.isVirtualFile();
                }
                return metaInfo.canModify() && !metaInfo.isFSRoot() && !metaInfo.isVirtualFile();
            }
        }
        throw new WTFError(fSAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newFolder(MetaInfo metaInfo) {
        if (!metaInfo.canModify() || !(metaInfo.getFS() instanceof FSNewFolder)) {
            MStatusBar.error(UI._("Cannot create a new item in the selected folder: {0}", metaInfo));
            return;
        }
        NewFolderDialog newFolderDialog = new NewFolderDialog(metaInfo);
        AdvancedProperties advancedProperties = newFolderDialog.getAdvancedProperties();
        if (!newFolderDialog.exec()) {
            advancedProperties.dispose(new Object[0]);
            return;
        }
        String string = newFolderDialog.getFolderName();
        string = FSHelper.getUniqueName(metaInfo.getTargetPath(), string);
        try {
            Tree tree = Tree.getInstance();
            advancedProperties.validateMount();
            MetaInfo metaInfo2 = this.createFolder(metaInfo, string, advancedProperties.getMount(), true);
            metaInfo.reload();
            advancedProperties.apply(metaInfo2);
            if (metaInfo2.isMount()) {
                metaInfo.getFS().scan(metaInfo2, metaInfo2.getMount());
                metaInfo2.reload();
            }
            tree.selectItem(metaInfo2, true);
        }
        catch (FSException fSException) {
            MMessage.error(null, fSException, string);
        }
        finally {
            advancedProperties.dispose(new Object[0]);
        }
    }

    public void refreshNotify(MetaInfo metaInfo, boolean bl) {
    }

    public void scan() {
        this.scan(this, this.root, this.directory);
    }

    public void scan(AbstractFS abstractFS) {
        this.scan(abstractFS, this.root, this.directory);
    }

    public void scan(MetaInfo metaInfo, String string) {
        this.scan(this, metaInfo, string);
    }

    public void scan(final AbstractFS abstractFS, MetaInfo metaInfo, String string) {
        try {
            new FileScanner<MetaInfo, Exception>(metaInfo, new File(string), null){

                @Override
                public MetaInfo processDir(MetaInfo metaInfo, File file) throws Exception {
                    MetaInfo metaInfo2 = MetaInfo.createFolder(abstractFS, file.getPath(), null);
                    if (!FSHelper.isMakagigaFolder(file.getPath())) {
                        MLogger.warning("fs", "Skipping unknown folder: \"%s\"", file.getPath());
                        return metaInfo2;
                    }
                    metaInfo.add(metaInfo2);
                    if (abstractFS == null) {
                        metaInfo2.setFSFromConfig();
                    }
                    if (metaInfo2.isMount()) {
                        AbstractFS.this.scan(abstractFS, metaInfo2, metaInfo2.getMount());
                    }
                    return metaInfo2;
                }

                @Override
                public void processFile(MetaInfo metaInfo, File file) throws Exception {
                    AbstractFS.this.processFile(metaInfo, file);
                }
            };
        }
        catch (Exception exception) {
            MLogger.exception(exception);
        }
    }

    public String toString() {
        return this.name + " (" + this.id + ")";
    }

    protected abstract void processFile(MetaInfo var1, File var2);

    protected MetaInfo processDynamicFolder(MetaInfo metaInfo, File file) {
        return this.processDynamicFolder(this, metaInfo, file);
    }

    protected MetaInfo processDynamicFolder(AbstractFS abstractFS, MetaInfo metaInfo, File file) {
        String string = FS.getExtension(file);
        if ("properties".equals(string)) {
            MetaInfo metaInfo2 = MetaInfo.createDynamicFolder(abstractFS, file.getPath());
            metaInfo.add(metaInfo2);
            if (abstractFS == null) {
                metaInfo2.setFSFromConfig();
            }
            return metaInfo2;
        }
        return null;
    }

    protected MetaInfo processTreeFile(MetaInfo metaInfo, File file) {
        return this.processTreeFile(this, metaInfo, file);
    }

    protected MetaInfo processTreeFile(AbstractFS abstractFS, MetaInfo metaInfo, File file) {
        String string = FS.getExtension(file);
        if (string == null || string.equals("properties") || string.equals("version")) {
            return null;
        }
        MetaInfo metaInfo2 = MetaInfo.createFile(abstractFS, file.getPath(), string);
        metaInfo.add(metaInfo2);
        if (abstractFS == null) {
            metaInfo2.setFSFromConfig();
        }
        return metaInfo2;
    }
}

