/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.feeds;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javax.swing.AbstractButton;
import org.makagiga.commons.HTMLViewFactory;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MComboBox;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.ReferenceCount;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.feeds.Feed;

public final class FeedUtils {
    private static ReferenceCount<String> redirects = new ReferenceCount();

    public static MLabel createAddressTip() {
        MLabel mLabel = new MLabel();
        mLabel.setIcon(MActionInfo.HELP.getIcon());
        mLabel.setHTML(UI._("Enter the address of the feed you want to subscribe.<br>Examples: {0}", "http://feeds.feedburner.com/DilbertDailyStrip, http://makagiga.sf.net, makagiga.sf.net"));
        return mLabel;
    }

    public static String getAddressFromList(Feed feed) {
        String string = null;
        FeedListDialog feedListDialog = new FeedListDialog(feed);
        if (feedListDialog.exec()) {
            string = ((Feed.Link)feedListDialog.list.getSelectedItem()).getHref();
            try {
                feed.setSource(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                feed.setSource(null);
            }
        }
        if (feed.getLinks().size() == 1) {
            redirects.removeReference(feed.getLinks().get(0).getHref());
        }
        return string;
    }

    private FeedUtils() {
    }

    private static final class FeedListDialog
    extends MDialog {
        private final MComboBox<Feed.Link> list;
        private MTimer autoCancelTimer = new MTimer(MTimer.Format.SECONDS, 1){
            private int ticks;
            {
                this.ticks = 10;
            }

            @Override
            protected boolean onTimeout() {
                if (FeedListDialog.this.isClosed()) {
                    return false;
                }
                --this.ticks;
                if (this.ticks == 0) {
                    FeedListDialog.this.reject();
                    return false;
                }
                FeedListDialog.this.changeButton((AbstractButton)FeedListDialog.this.getCancelButton(), UI._("Cancel") + " (" + this.ticks + ")");
                return true;
            }
        };

        @Override
        protected void onClose() {
            super.onClose();
            this.autoCancelTimer = TK.dispose(this.autoCancelTimer);
        }

        private FeedListDialog(Feed feed) {
            super(null, UI._("Feed List"), "ui/feed");
            this.changeButton((AbstractButton)this.getOKButton(), UI._("Use Selected Feed"));
            this.addNorth(new MLabel(UI._("\"{0}\" contains a list of feeds", feed.getSource())));
            this.list = new MComboBox();
            this.list.addAllItems((Collection<Feed.Link>)feed.getLinks());
            if (this.list.getItemCount() == 1) {
                this.list.setEnabled(false);
            }
            this.addCenter(MPanel.createVLabelPanel(this.list, UI._("Feeds:")));
            this.packFixed();
            this.setDefaultFocus(this.list.isEnabled() ? this.list : this.getOKButton());
            int n = feed.getLinks().size() == 1 ? redirects.addReference(feed.getLinks().get(0).getHref()) : 0;
            if (n > 1) {
                this.autoCancelTimer.start();
                MMouseAdapter mMouseAdapter = new MMouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        if (FeedListDialog.this.autoCancelTimer.isRunning() && !FeedListDialog.this.isClosed()) {
                            FeedListDialog.this.autoCancelTimer.stop();
                            FeedListDialog.this.changeButton((AbstractButton)FeedListDialog.this.getCancelButton(), UI._("Cancel"));
                        }
                    }
                };
                this.getCancelButton().addMouseListener(mMouseAdapter);
            }
        }
    }

    public static class BlockImageFactory
    implements HTMLViewFactory.ImageFactory {
        private static BufferedImage blockedImage;
        private Policy policy;

        public BlockImageFactory() {
            this(Policy.BLOCK_TRACKING_IMAGES);
        }

        public BlockImageFactory(Policy policy) {
            this.policy = TK.checkNull(policy);
            if (blockedImage == null) {
                blockedImage = UI.createCompatibleImage(1, 1, true);
            }
        }

        @Override
        public Image getImage(HTMLViewFactory.ImageDownloader imageDownloader, URL uRL) throws Exception {
            switch (this.policy) {
                case NO_BLOCK: {
                    return null;
                }
                case BLOCK_ALL_IMAGES: {
                    MLogger.info("feeds", "Blocked image: %s", uRL);
                    return blockedImage;
                }
                case BLOCK_TRACKING_IMAGES: {
                    String string = uRL.toString();
                    if (string.startsWith("https://blogger.googleusercontent.com/tracker/") || string.startsWith("http://feeds.feedburner.com/~ff/") || string.startsWith("http://feeds.feedburner.com/~r/") || string.startsWith("http://feedads.g.doubleclick.net/") || string.startsWith("http://stats.wordpress.com/b.gif?")) {
                        MLogger.info("feeds", "Blocked tracking image: " + string);
                        return blockedImage;
                    }
                    return null;
                }
            }
            throw new WTFError(this.policy);
        }

        public Policy getPolicy() {
            return this.policy;
        }

        public void setPolicy(Policy policy) {
            this.policy = TK.checkNull(policy);
        }

        public static enum Policy {
            NO_BLOCK,
            BLOCK_ALL_IMAGES,
            BLOCK_TRACKING_IMAGES;

        }
    }
}

