/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.feeds;

import java.awt.Color;
import java.beans.ConstructorProperties;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MComboBox;
import org.makagiga.commons.MHTMLViewer;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MTaskPanel;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.feeds.AbstractChannel;
import org.makagiga.feeds.Feed;
import org.makagiga.feeds.FeedListException;
import org.makagiga.feeds.FeedUtils;
import org.makagiga.feeds.archive.Archive;
import org.makagiga.feeds.archive.ArchiveItem;

public class FeedComponent
extends MTaskPanel<Object> {
    private boolean fullTextVisible;
    private ChannelInfo channelInfo;
    private int archiveFlags;
    private int articleLimit;
    private int newItems;
    private MComboBox<ArchiveItem> comboBox;
    private MHTMLViewer viewer;
    private MPanel viewerPanel = MPanel.createBorderPanel(5);
    private MURLButton linkButton;
    private String styleSheet;
    private Type type;

    public FeedComponent() {
        this(Type.HTML_LIST);
    }

    @ConstructorProperties(value={"type"})
    public FeedComponent(Type type) {
        this.setFrontComponent(this.viewerPanel);
        this.setType(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        FeedComponent feedComponent = this;
        synchronized (feedComponent) {
            this.channelInfo = null;
        }
        this.cancel(true);
    }

    public synchronized void download(String string) {
        this.cancel();
        this.setComponentsEnabled(false, null);
        this.channelInfo = new ChannelInfo(new Feed(), string);
        this.start();
    }

    public int getArchiveFlags() {
        return this.archiveFlags;
    }

    public void setArchiveFlags(int n) {
        this.archiveFlags = n;
    }

    public int getArticleLimit() {
        return this.articleLimit;
    }

    public void setArticleLimit(int n) {
        this.articleLimit = n;
    }

    public ChannelInfo getChannelInfo() {
        return this.channelInfo;
    }

    public MComboBox<ArchiveItem> getComboBox() {
        return this.comboBox;
    }

    public MURLButton getLinkButton() {
        return this.linkButton;
    }

    public int getNewItemCount() {
        return this.newItems;
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public void setStyleSheet(String string) {
        this.styleSheet = string;
    }

    @Override
    public String getTitle() {
        if (this.channelInfo != null && this.channelInfo.channel != null && this.channelInfo.channel.isTitlePresent()) {
            return this.channelInfo.channel.getTitle();
        }
        return UI._("Feed");
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (!TK.isChange((Object)this.type, (Object)type)) {
            return;
        }
        this.type = type;
        this.viewerPanel.removeAll();
        if (this.type == Type.COMBO_BOX || this.type == Type.COMBO_BOX_AND_VIEWER) {
            this.comboBox = new MComboBox<ArchiveItem>(){

                @Override
                protected void onSelect() {
                    ArchiveItem archiveItem = (ArchiveItem)this.getSelectedItem();
                    if (FeedComponent.this.viewer != null) {
                        if (archiveItem == null) {
                            FeedComponent.this.viewer.clear();
                        } else {
                            FeedComponent.this.setHTML(archiveItem.getText());
                        }
                    }
                    if (archiveItem != null && archiveItem.isLinkPresent()) {
                        FeedComponent.this.linkButton.setText(UI._("Complete Story"));
                        FeedComponent.this.linkButton.setURL(archiveItem.getLink());
                        FeedComponent.this.linkButton.setVisible(true);
                    } else {
                        FeedComponent.this.linkButton.setVisible(false);
                    }
                }
            };
            this.viewerPanel.addNorth(MPanel.createHLabelPanel(this.comboBox, UI._("Articles:")));
            this.linkButton = new MURLButton();
            this.linkButton.setSecureOpen(true);
            this.viewerPanel.addSouth(this.linkButton);
        }
        if (this.type == Type.COMBO_BOX_AND_VIEWER || this.type == Type.HTML_LIST) {
            this.viewer = new MHTMLViewer();
            this.viewer.setSecureOpen(true);
            this.viewerPanel.addCenter(this.viewer, 2);
        }
        if (this.type == Type.HTML_LIST) {
            this.viewer.setStyle("background-color: white; color: black; margin: 0; padding: 0");
        }
        if (this.channelInfo != null && this.channelInfo.channel != null && this.channelInfo.archiveItems != null) {
            this.showItems(this.channelInfo.channel, this.channelInfo.archiveItems);
        }
    }

    public String getURL() {
        return this.channelInfo == null ? null : this.channelInfo.url;
    }

    public void setURL(String string) {
        if (TK.isChange(this.getURL(), string)) {
            this.download(string);
        }
    }

    public MHTMLViewer getViewer() {
        return this.viewer;
    }

    public boolean isFullTextVisible() {
        return this.fullTextVisible;
    }

    public void setFullTextVisible(boolean bl) {
        this.fullTextVisible = bl;
    }

    @Override
    protected Object doInBackground() throws Exception {
        this.channelInfo.channel = this.channelInfo.feed.download(this.channelInfo.url);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done() {
        if (this.isCancelled()) {
            this.setComponentsEnabled(true, null);
            if (this.channelInfo != null) {
                this.channelInfo.feed.cancelDownload();
            }
        } else {
            String string = null;
            try {
                this.getResult();
                Archive archive = Archive.getInstance();
                this.newItems = 0;
                Feed feed = this.channelInfo.feed;
                URL uRL = feed.getSource();
                this.channelInfo.archiveItems = archive.merge(uRL.toString(), this.channelInfo.channel, this.archiveFlags);
                if (this.channelInfo.archiveItems != null) {
                    for (ArchiveItem archiveItem : this.channelInfo.archiveItems) {
                        if (!archiveItem.isNew()) continue;
                        ++this.newItems;
                    }
                    this.showItems(this.channelInfo.channel, this.channelInfo.archiveItems);
                }
                this.setComponentsEnabled(true, string);
            }
            catch (Exception exception) {
                try {
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof FeedListException) {
                        String string2 = FeedUtils.getAddressFromList(((FeedListException)FeedListException.class.cast(throwable)).getFeed());
                        if (string2 != null) {
                            this.download(string2);
                        } else {
                            string = UI._("Error");
                        }
                    } else {
                        if (MLogger.isDeveloper()) {
                            MLogger.exception(exception);
                        }
                        string = TK.buildErrorMessage(throwable == null ? exception : throwable);
                    }
                    this.setComponentsEnabled(true, string);
                }
                catch (Throwable throwable) {
                    this.setComponentsEnabled(true, string);
                    throw throwable;
                }
            }
        }
    }

    protected void setComponentsEnabled(boolean bl, String string) {
        if (this.comboBox != null) {
            this.comboBox.setEnabled(bl);
        }
        if (this.linkButton != null) {
            this.linkButton.setEnabled(bl);
        }
        if (this.viewer != null) {
            this.viewer.setEnabled(bl);
        }
        if (bl && string != null) {
            this.setErrorMessage(string);
        }
    }

    protected void showItems(AbstractChannel<?> abstractChannel, List<ArchiveItem> list) {
        switch (this.type) {
            case COMBO_BOX: 
            case COMBO_BOX_AND_VIEWER: {
                this.showItemsInComboBox(abstractChannel, list);
                break;
            }
            case HTML_LIST: {
                this.showItemsInHTMLList(abstractChannel, list);
                break;
            }
            default: {
                throw new WTFError(this.type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showItemsInComboBox(AbstractChannel<?> abstractChannel, List<ArchiveItem> list) {
        if (this.comboBox == null) {
            return;
        }
        this.comboBox.setEventsEnabled(false);
        try {
            this.comboBox.removeAllItems();
        }
        finally {
            this.comboBox.setEventsEnabled(true);
        }
        if (!list.isEmpty()) {
            if (this.articleLimit < 1) {
                this.comboBox.addAllItems((Collection<ArchiveItem>)list);
            } else {
                this.comboBox.addAllItems((Collection<ArchiveItem>)list.subList(0, Math.min(list.size(), this.articleLimit)));
            }
        }
    }

    protected void showItemsInHTMLList(AbstractChannel<?> abstractChannel, List<ArchiveItem> list) {
        if (this.viewer == null) {
            return;
        }
        Color color = MColor.deriveColor(Color.WHITE, 0.98f);
        Color color2 = MColor.deriveColor(Color.WHITE, 0.92f);
        HTMLBuilder hTMLBuilder = new HTMLBuilder();
        hTMLBuilder.beginHTML();
        hTMLBuilder.beginStyle();
        hTMLBuilder.beginRule("a");
        hTMLBuilder.addAttr("text-decoration", "none");
        hTMLBuilder.endRule();
        hTMLBuilder.beginRule("td.article1");
        hTMLBuilder.addAttr("background-color", color);
        hTMLBuilder.endRule();
        hTMLBuilder.beginRule("td.article2");
        hTMLBuilder.addAttr("background-color", color2);
        hTMLBuilder.endRule();
        if (this.styleSheet != null) {
            hTMLBuilder.appendLine(this.styleSheet);
        }
        hTMLBuilder.endStyle();
        hTMLBuilder.beginDoc();
        hTMLBuilder.beginTag("table", "cellpadding", 5, "cellspacing", 0, "width", "100%");
        boolean bl = false;
        List<ArchiveItem> list2 = list;
        if (!list.isEmpty() && this.articleLimit > 0) {
            list2 = list.subList(0, Math.min(list.size(), this.articleLimit));
        }
        for (ArchiveItem archiveItem : list2) {
            bl = !bl;
            String string = archiveItem.isNew() ? "font-weight: bold" : "";
            String string2 = bl ? "article1" : "article2";
            String string3 = TK.centerSqueeze(archiveItem.toString(), 128);
            hTMLBuilder.beginTag("tr");
            hTMLBuilder.doubleTag("td", HTMLBuilder.createLink(archiveItem.getLink(), string3), "class", string2, "style", string);
            hTMLBuilder.endTag("tr");
            if (!this.fullTextVisible) continue;
            hTMLBuilder.beginTag("tr");
            hTMLBuilder.doubleTag("td", archiveItem.getText(), "class", string2);
            hTMLBuilder.endTag("tr");
        }
        hTMLBuilder.endTag("table");
        hTMLBuilder.endDoc();
        this.setHTML(hTMLBuilder.toString());
    }

    private void setHTML(String string) {
        this.viewer.installCache(3);
        this.viewer.getImageDownloader().setImageFactory(new FeedUtils.BlockImageFactory());
        this.viewer.setHTML(string);
    }

    public static final class ChannelInfo {
        private AbstractChannel<?> channel;
        private final Feed feed;
        private List<ArchiveItem> archiveItems;
        private final String url;

        public AbstractChannel<?> getChannel() {
            return this.channel;
        }

        public Feed getFeed() {
            return this.feed;
        }

        public String getURL() {
            return this.url;
        }

        private ChannelInfo(Feed feed, String string) {
            this.feed = feed;
            this.url = string;
        }
    }

    public static enum Type {
        COMBO_BOX,
        COMBO_BOX_AND_VIEWER,
        HTML_LIST;

    }
}

