/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.feeds;

import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.bind.annotation.XmlAttribute;
import org.makagiga.commons.FS;
import org.makagiga.commons.MDownloadDialog;
import org.makagiga.commons.MFormat;
import org.makagiga.commons.MObject;
import org.makagiga.commons.Net;
import org.makagiga.commons.TK;

public class Enclosure {
    private long length;
    private String type;
    private String url;

    public void download(Window window, File file) throws IOException {
        URL uRL;
        String string = FS.getExtension((uRL = this.toURL()).getPath());
        Net.DownloadInfo downloadInfo = new Net.DownloadInfo(uRL, string == null ? null : "." + string, 6);
        downloadInfo.setDestinationFile(file);
        MDownloadDialog.download(window, downloadInfo);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Enclosure)) {
            return false;
        }
        Enclosure enclosure = (Enclosure)object;
        return this.length == enclosure.length && MObject.safeEquals(this.type, enclosure.type) && MObject.safeEquals(this.url, enclosure.url);
    }

    public int hashCode() {
        int n = MObject.hashCode(this.type, this.url);
        n = 31 * n + (int)this.length;
        return n;
    }

    @XmlAttribute(name="length")
    public long getLength() {
        return this.length;
    }

    public void setLength(long l) {
        this.length = l;
    }

    @XmlAttribute(name="type")
    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    @XmlAttribute(name="url")
    public String getURL() {
        return this.url;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public String toString() {
        if (this.length == 0L) {
            return String.format("%s (%s)", TK.centerSqueeze(this.url, 100), this.type);
        }
        return String.format("%s (%s, %s)", TK.centerSqueeze(this.url, 100), MFormat.toAutoSize(this.length), this.type);
    }

    public URL toURL() throws MalformedURLException {
        return new URL(this.url);
    }
}

